/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: DatabasePackage.java,v 1.2 2008/06/16 13:56:08 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.database;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.thalesgroup.marte.rapidrma.database.DatabaseFactory
 * @model kind="package"
 * @generated
 */
public interface DatabasePackage extends EPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "database";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.thalesgroup.com/marte/rapidrma/database.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "com.thalesgroup.marte.rapidrma.database";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	DatabasePackage eINSTANCE = com.thalesgroup.marte.rapidrma.database.impl.DatabasePackageImpl.init();

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl <em>Database</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl
	 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabasePackageImpl#getDatabase()
	 * @generated
	 */
	int DATABASE = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Algorithm</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE__ALGORITHM = 1;

	/**
	 * The feature id for the '<em><b>Task Graph Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE__TASK_GRAPH_SIZE = 2;

	/**
	 * The feature id for the '<em><b>Prority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE__PRORITY = 3;

	/**
	 * The feature id for the '<em><b>Priority Mapping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE__PRIORITY_MAPPING = 4;

	/**
	 * The feature id for the '<em><b>Analysis</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE__ANALYSIS = 5;

	/**
	 * The feature id for the '<em><b>Task</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE__TASK = 6;

	/**
	 * The feature id for the '<em><b>Resource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE__RESOURCE = 7;

	/**
	 * The number of structural features of the '<em>Database</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_FEATURE_COUNT = 8;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.database.AlgorithmKind <em>Algorithm Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.database.AlgorithmKind
	 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabasePackageImpl#getAlgorithmKind()
	 * @generated
	 */
	int ALGORITHM_KIND = 1;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.database.PriorityKind <em>Priority Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.database.PriorityKind
	 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabasePackageImpl#getPriorityKind()
	 * @generated
	 */
	int PRIORITY_KIND = 2;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.database.PriorityMappingKind <em>Priority Mapping Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.database.PriorityMappingKind
	 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabasePackageImpl#getPriorityMappingKind()
	 * @generated
	 */
	int PRIORITY_MAPPING_KIND = 3;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.database.AnalysisKind <em>Analysis Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.database.AnalysisKind
	 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabasePackageImpl#getAnalysisKind()
	 * @generated
	 */
	int ANALYSIS_KIND = 4;


	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.database.Database <em>Database</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Database</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.Database
	 * @generated
	 */
	EClass getDatabase();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.database.Database#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.Database#getName()
	 * @see #getDatabase()
	 * @generated
	 */
	EAttribute getDatabase_Name();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.database.Database#getAlgorithm <em>Algorithm</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Algorithm</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.Database#getAlgorithm()
	 * @see #getDatabase()
	 * @generated
	 */
	EAttribute getDatabase_Algorithm();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.database.Database#getTaskGraphSize <em>Task Graph Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Task Graph Size</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.Database#getTaskGraphSize()
	 * @see #getDatabase()
	 * @generated
	 */
	EAttribute getDatabase_TaskGraphSize();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.database.Database#getPrority <em>Prority</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Prority</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.Database#getPrority()
	 * @see #getDatabase()
	 * @generated
	 */
	EAttribute getDatabase_Prority();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.database.Database#getPriorityMapping <em>Priority Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Priority Mapping</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.Database#getPriorityMapping()
	 * @see #getDatabase()
	 * @generated
	 */
	EAttribute getDatabase_PriorityMapping();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.database.Database#getAnalysis <em>Analysis</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Analysis</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.Database#getAnalysis()
	 * @see #getDatabase()
	 * @generated
	 */
	EAttribute getDatabase_Analysis();

	/**
	 * Returns the meta object for the reference '{@link com.thalesgroup.marte.rapidrma.database.Database#getTask <em>Task</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Task</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.Database#getTask()
	 * @see #getDatabase()
	 * @generated
	 */
	EReference getDatabase_Task();

	/**
	 * Returns the meta object for the reference '{@link com.thalesgroup.marte.rapidrma.database.Database#getResource <em>Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Resource</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.Database#getResource()
	 * @see #getDatabase()
	 * @generated
	 */
	EReference getDatabase_Resource();

	/**
	 * Returns the meta object for enum '{@link com.thalesgroup.marte.rapidrma.database.AlgorithmKind <em>Algorithm Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Algorithm Kind</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.AlgorithmKind
	 * @generated
	 */
	EEnum getAlgorithmKind();

	/**
	 * Returns the meta object for enum '{@link com.thalesgroup.marte.rapidrma.database.PriorityKind <em>Priority Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Priority Kind</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.PriorityKind
	 * @generated
	 */
	EEnum getPriorityKind();

	/**
	 * Returns the meta object for enum '{@link com.thalesgroup.marte.rapidrma.database.PriorityMappingKind <em>Priority Mapping Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Priority Mapping Kind</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.PriorityMappingKind
	 * @generated
	 */
	EEnum getPriorityMappingKind();

	/**
	 * Returns the meta object for enum '{@link com.thalesgroup.marte.rapidrma.database.AnalysisKind <em>Analysis Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Analysis Kind</em>'.
	 * @see com.thalesgroup.marte.rapidrma.database.AnalysisKind
	 * @generated
	 */
	EEnum getAnalysisKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DatabaseFactory getDatabaseFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl <em>Database</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl
		 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabasePackageImpl#getDatabase()
		 * @generated
		 */
		EClass DATABASE = eINSTANCE.getDatabase();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE__NAME = eINSTANCE.getDatabase_Name();

		/**
		 * The meta object literal for the '<em><b>Algorithm</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE__ALGORITHM = eINSTANCE.getDatabase_Algorithm();

		/**
		 * The meta object literal for the '<em><b>Task Graph Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE__TASK_GRAPH_SIZE = eINSTANCE.getDatabase_TaskGraphSize();

		/**
		 * The meta object literal for the '<em><b>Prority</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE__PRORITY = eINSTANCE.getDatabase_Prority();

		/**
		 * The meta object literal for the '<em><b>Priority Mapping</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE__PRIORITY_MAPPING = eINSTANCE.getDatabase_PriorityMapping();

		/**
		 * The meta object literal for the '<em><b>Analysis</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE__ANALYSIS = eINSTANCE.getDatabase_Analysis();

		/**
		 * The meta object literal for the '<em><b>Task</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATABASE__TASK = eINSTANCE.getDatabase_Task();

		/**
		 * The meta object literal for the '<em><b>Resource</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATABASE__RESOURCE = eINSTANCE.getDatabase_Resource();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.database.AlgorithmKind <em>Algorithm Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.database.AlgorithmKind
		 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabasePackageImpl#getAlgorithmKind()
		 * @generated
		 */
		EEnum ALGORITHM_KIND = eINSTANCE.getAlgorithmKind();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.database.PriorityKind <em>Priority Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.database.PriorityKind
		 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabasePackageImpl#getPriorityKind()
		 * @generated
		 */
		EEnum PRIORITY_KIND = eINSTANCE.getPriorityKind();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.database.PriorityMappingKind <em>Priority Mapping Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.database.PriorityMappingKind
		 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabasePackageImpl#getPriorityMappingKind()
		 * @generated
		 */
		EEnum PRIORITY_MAPPING_KIND = eINSTANCE.getPriorityMappingKind();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.database.AnalysisKind <em>Analysis Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.database.AnalysisKind
		 * @see com.thalesgroup.marte.rapidrma.database.impl.DatabasePackageImpl#getAnalysisKind()
		 * @generated
		 */
		EEnum ANALYSIS_KIND = eINSTANCE.getAnalysisKind();

	}

} //DatabasePackage
