/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: DatabaseImpl.java,v 1.2 2008/06/16 13:56:08 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.database.impl;

import com.thalesgroup.marte.rapidrma.database.AlgorithmKind;
import com.thalesgroup.marte.rapidrma.database.AnalysisKind;
import com.thalesgroup.marte.rapidrma.database.Database;
import com.thalesgroup.marte.rapidrma.database.DatabasePackage;
import com.thalesgroup.marte.rapidrma.database.PriorityKind;
import com.thalesgroup.marte.rapidrma.database.PriorityMappingKind;

import com.thalesgroup.marte.rapidrma.resource.ResourceGraph;
import com.thalesgroup.marte.rapidrma.resource.ResourcePackage;

import com.thalesgroup.marte.rapidrma.task.TaskGraph;
import com.thalesgroup.marte.rapidrma.task.TaskPackage;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Database</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl#getName <em>Name</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl#getAlgorithm <em>Algorithm</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl#getTaskGraphSize <em>Task Graph Size</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl#getPrority <em>Prority</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl#getPriorityMapping <em>Priority Mapping</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl#getAnalysis <em>Analysis</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl#getTask <em>Task</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.impl.DatabaseImpl#getResource <em>Resource</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DatabaseImpl extends EObjectImpl implements Database {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getAlgorithm() <em>Algorithm</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAlgorithm()
	 * @generated
	 * @ordered
	 */
	protected static final AlgorithmKind ALGORITHM_EDEFAULT = AlgorithmKind.RM_PCP_LITERAL;

	/**
	 * The cached value of the '{@link #getAlgorithm() <em>Algorithm</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAlgorithm()
	 * @generated
	 * @ordered
	 */
	protected AlgorithmKind algorithm = ALGORITHM_EDEFAULT;

	/**
	 * The default value of the '{@link #getTaskGraphSize() <em>Task Graph Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTaskGraphSize()
	 * @generated
	 * @ordered
	 */
	protected static final int TASK_GRAPH_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTaskGraphSize() <em>Task Graph Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTaskGraphSize()
	 * @generated
	 * @ordered
	 */
	protected int taskGraphSize = TASK_GRAPH_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getPrority() <em>Prority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrority()
	 * @generated
	 * @ordered
	 */
	protected static final PriorityKind PRORITY_EDEFAULT = PriorityKind.DEFAULT_LITERAL;

	/**
	 * The cached value of the '{@link #getPrority() <em>Prority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrority()
	 * @generated
	 * @ordered
	 */
	protected PriorityKind prority = PRORITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getPriorityMapping() <em>Priority Mapping</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPriorityMapping()
	 * @generated
	 * @ordered
	 */
	protected static final PriorityMappingKind PRIORITY_MAPPING_EDEFAULT = PriorityMappingKind.DEFAULT_LITERAL;

	/**
	 * The cached value of the '{@link #getPriorityMapping() <em>Priority Mapping</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPriorityMapping()
	 * @generated
	 * @ordered
	 */
	protected PriorityMappingKind priorityMapping = PRIORITY_MAPPING_EDEFAULT;

	/**
	 * The default value of the '{@link #getAnalysis() <em>Analysis</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnalysis()
	 * @generated
	 * @ordered
	 */
	protected static final AnalysisKind ANALYSIS_EDEFAULT = AnalysisKind.SINGLE_NODE_LITERAL;

	/**
	 * The cached value of the '{@link #getAnalysis() <em>Analysis</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnalysis()
	 * @generated
	 * @ordered
	 */
	protected AnalysisKind analysis = ANALYSIS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTask() <em>Task</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTask()
	 * @generated
	 * @ordered
	 */
	protected TaskGraph task = null;

	/**
	 * The cached value of the '{@link #getResource() <em>Resource</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResource()
	 * @generated
	 * @ordered
	 */
	protected ResourceGraph resource = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DatabaseImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return DatabasePackage.Literals.DATABASE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DatabasePackage.DATABASE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AlgorithmKind getAlgorithm() {
		return algorithm;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAlgorithm(AlgorithmKind newAlgorithm) {
		AlgorithmKind oldAlgorithm = algorithm;
		algorithm = newAlgorithm == null ? ALGORITHM_EDEFAULT : newAlgorithm;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DatabasePackage.DATABASE__ALGORITHM, oldAlgorithm, algorithm));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTaskGraphSize() {
		return taskGraphSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTaskGraphSize(int newTaskGraphSize) {
		int oldTaskGraphSize = taskGraphSize;
		taskGraphSize = newTaskGraphSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DatabasePackage.DATABASE__TASK_GRAPH_SIZE, oldTaskGraphSize, taskGraphSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PriorityKind getPrority() {
		return prority;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPrority(PriorityKind newPrority) {
		PriorityKind oldPrority = prority;
		prority = newPrority == null ? PRORITY_EDEFAULT : newPrority;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DatabasePackage.DATABASE__PRORITY, oldPrority, prority));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PriorityMappingKind getPriorityMapping() {
		return priorityMapping;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPriorityMapping(PriorityMappingKind newPriorityMapping) {
		PriorityMappingKind oldPriorityMapping = priorityMapping;
		priorityMapping = newPriorityMapping == null ? PRIORITY_MAPPING_EDEFAULT : newPriorityMapping;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DatabasePackage.DATABASE__PRIORITY_MAPPING, oldPriorityMapping, priorityMapping));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AnalysisKind getAnalysis() {
		return analysis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAnalysis(AnalysisKind newAnalysis) {
		AnalysisKind oldAnalysis = analysis;
		analysis = newAnalysis == null ? ANALYSIS_EDEFAULT : newAnalysis;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DatabasePackage.DATABASE__ANALYSIS, oldAnalysis, analysis));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TaskGraph getTask() {
		if (task != null && task.eIsProxy()) {
			InternalEObject oldTask = (InternalEObject)task;
			task = (TaskGraph)eResolveProxy(oldTask);
			if (task != oldTask) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DatabasePackage.DATABASE__TASK, oldTask, task));
			}
		}
		return task;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TaskGraph basicGetTask() {
		return task;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTask(TaskGraph newTask, NotificationChain msgs) {
		TaskGraph oldTask = task;
		task = newTask;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DatabasePackage.DATABASE__TASK, oldTask, newTask);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTask(TaskGraph newTask) {
		if (newTask != task) {
			NotificationChain msgs = null;
			if (task != null)
				msgs = ((InternalEObject)task).eInverseRemove(this, TaskPackage.TASK_GRAPH__DB, TaskGraph.class, msgs);
			if (newTask != null)
				msgs = ((InternalEObject)newTask).eInverseAdd(this, TaskPackage.TASK_GRAPH__DB, TaskGraph.class, msgs);
			msgs = basicSetTask(newTask, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DatabasePackage.DATABASE__TASK, newTask, newTask));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceGraph getResource() {
		if (resource != null && resource.eIsProxy()) {
			InternalEObject oldResource = (InternalEObject)resource;
			resource = (ResourceGraph)eResolveProxy(oldResource);
			if (resource != oldResource) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DatabasePackage.DATABASE__RESOURCE, oldResource, resource));
			}
		}
		return resource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceGraph basicGetResource() {
		return resource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetResource(ResourceGraph newResource, NotificationChain msgs) {
		ResourceGraph oldResource = resource;
		resource = newResource;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DatabasePackage.DATABASE__RESOURCE, oldResource, newResource);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setResource(ResourceGraph newResource) {
		if (newResource != resource) {
			NotificationChain msgs = null;
			if (resource != null)
				msgs = ((InternalEObject)resource).eInverseRemove(this, ResourcePackage.RESOURCE_GRAPH__DB, ResourceGraph.class, msgs);
			if (newResource != null)
				msgs = ((InternalEObject)newResource).eInverseAdd(this, ResourcePackage.RESOURCE_GRAPH__DB, ResourceGraph.class, msgs);
			msgs = basicSetResource(newResource, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DatabasePackage.DATABASE__RESOURCE, newResource, newResource));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DatabasePackage.DATABASE__TASK:
				if (task != null)
					msgs = ((InternalEObject)task).eInverseRemove(this, TaskPackage.TASK_GRAPH__DB, TaskGraph.class, msgs);
				return basicSetTask((TaskGraph)otherEnd, msgs);
			case DatabasePackage.DATABASE__RESOURCE:
				if (resource != null)
					msgs = ((InternalEObject)resource).eInverseRemove(this, ResourcePackage.RESOURCE_GRAPH__DB, ResourceGraph.class, msgs);
				return basicSetResource((ResourceGraph)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DatabasePackage.DATABASE__TASK:
				return basicSetTask(null, msgs);
			case DatabasePackage.DATABASE__RESOURCE:
				return basicSetResource(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DatabasePackage.DATABASE__NAME:
				return getName();
			case DatabasePackage.DATABASE__ALGORITHM:
				return getAlgorithm();
			case DatabasePackage.DATABASE__TASK_GRAPH_SIZE:
				return new Integer(getTaskGraphSize());
			case DatabasePackage.DATABASE__PRORITY:
				return getPrority();
			case DatabasePackage.DATABASE__PRIORITY_MAPPING:
				return getPriorityMapping();
			case DatabasePackage.DATABASE__ANALYSIS:
				return getAnalysis();
			case DatabasePackage.DATABASE__TASK:
				if (resolve) return getTask();
				return basicGetTask();
			case DatabasePackage.DATABASE__RESOURCE:
				if (resolve) return getResource();
				return basicGetResource();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DatabasePackage.DATABASE__NAME:
				setName((String)newValue);
				return;
			case DatabasePackage.DATABASE__ALGORITHM:
				setAlgorithm((AlgorithmKind)newValue);
				return;
			case DatabasePackage.DATABASE__TASK_GRAPH_SIZE:
				setTaskGraphSize(((Integer)newValue).intValue());
				return;
			case DatabasePackage.DATABASE__PRORITY:
				setPrority((PriorityKind)newValue);
				return;
			case DatabasePackage.DATABASE__PRIORITY_MAPPING:
				setPriorityMapping((PriorityMappingKind)newValue);
				return;
			case DatabasePackage.DATABASE__ANALYSIS:
				setAnalysis((AnalysisKind)newValue);
				return;
			case DatabasePackage.DATABASE__TASK:
				setTask((TaskGraph)newValue);
				return;
			case DatabasePackage.DATABASE__RESOURCE:
				setResource((ResourceGraph)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case DatabasePackage.DATABASE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case DatabasePackage.DATABASE__ALGORITHM:
				setAlgorithm(ALGORITHM_EDEFAULT);
				return;
			case DatabasePackage.DATABASE__TASK_GRAPH_SIZE:
				setTaskGraphSize(TASK_GRAPH_SIZE_EDEFAULT);
				return;
			case DatabasePackage.DATABASE__PRORITY:
				setPrority(PRORITY_EDEFAULT);
				return;
			case DatabasePackage.DATABASE__PRIORITY_MAPPING:
				setPriorityMapping(PRIORITY_MAPPING_EDEFAULT);
				return;
			case DatabasePackage.DATABASE__ANALYSIS:
				setAnalysis(ANALYSIS_EDEFAULT);
				return;
			case DatabasePackage.DATABASE__TASK:
				setTask((TaskGraph)null);
				return;
			case DatabasePackage.DATABASE__RESOURCE:
				setResource((ResourceGraph)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DatabasePackage.DATABASE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case DatabasePackage.DATABASE__ALGORITHM:
				return algorithm != ALGORITHM_EDEFAULT;
			case DatabasePackage.DATABASE__TASK_GRAPH_SIZE:
				return taskGraphSize != TASK_GRAPH_SIZE_EDEFAULT;
			case DatabasePackage.DATABASE__PRORITY:
				return prority != PRORITY_EDEFAULT;
			case DatabasePackage.DATABASE__PRIORITY_MAPPING:
				return priorityMapping != PRIORITY_MAPPING_EDEFAULT;
			case DatabasePackage.DATABASE__ANALYSIS:
				return analysis != ANALYSIS_EDEFAULT;
			case DatabasePackage.DATABASE__TASK:
				return task != null;
			case DatabasePackage.DATABASE__RESOURCE:
				return resource != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", algorithm: ");
		result.append(algorithm);
		result.append(", taskGraphSize: ");
		result.append(taskGraphSize);
		result.append(", prority: ");
		result.append(prority);
		result.append(", priorityMapping: ");
		result.append(priorityMapping);
		result.append(", analysis: ");
		result.append(analysis);
		result.append(')');
		return result.toString();
	}

} //DatabaseImpl