/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: DatabasePackageImpl.java,v 1.2 2008/06/16 13:56:08 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.database.impl;

import com.thalesgroup.marte.rapidrma.database.AlgorithmKind;
import com.thalesgroup.marte.rapidrma.database.AnalysisKind;
import com.thalesgroup.marte.rapidrma.database.Database;
import com.thalesgroup.marte.rapidrma.database.DatabaseFactory;
import com.thalesgroup.marte.rapidrma.database.DatabasePackage;
import com.thalesgroup.marte.rapidrma.database.PriorityKind;
import com.thalesgroup.marte.rapidrma.database.PriorityMappingKind;

import com.thalesgroup.marte.rapidrma.resource.ResourcePackage;

import com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl;

import com.thalesgroup.marte.rapidrma.task.TaskPackage;

import com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class DatabasePackageImpl extends EPackageImpl implements DatabasePackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass databaseEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum algorithmKindEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum priorityKindEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum priorityMappingKindEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum analysisKindEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private DatabasePackageImpl() {
		super(eNS_URI, DatabaseFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static DatabasePackage init() {
		if (isInited) return (DatabasePackage)EPackage.Registry.INSTANCE.getEPackage(DatabasePackage.eNS_URI);

		// Obtain or create and register package
		DatabasePackageImpl theDatabasePackage = (DatabasePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof DatabasePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new DatabasePackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		TaskPackageImpl theTaskPackage = (TaskPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(TaskPackage.eNS_URI) instanceof TaskPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(TaskPackage.eNS_URI) : TaskPackage.eINSTANCE);
		ResourcePackageImpl theResourcePackage = (ResourcePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ResourcePackage.eNS_URI) instanceof ResourcePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ResourcePackage.eNS_URI) : ResourcePackage.eINSTANCE);

		// Create package meta-data objects
		theDatabasePackage.createPackageContents();
		theTaskPackage.createPackageContents();
		theResourcePackage.createPackageContents();

		// Initialize created meta-data
		theDatabasePackage.initializePackageContents();
		theTaskPackage.initializePackageContents();
		theResourcePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theDatabasePackage.freeze();

		return theDatabasePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDatabase() {
		return databaseEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDatabase_Name() {
		return (EAttribute)databaseEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDatabase_Algorithm() {
		return (EAttribute)databaseEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDatabase_TaskGraphSize() {
		return (EAttribute)databaseEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDatabase_Prority() {
		return (EAttribute)databaseEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDatabase_PriorityMapping() {
		return (EAttribute)databaseEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDatabase_Analysis() {
		return (EAttribute)databaseEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDatabase_Task() {
		return (EReference)databaseEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDatabase_Resource() {
		return (EReference)databaseEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getAlgorithmKind() {
		return algorithmKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getPriorityKind() {
		return priorityKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getPriorityMappingKind() {
		return priorityMappingKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getAnalysisKind() {
		return analysisKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DatabaseFactory getDatabaseFactory() {
		return (DatabaseFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		databaseEClass = createEClass(DATABASE);
		createEAttribute(databaseEClass, DATABASE__NAME);
		createEAttribute(databaseEClass, DATABASE__ALGORITHM);
		createEAttribute(databaseEClass, DATABASE__TASK_GRAPH_SIZE);
		createEAttribute(databaseEClass, DATABASE__PRORITY);
		createEAttribute(databaseEClass, DATABASE__PRIORITY_MAPPING);
		createEAttribute(databaseEClass, DATABASE__ANALYSIS);
		createEReference(databaseEClass, DATABASE__TASK);
		createEReference(databaseEClass, DATABASE__RESOURCE);

		// Create enums
		algorithmKindEEnum = createEEnum(ALGORITHM_KIND);
		priorityKindEEnum = createEEnum(PRIORITY_KIND);
		priorityMappingKindEEnum = createEEnum(PRIORITY_MAPPING_KIND);
		analysisKindEEnum = createEEnum(ANALYSIS_KIND);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		TaskPackage theTaskPackage = (TaskPackage)EPackage.Registry.INSTANCE.getEPackage(TaskPackage.eNS_URI);
		ResourcePackage theResourcePackage = (ResourcePackage)EPackage.Registry.INSTANCE.getEPackage(ResourcePackage.eNS_URI);

		// Add supertypes to classes

		// Initialize classes and features; add operations and parameters
		initEClass(databaseEClass, Database.class, "Database", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDatabase_Name(), ecorePackage.getEString(), "name", null, 1, 1, Database.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getDatabase_Algorithm(), this.getAlgorithmKind(), "algorithm", null, 1, 1, Database.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getDatabase_TaskGraphSize(), ecorePackage.getEInt(), "taskGraphSize", null, 1, 1, Database.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getDatabase_Prority(), this.getPriorityKind(), "prority", null, 1, 1, Database.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getDatabase_PriorityMapping(), this.getPriorityMappingKind(), "priorityMapping", null, 1, 1, Database.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getDatabase_Analysis(), this.getAnalysisKind(), "analysis", null, 1, 1, Database.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getDatabase_Task(), theTaskPackage.getTaskGraph(), theTaskPackage.getTaskGraph_Db(), "task", null, 0, 1, Database.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getDatabase_Resource(), theResourcePackage.getResourceGraph(), theResourcePackage.getResourceGraph_Db(), "resource", null, 0, 1, Database.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(algorithmKindEEnum, AlgorithmKind.class, "AlgorithmKind");
		addEEnumLiteral(algorithmKindEEnum, AlgorithmKind.RM_PCP_LITERAL);
		addEEnumLiteral(algorithmKindEEnum, AlgorithmKind.RM_SBP_LITERAL);
		addEEnumLiteral(algorithmKindEEnum, AlgorithmKind.RM_BIP_LITERAL);
		addEEnumLiteral(algorithmKindEEnum, AlgorithmKind.RM_DASPCP_LITERAL);
		addEEnumLiteral(algorithmKindEEnum, AlgorithmKind.DM_PCP_LITERAL);
		addEEnumLiteral(algorithmKindEEnum, AlgorithmKind.DM_SBP_LITERAL);
		addEEnumLiteral(algorithmKindEEnum, AlgorithmKind.DM_BIP_LITERAL);
		addEEnumLiteral(algorithmKindEEnum, AlgorithmKind.DM_DASPCP_LITERAL);
		addEEnumLiteral(algorithmKindEEnum, AlgorithmKind.CYCLIC_EXECUTIVE_LITERAL);
		addEEnumLiteral(algorithmKindEEnum, AlgorithmKind.ROSA_RM_PCP_LITERAL);
		addEEnumLiteral(algorithmKindEEnum, AlgorithmKind.ROSA_DM_PCP_LITERAL);

		initEEnum(priorityKindEEnum, PriorityKind.class, "PriorityKind");
		addEEnumLiteral(priorityKindEEnum, PriorityKind.DEFAULT_LITERAL);
		addEEnumLiteral(priorityKindEEnum, PriorityKind.USER_SPECIFIED_LITERAL);

		initEEnum(priorityMappingKindEEnum, PriorityMappingKind.class, "PriorityMappingKind");
		addEEnumLiteral(priorityMappingKindEEnum, PriorityMappingKind.DEFAULT_LITERAL);
		addEEnumLiteral(priorityMappingKindEEnum, PriorityMappingKind.USER_SPECIFIED_LITERAL);

		initEEnum(analysisKindEEnum, AnalysisKind.class, "AnalysisKind");
		addEEnumLiteral(analysisKindEEnum, AnalysisKind.SINGLE_NODE_LITERAL);
		addEEnumLiteral(analysisKindEEnum, AnalysisKind.MULTIPLE_NODE_LITERAL);
		addEEnumLiteral(analysisKindEEnum, AnalysisKind.END_TO_END_LITERAL);

		// Create resource
		createResource(eNS_URI);
	}

} //DatabasePackageImpl
