/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: CPU.java,v 1.2 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.resource;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>CPU</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.CPU#getProcessingRate <em>Processing Rate</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.CPU#getContextSwRate <em>Context Sw Rate</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.CPU#getPriorityMapping <em>Priority Mapping</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.CPU#getMappingKind <em>Mapping Kind</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getCPU()
 * @model
 * @generated
 */
public interface CPU extends Resource {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Processing Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Processing Rate</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Processing Rate</em>' attribute.
	 * @see #setProcessingRate(String)
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getCPU_ProcessingRate()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	String getProcessingRate();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.resource.CPU#getProcessingRate <em>Processing Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Processing Rate</em>' attribute.
	 * @see #getProcessingRate()
	 * @generated
	 */
	void setProcessingRate(String value);

	/**
	 * Returns the value of the '<em><b>Context Sw Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Context Sw Rate</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Context Sw Rate</em>' attribute.
	 * @see #setContextSwRate(String)
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getCPU_ContextSwRate()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	String getContextSwRate();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.resource.CPU#getContextSwRate <em>Context Sw Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Context Sw Rate</em>' attribute.
	 * @see #getContextSwRate()
	 * @generated
	 */
	void setContextSwRate(String value);

	/**
	 * Returns the value of the '<em><b>Priority Mapping</b></em>' containment reference list.
	 * The list contents are of type {@link com.thalesgroup.marte.rapidrma.resource.Range}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Priority Mapping</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Priority Mapping</em>' containment reference list.
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getCPU_PriorityMapping()
	 * @model type="com.thalesgroup.marte.rapidrma.resource.Range" containment="true" ordered="false"
	 * @generated
	 */
	EList getPriorityMapping();

	/**
	 * Returns the value of the '<em><b>Mapping Kind</b></em>' attribute.
	 * The literals are from the enumeration {@link com.thalesgroup.marte.rapidrma.resource.PriorityMappingKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mapping Kind</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mapping Kind</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.resource.PriorityMappingKind
	 * @see #setMappingKind(PriorityMappingKind)
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getCPU_MappingKind()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	PriorityMappingKind getMappingKind();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.resource.CPU#getMappingKind <em>Mapping Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mapping Kind</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.resource.PriorityMappingKind
	 * @see #getMappingKind()
	 * @generated
	 */
	void setMappingKind(PriorityMappingKind value);

} // CPU