/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: Node.java,v 1.2 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.resource;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Node</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.Node#getAccesses <em>Accesses</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.Node#getResource <em>Resource</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.Node#getName <em>Name</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.Node#getComments <em>Comments</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getNode()
 * @model
 * @generated
 */
public interface Node extends EObject {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Accesses</b></em>' reference list.
	 * The list contents are of type {@link com.thalesgroup.marte.rapidrma.resource.SharedResource}.
	 * It is bidirectional and its opposite is '{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getAccessedBy <em>Accessed By</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Accesses</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Accesses</em>' reference list.
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getNode_Accesses()
	 * @see com.thalesgroup.marte.rapidrma.resource.SharedResource#getAccessedBy
	 * @model type="com.thalesgroup.marte.rapidrma.resource.SharedResource" opposite="accessedBy" ordered="false"
	 * @generated
	 */
	EList getAccesses();

	/**
	 * Returns the value of the '<em><b>Resource</b></em>' containment reference list.
	 * The list contents are of type {@link com.thalesgroup.marte.rapidrma.resource.Resource}.
	 * It is bidirectional and its opposite is '{@link com.thalesgroup.marte.rapidrma.resource.Resource#getNode <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Resource</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Resource</em>' containment reference list.
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getNode_Resource()
	 * @see com.thalesgroup.marte.rapidrma.resource.Resource#getNode
	 * @model type="com.thalesgroup.marte.rapidrma.resource.Resource" opposite="node" containment="true" ordered="false"
	 * @generated
	 */
	EList getResource();

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getNode_Name()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.resource.Node#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Comments</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Comments</em>' attribute.
	 * @see #setComments(String)
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getNode_Comments()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	String getComments();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.resource.Node#getComments <em>Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Comments</em>' attribute.
	 * @see #getComments()
	 * @generated
	 */
	void setComments(String value);

} // Node