/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: ResourcePackage.java,v 1.2 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.resource;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.thalesgroup.marte.rapidrma.resource.ResourceFactory
 * @model kind="package"
 * @generated
 */
public interface ResourcePackage extends EPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "resource";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.thalesgroup.com/marte/rapidrma/resource.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "com.thalesgroup.marte.rapidrma.resource";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ResourcePackage eINSTANCE = com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl.init();

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.ResourceGraphImpl <em>Graph</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourceGraphImpl
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getResourceGraph()
	 * @generated
	 */
	int RESOURCE_GRAPH = 0;

	/**
	 * The feature id for the '<em><b>Node</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE_GRAPH__NODE = 0;

	/**
	 * The feature id for the '<em><b>Db</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE_GRAPH__DB = 1;

	/**
	 * The number of structural features of the '<em>Graph</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE_GRAPH_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.NodeImpl <em>Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.NodeImpl
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getNode()
	 * @generated
	 */
	int NODE = 1;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__ACCESSES = 0;

	/**
	 * The feature id for the '<em><b>Resource</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__RESOURCE = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__NAME = 2;

	/**
	 * The feature id for the '<em><b>Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__COMMENTS = 3;

	/**
	 * The number of structural features of the '<em>Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.ResourceImpl <em>Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourceImpl
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getResource()
	 * @generated
	 */
	int RESOURCE = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE__COMMENTS = 1;

	/**
	 * The feature id for the '<em><b>Node</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE__NODE = 2;

	/**
	 * The number of structural features of the '<em>Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.SharedResourceImpl <em>Shared Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.SharedResourceImpl
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getSharedResource()
	 * @generated
	 */
	int SHARED_RESOURCE = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_RESOURCE__NAME = RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_RESOURCE__COMMENTS = RESOURCE__COMMENTS;

	/**
	 * The feature id for the '<em><b>Node</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_RESOURCE__NODE = RESOURCE__NODE;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_RESOURCE__TYPE = RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Acq Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_RESOURCE__ACQ_TIME = RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>De Acq Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_RESOURCE__DE_ACQ_TIME = RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Conflicting</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_RESOURCE__CONFLICTING = RESOURCE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Accessed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_RESOURCE__ACCESSED_BY = RESOURCE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Shared Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_RESOURCE_FEATURE_COUNT = RESOURCE_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.CPUImpl <em>CPU</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.CPUImpl
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getCPU()
	 * @generated
	 */
	int CPU = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU__NAME = RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU__COMMENTS = RESOURCE__COMMENTS;

	/**
	 * The feature id for the '<em><b>Node</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU__NODE = RESOURCE__NODE;

	/**
	 * The feature id for the '<em><b>Processing Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU__PROCESSING_RATE = RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Context Sw Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU__CONTEXT_SW_RATE = RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Priority Mapping</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU__PRIORITY_MAPPING = RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mapping Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU__MAPPING_KIND = RESOURCE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>CPU</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_FEATURE_COUNT = RESOURCE_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.RangeImpl <em>Range</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.RangeImpl
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getRange()
	 * @generated
	 */
	int RANGE = 4;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE__START = 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE__END = 1;

	/**
	 * The number of structural features of the '<em>Range</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.resource.ResourceKind <em>Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourceKind
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getResourceKind()
	 * @generated
	 */
	int RESOURCE_KIND = 6;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.resource.PriorityMappingKind <em>Priority Mapping Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.resource.PriorityMappingKind
	 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getPriorityMappingKind()
	 * @generated
	 */
	int PRIORITY_MAPPING_KIND = 7;


	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.resource.ResourceGraph <em>Graph</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Graph</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourceGraph
	 * @generated
	 */
	EClass getResourceGraph();

	/**
	 * Returns the meta object for the containment reference list '{@link com.thalesgroup.marte.rapidrma.resource.ResourceGraph#getNode <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Node</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourceGraph#getNode()
	 * @see #getResourceGraph()
	 * @generated
	 */
	EReference getResourceGraph_Node();

	/**
	 * Returns the meta object for the reference '{@link com.thalesgroup.marte.rapidrma.resource.ResourceGraph#getDb <em>Db</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Db</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourceGraph#getDb()
	 * @see #getResourceGraph()
	 * @generated
	 */
	EReference getResourceGraph_Db();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.resource.Node <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Node</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Node
	 * @generated
	 */
	EClass getNode();

	/**
	 * Returns the meta object for the reference list '{@link com.thalesgroup.marte.rapidrma.resource.Node#getAccesses <em>Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Accesses</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Node#getAccesses()
	 * @see #getNode()
	 * @generated
	 */
	EReference getNode_Accesses();

	/**
	 * Returns the meta object for the containment reference list '{@link com.thalesgroup.marte.rapidrma.resource.Node#getResource <em>Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Resource</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Node#getResource()
	 * @see #getNode()
	 * @generated
	 */
	EReference getNode_Resource();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.Node#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Node#getName()
	 * @see #getNode()
	 * @generated
	 */
	EAttribute getNode_Name();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.Node#getComments <em>Comments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comments</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Node#getComments()
	 * @see #getNode()
	 * @generated
	 */
	EAttribute getNode_Comments();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.resource.SharedResource <em>Shared Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Shared Resource</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.SharedResource
	 * @generated
	 */
	EClass getSharedResource();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.SharedResource#getType()
	 * @see #getSharedResource()
	 * @generated
	 */
	EAttribute getSharedResource_Type();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getAcqTime <em>Acq Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Acq Time</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.SharedResource#getAcqTime()
	 * @see #getSharedResource()
	 * @generated
	 */
	EAttribute getSharedResource_AcqTime();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getDeAcqTime <em>De Acq Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>De Acq Time</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.SharedResource#getDeAcqTime()
	 * @see #getSharedResource()
	 * @generated
	 */
	EAttribute getSharedResource_DeAcqTime();

	/**
	 * Returns the meta object for the reference list '{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getConflicting <em>Conflicting</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Conflicting</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.SharedResource#getConflicting()
	 * @see #getSharedResource()
	 * @generated
	 */
	EReference getSharedResource_Conflicting();

	/**
	 * Returns the meta object for the reference list '{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getAccessedBy <em>Accessed By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Accessed By</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.SharedResource#getAccessedBy()
	 * @see #getSharedResource()
	 * @generated
	 */
	EReference getSharedResource_AccessedBy();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.resource.CPU <em>CPU</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CPU</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.CPU
	 * @generated
	 */
	EClass getCPU();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.CPU#getProcessingRate <em>Processing Rate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Processing Rate</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.CPU#getProcessingRate()
	 * @see #getCPU()
	 * @generated
	 */
	EAttribute getCPU_ProcessingRate();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.CPU#getContextSwRate <em>Context Sw Rate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Context Sw Rate</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.CPU#getContextSwRate()
	 * @see #getCPU()
	 * @generated
	 */
	EAttribute getCPU_ContextSwRate();

	/**
	 * Returns the meta object for the containment reference list '{@link com.thalesgroup.marte.rapidrma.resource.CPU#getPriorityMapping <em>Priority Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Priority Mapping</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.CPU#getPriorityMapping()
	 * @see #getCPU()
	 * @generated
	 */
	EReference getCPU_PriorityMapping();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.CPU#getMappingKind <em>Mapping Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mapping Kind</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.CPU#getMappingKind()
	 * @see #getCPU()
	 * @generated
	 */
	EAttribute getCPU_MappingKind();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.resource.Range <em>Range</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Range</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Range
	 * @generated
	 */
	EClass getRange();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.Range#getStart <em>Start</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Range#getStart()
	 * @see #getRange()
	 * @generated
	 */
	EAttribute getRange_Start();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.Range#getEnd <em>End</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Range#getEnd()
	 * @see #getRange()
	 * @generated
	 */
	EAttribute getRange_End();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.resource.Resource <em>Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Resource</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Resource
	 * @generated
	 */
	EClass getResource();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.Resource#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Resource#getName()
	 * @see #getResource()
	 * @generated
	 */
	EAttribute getResource_Name();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.resource.Resource#getComments <em>Comments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comments</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Resource#getComments()
	 * @see #getResource()
	 * @generated
	 */
	EAttribute getResource_Comments();

	/**
	 * Returns the meta object for the container reference '{@link com.thalesgroup.marte.rapidrma.resource.Resource#getNode <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Node</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.Resource#getNode()
	 * @see #getResource()
	 * @generated
	 */
	EReference getResource_Node();

	/**
	 * Returns the meta object for enum '{@link com.thalesgroup.marte.rapidrma.resource.ResourceKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Kind</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourceKind
	 * @generated
	 */
	EEnum getResourceKind();

	/**
	 * Returns the meta object for enum '{@link com.thalesgroup.marte.rapidrma.resource.PriorityMappingKind <em>Priority Mapping Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Priority Mapping Kind</em>'.
	 * @see com.thalesgroup.marte.rapidrma.resource.PriorityMappingKind
	 * @generated
	 */
	EEnum getPriorityMappingKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ResourceFactory getResourceFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals  {
		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.ResourceGraphImpl <em>Graph</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourceGraphImpl
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getResourceGraph()
		 * @generated
		 */
		EClass RESOURCE_GRAPH = eINSTANCE.getResourceGraph();

		/**
		 * The meta object literal for the '<em><b>Node</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RESOURCE_GRAPH__NODE = eINSTANCE.getResourceGraph_Node();

		/**
		 * The meta object literal for the '<em><b>Db</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RESOURCE_GRAPH__DB = eINSTANCE.getResourceGraph_Db();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.NodeImpl <em>Node</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.NodeImpl
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getNode()
		 * @generated
		 */
		EClass NODE = eINSTANCE.getNode();

		/**
		 * The meta object literal for the '<em><b>Accesses</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NODE__ACCESSES = eINSTANCE.getNode_Accesses();

		/**
		 * The meta object literal for the '<em><b>Resource</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NODE__RESOURCE = eINSTANCE.getNode_Resource();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NODE__NAME = eINSTANCE.getNode_Name();

		/**
		 * The meta object literal for the '<em><b>Comments</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NODE__COMMENTS = eINSTANCE.getNode_Comments();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.SharedResourceImpl <em>Shared Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.SharedResourceImpl
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getSharedResource()
		 * @generated
		 */
		EClass SHARED_RESOURCE = eINSTANCE.getSharedResource();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SHARED_RESOURCE__TYPE = eINSTANCE.getSharedResource_Type();

		/**
		 * The meta object literal for the '<em><b>Acq Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SHARED_RESOURCE__ACQ_TIME = eINSTANCE.getSharedResource_AcqTime();

		/**
		 * The meta object literal for the '<em><b>De Acq Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SHARED_RESOURCE__DE_ACQ_TIME = eINSTANCE.getSharedResource_DeAcqTime();

		/**
		 * The meta object literal for the '<em><b>Conflicting</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SHARED_RESOURCE__CONFLICTING = eINSTANCE.getSharedResource_Conflicting();

		/**
		 * The meta object literal for the '<em><b>Accessed By</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SHARED_RESOURCE__ACCESSED_BY = eINSTANCE.getSharedResource_AccessedBy();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.CPUImpl <em>CPU</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.CPUImpl
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getCPU()
		 * @generated
		 */
		EClass CPU = eINSTANCE.getCPU();

		/**
		 * The meta object literal for the '<em><b>Processing Rate</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CPU__PROCESSING_RATE = eINSTANCE.getCPU_ProcessingRate();

		/**
		 * The meta object literal for the '<em><b>Context Sw Rate</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CPU__CONTEXT_SW_RATE = eINSTANCE.getCPU_ContextSwRate();

		/**
		 * The meta object literal for the '<em><b>Priority Mapping</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CPU__PRIORITY_MAPPING = eINSTANCE.getCPU_PriorityMapping();

		/**
		 * The meta object literal for the '<em><b>Mapping Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CPU__MAPPING_KIND = eINSTANCE.getCPU_MappingKind();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.RangeImpl <em>Range</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.RangeImpl
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getRange()
		 * @generated
		 */
		EClass RANGE = eINSTANCE.getRange();

		/**
		 * The meta object literal for the '<em><b>Start</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RANGE__START = eINSTANCE.getRange_Start();

		/**
		 * The meta object literal for the '<em><b>End</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RANGE__END = eINSTANCE.getRange_End();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.resource.impl.ResourceImpl <em>Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourceImpl
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getResource()
		 * @generated
		 */
		EClass RESOURCE = eINSTANCE.getResource();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESOURCE__NAME = eINSTANCE.getResource_Name();

		/**
		 * The meta object literal for the '<em><b>Comments</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESOURCE__COMMENTS = eINSTANCE.getResource_Comments();

		/**
		 * The meta object literal for the '<em><b>Node</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RESOURCE__NODE = eINSTANCE.getResource_Node();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.resource.ResourceKind <em>Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.resource.ResourceKind
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getResourceKind()
		 * @generated
		 */
		EEnum RESOURCE_KIND = eINSTANCE.getResourceKind();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.resource.PriorityMappingKind <em>Priority Mapping Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.resource.PriorityMappingKind
		 * @see com.thalesgroup.marte.rapidrma.resource.impl.ResourcePackageImpl#getPriorityMappingKind()
		 * @generated
		 */
		EEnum PRIORITY_MAPPING_KIND = eINSTANCE.getPriorityMappingKind();

	}

} //ResourcePackage
