/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: SharedResource.java,v 1.2 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.resource;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Shared Resource</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getType <em>Type</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getAcqTime <em>Acq Time</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getDeAcqTime <em>De Acq Time</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getConflicting <em>Conflicting</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getAccessedBy <em>Accessed By</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getSharedResource()
 * @model
 * @generated
 */
public interface SharedResource extends Resource {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The literals are from the enumeration {@link com.thalesgroup.marte.rapidrma.resource.ResourceKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourceKind
	 * @see #setType(ResourceKind)
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getSharedResource_Type()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	ResourceKind getType();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourceKind
	 * @see #getType()
	 * @generated
	 */
	void setType(ResourceKind value);

	/**
	 * Returns the value of the '<em><b>Acq Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Acq Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Acq Time</em>' attribute.
	 * @see #setAcqTime(int)
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getSharedResource_AcqTime()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getAcqTime();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getAcqTime <em>Acq Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Acq Time</em>' attribute.
	 * @see #getAcqTime()
	 * @generated
	 */
	void setAcqTime(int value);

	/**
	 * Returns the value of the '<em><b>De Acq Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>De Acq Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>De Acq Time</em>' attribute.
	 * @see #setDeAcqTime(int)
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getSharedResource_DeAcqTime()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getDeAcqTime();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.resource.SharedResource#getDeAcqTime <em>De Acq Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>De Acq Time</em>' attribute.
	 * @see #getDeAcqTime()
	 * @generated
	 */
	void setDeAcqTime(int value);

	/**
	 * Returns the value of the '<em><b>Conflicting</b></em>' reference list.
	 * The list contents are of type {@link com.thalesgroup.marte.rapidrma.resource.SharedResource}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Conflicting</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Conflicting</em>' reference list.
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getSharedResource_Conflicting()
	 * @model type="com.thalesgroup.marte.rapidrma.resource.SharedResource" ordered="false"
	 * @generated
	 */
	EList getConflicting();

	/**
	 * Returns the value of the '<em><b>Accessed By</b></em>' reference list.
	 * The list contents are of type {@link com.thalesgroup.marte.rapidrma.resource.Node}.
	 * It is bidirectional and its opposite is '{@link com.thalesgroup.marte.rapidrma.resource.Node#getAccesses <em>Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Accessed By</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Accessed By</em>' reference list.
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourcePackage#getSharedResource_AccessedBy()
	 * @see com.thalesgroup.marte.rapidrma.resource.Node#getAccesses
	 * @model type="com.thalesgroup.marte.rapidrma.resource.Node" opposite="accesses" ordered="false"
	 * @generated
	 */
	EList getAccessedBy();

} // SharedResource