/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: CPUImpl.java,v 1.3 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.resource.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import com.thalesgroup.marte.rapidrma.resource.CPU;
import com.thalesgroup.marte.rapidrma.resource.PriorityMappingKind;
import com.thalesgroup.marte.rapidrma.resource.Range;
import com.thalesgroup.marte.rapidrma.resource.ResourcePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CPU</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.impl.CPUImpl#getProcessingRate <em>Processing Rate</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.impl.CPUImpl#getContextSwRate <em>Context Sw Rate</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.impl.CPUImpl#getPriorityMapping <em>Priority Mapping</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.impl.CPUImpl#getMappingKind <em>Mapping Kind</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CPUImpl extends ResourceImpl implements CPU {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * The default value of the '{@link #getProcessingRate() <em>Processing Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessingRate()
	 * @generated
	 * @ordered
	 */
	protected static final String PROCESSING_RATE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProcessingRate() <em>Processing Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessingRate()
	 * @generated
	 * @ordered
	 */
	protected String processingRate = PROCESSING_RATE_EDEFAULT;

	/**
	 * The default value of the '{@link #getContextSwRate() <em>Context Sw Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContextSwRate()
	 * @generated
	 * @ordered
	 */
	protected static final String CONTEXT_SW_RATE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getContextSwRate() <em>Context Sw Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContextSwRate()
	 * @generated
	 * @ordered
	 */
	protected String contextSwRate = CONTEXT_SW_RATE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPriorityMapping() <em>Priority Mapping</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPriorityMapping()
	 * @generated
	 * @ordered
	 */
	protected EList priorityMapping = null;

	/**
	 * The default value of the '{@link #getMappingKind() <em>Mapping Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMappingKind()
	 * @generated
	 * @ordered
	 */
	protected static final PriorityMappingKind MAPPING_KIND_EDEFAULT = PriorityMappingKind.LOW_NUMBER_LOW_PRIORITY_LITERAL;

	/**
	 * The cached value of the '{@link #getMappingKind() <em>Mapping Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMappingKind()
	 * @generated
	 * @ordered
	 */
	protected PriorityMappingKind mappingKind = MAPPING_KIND_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CPUImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ResourcePackage.Literals.CPU;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getProcessingRate() {
		return processingRate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcessingRate(String newProcessingRate) {
		String oldProcessingRate = processingRate;
		processingRate = newProcessingRate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResourcePackage.CPU__PROCESSING_RATE, oldProcessingRate, processingRate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getContextSwRate() {
		return contextSwRate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContextSwRate(String newContextSwRate) {
		String oldContextSwRate = contextSwRate;
		contextSwRate = newContextSwRate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResourcePackage.CPU__CONTEXT_SW_RATE, oldContextSwRate, contextSwRate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getPriorityMapping() {
		if (priorityMapping == null) {
			priorityMapping = new EObjectContainmentEList(Range.class, this, ResourcePackage.CPU__PRIORITY_MAPPING);
		}
		return priorityMapping;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PriorityMappingKind getMappingKind() {
		return mappingKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMappingKind(PriorityMappingKind newMappingKind) {
		PriorityMappingKind oldMappingKind = mappingKind;
		mappingKind = newMappingKind == null ? MAPPING_KIND_EDEFAULT : newMappingKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResourcePackage.CPU__MAPPING_KIND, oldMappingKind, mappingKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ResourcePackage.CPU__PRIORITY_MAPPING:
				return ((InternalEList)getPriorityMapping()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ResourcePackage.CPU__PROCESSING_RATE:
				return getProcessingRate();
			case ResourcePackage.CPU__CONTEXT_SW_RATE:
				return getContextSwRate();
			case ResourcePackage.CPU__PRIORITY_MAPPING:
				return getPriorityMapping();
			case ResourcePackage.CPU__MAPPING_KIND:
				return getMappingKind();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ResourcePackage.CPU__PROCESSING_RATE:
				setProcessingRate((String)newValue);
				return;
			case ResourcePackage.CPU__CONTEXT_SW_RATE:
				setContextSwRate((String)newValue);
				return;
			case ResourcePackage.CPU__PRIORITY_MAPPING:
				getPriorityMapping().clear();
				getPriorityMapping().addAll((Collection)newValue);
				return;
			case ResourcePackage.CPU__MAPPING_KIND:
				setMappingKind((PriorityMappingKind)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case ResourcePackage.CPU__PROCESSING_RATE:
				setProcessingRate(PROCESSING_RATE_EDEFAULT);
				return;
			case ResourcePackage.CPU__CONTEXT_SW_RATE:
				setContextSwRate(CONTEXT_SW_RATE_EDEFAULT);
				return;
			case ResourcePackage.CPU__PRIORITY_MAPPING:
				getPriorityMapping().clear();
				return;
			case ResourcePackage.CPU__MAPPING_KIND:
				setMappingKind(MAPPING_KIND_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ResourcePackage.CPU__PROCESSING_RATE:
				return PROCESSING_RATE_EDEFAULT == null ? processingRate != null : !PROCESSING_RATE_EDEFAULT.equals(processingRate);
			case ResourcePackage.CPU__CONTEXT_SW_RATE:
				return CONTEXT_SW_RATE_EDEFAULT == null ? contextSwRate != null : !CONTEXT_SW_RATE_EDEFAULT.equals(contextSwRate);
			case ResourcePackage.CPU__PRIORITY_MAPPING:
				return priorityMapping != null && !priorityMapping.isEmpty();
			case ResourcePackage.CPU__MAPPING_KIND:
				return mappingKind != MAPPING_KIND_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (processingRate: ");
		result.append(processingRate);
		result.append(", contextSwRate: ");
		result.append(contextSwRate);
		result.append(", mappingKind: ");
		result.append(mappingKind);
		result.append(')');
		return result.toString();
	}

} //CPUImpl