/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: SharedResourceImpl.java,v 1.2 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.resource.impl;

import com.thalesgroup.marte.rapidrma.resource.Node;
import com.thalesgroup.marte.rapidrma.resource.ResourceKind;
import com.thalesgroup.marte.rapidrma.resource.ResourcePackage;
import com.thalesgroup.marte.rapidrma.resource.SharedResource;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Shared Resource</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.impl.SharedResourceImpl#getType <em>Type</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.impl.SharedResourceImpl#getAcqTime <em>Acq Time</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.impl.SharedResourceImpl#getDeAcqTime <em>De Acq Time</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.impl.SharedResourceImpl#getConflicting <em>Conflicting</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.resource.impl.SharedResourceImpl#getAccessedBy <em>Accessed By</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SharedResourceImpl extends ResourceImpl implements SharedResource {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final ResourceKind TYPE_EDEFAULT = ResourceKind.METHOD_LITERAL;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected ResourceKind type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getAcqTime() <em>Acq Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAcqTime()
	 * @generated
	 * @ordered
	 */
	protected static final int ACQ_TIME_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getAcqTime() <em>Acq Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAcqTime()
	 * @generated
	 * @ordered
	 */
	protected int acqTime = ACQ_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDeAcqTime() <em>De Acq Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeAcqTime()
	 * @generated
	 * @ordered
	 */
	protected static final int DE_ACQ_TIME_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getDeAcqTime() <em>De Acq Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeAcqTime()
	 * @generated
	 * @ordered
	 */
	protected int deAcqTime = DE_ACQ_TIME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getConflicting() <em>Conflicting</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConflicting()
	 * @generated
	 * @ordered
	 */
	protected EList conflicting = null;

	/**
	 * The cached value of the '{@link #getAccessedBy() <em>Accessed By</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessedBy()
	 * @generated
	 * @ordered
	 */
	protected EList accessedBy = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SharedResourceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ResourcePackage.Literals.SHARED_RESOURCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceKind getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(ResourceKind newType) {
		ResourceKind oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResourcePackage.SHARED_RESOURCE__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getAcqTime() {
		return acqTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAcqTime(int newAcqTime) {
		int oldAcqTime = acqTime;
		acqTime = newAcqTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResourcePackage.SHARED_RESOURCE__ACQ_TIME, oldAcqTime, acqTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getDeAcqTime() {
		return deAcqTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeAcqTime(int newDeAcqTime) {
		int oldDeAcqTime = deAcqTime;
		deAcqTime = newDeAcqTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResourcePackage.SHARED_RESOURCE__DE_ACQ_TIME, oldDeAcqTime, deAcqTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getConflicting() {
		if (conflicting == null) {
			conflicting = new EObjectResolvingEList(SharedResource.class, this, ResourcePackage.SHARED_RESOURCE__CONFLICTING);
		}
		return conflicting;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getAccessedBy() {
		if (accessedBy == null) {
			accessedBy = new EObjectWithInverseResolvingEList.ManyInverse(Node.class, this, ResourcePackage.SHARED_RESOURCE__ACCESSED_BY, ResourcePackage.NODE__ACCESSES);
		}
		return accessedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ResourcePackage.SHARED_RESOURCE__ACCESSED_BY:
				return ((InternalEList)getAccessedBy()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ResourcePackage.SHARED_RESOURCE__ACCESSED_BY:
				return ((InternalEList)getAccessedBy()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ResourcePackage.SHARED_RESOURCE__TYPE:
				return getType();
			case ResourcePackage.SHARED_RESOURCE__ACQ_TIME:
				return new Integer(getAcqTime());
			case ResourcePackage.SHARED_RESOURCE__DE_ACQ_TIME:
				return new Integer(getDeAcqTime());
			case ResourcePackage.SHARED_RESOURCE__CONFLICTING:
				return getConflicting();
			case ResourcePackage.SHARED_RESOURCE__ACCESSED_BY:
				return getAccessedBy();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ResourcePackage.SHARED_RESOURCE__TYPE:
				setType((ResourceKind)newValue);
				return;
			case ResourcePackage.SHARED_RESOURCE__ACQ_TIME:
				setAcqTime(((Integer)newValue).intValue());
				return;
			case ResourcePackage.SHARED_RESOURCE__DE_ACQ_TIME:
				setDeAcqTime(((Integer)newValue).intValue());
				return;
			case ResourcePackage.SHARED_RESOURCE__CONFLICTING:
				getConflicting().clear();
				getConflicting().addAll((Collection)newValue);
				return;
			case ResourcePackage.SHARED_RESOURCE__ACCESSED_BY:
				getAccessedBy().clear();
				getAccessedBy().addAll((Collection)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case ResourcePackage.SHARED_RESOURCE__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case ResourcePackage.SHARED_RESOURCE__ACQ_TIME:
				setAcqTime(ACQ_TIME_EDEFAULT);
				return;
			case ResourcePackage.SHARED_RESOURCE__DE_ACQ_TIME:
				setDeAcqTime(DE_ACQ_TIME_EDEFAULT);
				return;
			case ResourcePackage.SHARED_RESOURCE__CONFLICTING:
				getConflicting().clear();
				return;
			case ResourcePackage.SHARED_RESOURCE__ACCESSED_BY:
				getAccessedBy().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ResourcePackage.SHARED_RESOURCE__TYPE:
				return type != TYPE_EDEFAULT;
			case ResourcePackage.SHARED_RESOURCE__ACQ_TIME:
				return acqTime != ACQ_TIME_EDEFAULT;
			case ResourcePackage.SHARED_RESOURCE__DE_ACQ_TIME:
				return deAcqTime != DE_ACQ_TIME_EDEFAULT;
			case ResourcePackage.SHARED_RESOURCE__CONFLICTING:
				return conflicting != null && !conflicting.isEmpty();
			case ResourcePackage.SHARED_RESOURCE__ACCESSED_BY:
				return accessedBy != null && !accessedBy.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(", acqTime: ");
		result.append(acqTime);
		result.append(", deAcqTime: ");
		result.append(deAcqTime);
		result.append(')');
		return result.toString();
	}

} //SharedResourceImpl