/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: Task.java,v 1.2 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.task;

import com.thalesgroup.marte.rapidrma.resource.Resource;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Task</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getName <em>Name</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getReadyTime <em>Ready Time</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getRelDeadline <em>Rel Deadline</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getDropDeadline <em>Drop Deadline</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getPhase <em>Phase</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getPriority <em>Priority</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getNetworkQoS <em>Network Qo S</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getActiveResource <em>Active Resource</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getDeadline <em>Deadline</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getInstances <em>Instances</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getComments <em>Comments</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getXCoord <em>XCoord</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getYCoord <em>YCoord</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getPeriod <em>Period</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getAmountOfWork <em>Amount Of Work</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getIntermediate <em>Intermediate</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getDependency <em>Dependency</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getNonPremptible <em>Non Premptible</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getResourceusage <em>Resourceusage</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.Task#getServer <em>Server</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask()
 * @model
 * @generated
 */
public interface Task extends EObject {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_Name()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Ready Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ready Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ready Time</em>' attribute.
	 * @see #setReadyTime(int)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_ReadyTime()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getReadyTime();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getReadyTime <em>Ready Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ready Time</em>' attribute.
	 * @see #getReadyTime()
	 * @generated
	 */
	void setReadyTime(int value);

	/**
	 * Returns the value of the '<em><b>Rel Deadline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Rel Deadline</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Rel Deadline</em>' attribute.
	 * @see #setRelDeadline(int)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_RelDeadline()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getRelDeadline();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getRelDeadline <em>Rel Deadline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Rel Deadline</em>' attribute.
	 * @see #getRelDeadline()
	 * @generated
	 */
	void setRelDeadline(int value);

	/**
	 * Returns the value of the '<em><b>Drop Deadline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Drop Deadline</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Drop Deadline</em>' attribute.
	 * @see #setDropDeadline(int)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_DropDeadline()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getDropDeadline();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getDropDeadline <em>Drop Deadline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Drop Deadline</em>' attribute.
	 * @see #getDropDeadline()
	 * @generated
	 */
	void setDropDeadline(int value);

	/**
	 * Returns the value of the '<em><b>Phase</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Phase</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Phase</em>' attribute.
	 * @see #setPhase(int)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_Phase()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getPhase();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getPhase <em>Phase</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Phase</em>' attribute.
	 * @see #getPhase()
	 * @generated
	 */
	void setPhase(int value);

	/**
	 * Returns the value of the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Priority</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Priority</em>' attribute.
	 * @see #setPriority(int)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_Priority()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getPriority();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getPriority <em>Priority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Priority</em>' attribute.
	 * @see #getPriority()
	 * @generated
	 */
	void setPriority(int value);

	/**
	 * Returns the value of the '<em><b>Network Qo S</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Network Qo S</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Network Qo S</em>' attribute.
	 * @see #setNetworkQoS(int)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_NetworkQoS()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getNetworkQoS();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getNetworkQoS <em>Network Qo S</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Network Qo S</em>' attribute.
	 * @see #getNetworkQoS()
	 * @generated
	 */
	void setNetworkQoS(int value);

	/**
	 * Returns the value of the '<em><b>Active Resource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Active Resource</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Active Resource</em>' reference.
	 * @see #setActiveResource(Resource)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_ActiveResource()
	 * @model ordered="false"
	 * @generated
	 */
	Resource getActiveResource();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getActiveResource <em>Active Resource</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Active Resource</em>' reference.
	 * @see #getActiveResource()
	 * @generated
	 */
	void setActiveResource(Resource value);

	/**
	 * Returns the value of the '<em><b>Deadline</b></em>' attribute.
	 * The literals are from the enumeration {@link com.thalesgroup.marte.rapidrma.task.DeadlineKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Deadline</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Deadline</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.task.DeadlineKind
	 * @see #setDeadline(DeadlineKind)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_Deadline()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	DeadlineKind getDeadline();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getDeadline <em>Deadline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Deadline</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.task.DeadlineKind
	 * @see #getDeadline()
	 * @generated
	 */
	void setDeadline(DeadlineKind value);

	/**
	 * Returns the value of the '<em><b>Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Instances</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Instances</em>' attribute.
	 * @see #setInstances(int)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_Instances()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getInstances();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getInstances <em>Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Instances</em>' attribute.
	 * @see #getInstances()
	 * @generated
	 */
	void setInstances(int value);

	/**
	 * Returns the value of the '<em><b>Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Comments</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Comments</em>' attribute.
	 * @see #setComments(String)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_Comments()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	String getComments();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getComments <em>Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Comments</em>' attribute.
	 * @see #getComments()
	 * @generated
	 */
	void setComments(String value);

	/**
	 * Returns the value of the '<em><b>XCoord</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>XCoord</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>XCoord</em>' attribute.
	 * @see #setXCoord(int)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_XCoord()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getXCoord();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getXCoord <em>XCoord</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>XCoord</em>' attribute.
	 * @see #getXCoord()
	 * @generated
	 */
	void setXCoord(int value);

	/**
	 * Returns the value of the '<em><b>YCoord</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>YCoord</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>YCoord</em>' attribute.
	 * @see #setYCoord(int)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_YCoord()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getYCoord();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getYCoord <em>YCoord</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>YCoord</em>' attribute.
	 * @see #getYCoord()
	 * @generated
	 */
	void setYCoord(int value);

	/**
	 * Returns the value of the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Period</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Period</em>' containment reference.
	 * @see #setPeriod(Distribution)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_Period()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	Distribution getPeriod();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getPeriod <em>Period</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Period</em>' containment reference.
	 * @see #getPeriod()
	 * @generated
	 */
	void setPeriod(Distribution value);

	/**
	 * Returns the value of the '<em><b>Amount Of Work</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Amount Of Work</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Amount Of Work</em>' containment reference.
	 * @see #setAmountOfWork(Distribution)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_AmountOfWork()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	Distribution getAmountOfWork();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getAmountOfWork <em>Amount Of Work</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Amount Of Work</em>' containment reference.
	 * @see #getAmountOfWork()
	 * @generated
	 */
	void setAmountOfWork(Distribution value);

	/**
	 * Returns the value of the '<em><b>Intermediate</b></em>' containment reference list.
	 * The list contents are of type {@link com.thalesgroup.marte.rapidrma.task.IntermediateDeadline}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Intermediate</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Intermediate</em>' containment reference list.
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_Intermediate()
	 * @model type="com.thalesgroup.marte.rapidrma.task.IntermediateDeadline" containment="true" ordered="false"
	 * @generated
	 */
	EList getIntermediate();

	/**
	 * Returns the value of the '<em><b>Dependency</b></em>' reference list.
	 * The list contents are of type {@link com.thalesgroup.marte.rapidrma.task.Task}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Dependency</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Dependency</em>' reference list.
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_Dependency()
	 * @model type="com.thalesgroup.marte.rapidrma.task.Task" ordered="false"
	 * @generated
	 */
	EList getDependency();

	/**
	 * Returns the value of the '<em><b>Non Premptible</b></em>' containment reference list.
	 * The list contents are of type {@link com.thalesgroup.marte.rapidrma.task.NonPremptibleSection}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Non Premptible</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Non Premptible</em>' containment reference list.
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_NonPremptible()
	 * @model type="com.thalesgroup.marte.rapidrma.task.NonPremptibleSection" containment="true" ordered="false"
	 * @generated
	 */
	EList getNonPremptible();

	/**
	 * Returns the value of the '<em><b>Resourceusage</b></em>' containment reference list.
	 * The list contents are of type {@link com.thalesgroup.marte.rapidrma.task.ResourceUsage}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Resourceusage</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Resourceusage</em>' containment reference list.
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_Resourceusage()
	 * @model type="com.thalesgroup.marte.rapidrma.task.ResourceUsage" containment="true" ordered="false"
	 * @generated
	 */
	EList getResourceusage();

	/**
	 * Returns the value of the '<em><b>Server</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Server</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Server</em>' reference.
	 * @see #setServer(PeriodicServer)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTask_Server()
	 * @model ordered="false"
	 * @generated
	 */
	PeriodicServer getServer();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.Task#getServer <em>Server</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Server</em>' reference.
	 * @see #getServer()
	 * @generated
	 */
	void setServer(PeriodicServer value);

} // Task