/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: TaskGraph.java,v 1.2 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.task;

import com.thalesgroup.marte.rapidrma.database.Database;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Graph</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.TaskGraph#getTask <em>Task</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.TaskGraph#getServer <em>Server</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.TaskGraph#getDb <em>Db</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTaskGraph()
 * @model
 * @generated
 */
public interface TaskGraph extends EObject {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Task</b></em>' containment reference list.
	 * The list contents are of type {@link com.thalesgroup.marte.rapidrma.task.Task}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Task</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Task</em>' containment reference list.
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTaskGraph_Task()
	 * @model type="com.thalesgroup.marte.rapidrma.task.Task" containment="true" ordered="false"
	 * @generated
	 */
	EList getTask();

	/**
	 * Returns the value of the '<em><b>Server</b></em>' containment reference list.
	 * The list contents are of type {@link com.thalesgroup.marte.rapidrma.task.PeriodicServer}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Server</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Server</em>' containment reference list.
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTaskGraph_Server()
	 * @model type="com.thalesgroup.marte.rapidrma.task.PeriodicServer" containment="true" ordered="false"
	 * @generated
	 */
	EList getServer();

	/**
	 * Returns the value of the '<em><b>Db</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link com.thalesgroup.marte.rapidrma.database.Database#getTask <em>Task</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Db</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Db</em>' reference.
	 * @see #setDb(Database)
	 * @see com.thalesgroup.marte.rapidrma.task.TaskPackage#getTaskGraph_Db()
	 * @see com.thalesgroup.marte.rapidrma.database.Database#getTask
	 * @model opposite="task" required="true" ordered="false"
	 * @generated
	 */
	Database getDb();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.task.TaskGraph#getDb <em>Db</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Db</em>' reference.
	 * @see #getDb()
	 * @generated
	 */
	void setDb(Database value);

} // TaskGraph