/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: TaskPackage.java,v 1.2 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.task;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.thalesgroup.marte.rapidrma.task.TaskFactory
 * @model kind="package"
 * @generated
 */
public interface TaskPackage extends EPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "task";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.thalesgroup.com/marte/rapidrma/task.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "com.thalesgroup.marte.rapidrma.task";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	TaskPackage eINSTANCE = com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl.init();

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl <em>Task</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskImpl
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getTask()
	 * @generated
	 */
	int TASK = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__NAME = 0;

	/**
	 * The feature id for the '<em><b>Ready Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__READY_TIME = 1;

	/**
	 * The feature id for the '<em><b>Rel Deadline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__REL_DEADLINE = 2;

	/**
	 * The feature id for the '<em><b>Drop Deadline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__DROP_DEADLINE = 3;

	/**
	 * The feature id for the '<em><b>Phase</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__PHASE = 4;

	/**
	 * The feature id for the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__PRIORITY = 5;

	/**
	 * The feature id for the '<em><b>Network Qo S</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__NETWORK_QO_S = 6;

	/**
	 * The feature id for the '<em><b>Active Resource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__ACTIVE_RESOURCE = 7;

	/**
	 * The feature id for the '<em><b>Deadline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__DEADLINE = 8;

	/**
	 * The feature id for the '<em><b>Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__INSTANCES = 9;

	/**
	 * The feature id for the '<em><b>Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__COMMENTS = 10;

	/**
	 * The feature id for the '<em><b>XCoord</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__XCOORD = 11;

	/**
	 * The feature id for the '<em><b>YCoord</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__YCOORD = 12;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__PERIOD = 13;

	/**
	 * The feature id for the '<em><b>Amount Of Work</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__AMOUNT_OF_WORK = 14;

	/**
	 * The feature id for the '<em><b>Intermediate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__INTERMEDIATE = 15;

	/**
	 * The feature id for the '<em><b>Dependency</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__DEPENDENCY = 16;

	/**
	 * The feature id for the '<em><b>Non Premptible</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__NON_PREMPTIBLE = 17;

	/**
	 * The feature id for the '<em><b>Resourceusage</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__RESOURCEUSAGE = 18;

	/**
	 * The feature id for the '<em><b>Server</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__SERVER = 19;

	/**
	 * The number of structural features of the '<em>Task</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_FEATURE_COUNT = 20;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.impl.DistributionImpl <em>Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.impl.DistributionImpl
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getDistribution()
	 * @generated
	 */
	int DISTRIBUTION = 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISTRIBUTION__VALUE = 0;

	/**
	 * The number of structural features of the '<em>Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISTRIBUTION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.impl.IntermediateDeadlineImpl <em>Intermediate Deadline</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.impl.IntermediateDeadlineImpl
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getIntermediateDeadline()
	 * @generated
	 */
	int INTERMEDIATE_DEADLINE = 2;

	/**
	 * The feature id for the '<em><b>Work Remaining</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERMEDIATE_DEADLINE__WORK_REMAINING = 0;

	/**
	 * The feature id for the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERMEDIATE_DEADLINE__START_TIME = 1;

	/**
	 * The feature id for the '<em><b>End Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERMEDIATE_DEADLINE__END_TIME = 2;

	/**
	 * The feature id for the '<em><b>Int Deadline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERMEDIATE_DEADLINE__INT_DEADLINE = 3;

	/**
	 * The number of structural features of the '<em>Intermediate Deadline</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERMEDIATE_DEADLINE_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.impl.NonPremptibleSectionImpl <em>Non Premptible Section</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.impl.NonPremptibleSectionImpl
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getNonPremptibleSection()
	 * @generated
	 */
	int NON_PREMPTIBLE_SECTION = 3;

	/**
	 * The feature id for the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_PREMPTIBLE_SECTION__START_TIME = 0;

	/**
	 * The feature id for the '<em><b>End Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_PREMPTIBLE_SECTION__END_TIME = 1;

	/**
	 * The number of structural features of the '<em>Non Premptible Section</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_PREMPTIBLE_SECTION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.impl.ResourceUsageImpl <em>Resource Usage</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.impl.ResourceUsageImpl
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getResourceUsage()
	 * @generated
	 */
	int RESOURCE_USAGE = 4;

	/**
	 * The feature id for the '<em><b>Resource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE_USAGE__RESOURCE = 0;

	/**
	 * The feature id for the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE_USAGE__START_TIME = 1;

	/**
	 * The feature id for the '<em><b>End Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE_USAGE__END_TIME = 2;

	/**
	 * The feature id for the '<em><b>Acquisition Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE_USAGE__ACQUISITION_TIME = 3;

	/**
	 * The feature id for the '<em><b>Deacquisition Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE_USAGE__DEACQUISITION_TIME = 4;

	/**
	 * The number of structural features of the '<em>Resource Usage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESOURCE_USAGE_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl <em>Periodic Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getPeriodicServer()
	 * @generated
	 */
	int PERIODIC_SERVER = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SERVER__NAME = 0;

	/**
	 * The feature id for the '<em><b>Period</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SERVER__PERIOD = 1;

	/**
	 * The feature id for the '<em><b>Budget</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SERVER__BUDGET = 2;

	/**
	 * The feature id for the '<em><b>Rel Deadline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SERVER__REL_DEADLINE = 3;

	/**
	 * The feature id for the '<em><b>Phase</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SERVER__PHASE = 4;

	/**
	 * The feature id for the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SERVER__PRIORITY = 5;

	/**
	 * The feature id for the '<em><b>Active Resource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SERVER__ACTIVE_RESOURCE = 6;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SERVER__TYPE = 7;

	/**
	 * The feature id for the '<em><b>Queueing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SERVER__QUEUEING = 8;

	/**
	 * The number of structural features of the '<em>Periodic Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SERVER_FEATURE_COUNT = 9;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.impl.DeterministicImpl <em>Deterministic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.impl.DeterministicImpl
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getDeterministic()
	 * @generated
	 */
	int DETERMINISTIC = 6;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DETERMINISTIC__VALUE = DISTRIBUTION__VALUE;

	/**
	 * The number of structural features of the '<em>Deterministic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DETERMINISTIC_FEATURE_COUNT = DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.impl.UniformImpl <em>Uniform</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.impl.UniformImpl
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getUniform()
	 * @generated
	 */
	int UNIFORM = 7;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIFORM__VALUE = DISTRIBUTION__VALUE;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIFORM__MIN = DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIFORM__MAX = DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Uniform</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIFORM_FEATURE_COUNT = DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.impl.ExponentialImpl <em>Exponential</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.impl.ExponentialImpl
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getExponential()
	 * @generated
	 */
	int EXPONENTIAL = 8;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPONENTIAL__VALUE = DISTRIBUTION__VALUE;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPONENTIAL__MIN = DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Avg</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPONENTIAL__AVG = DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Exponential</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPONENTIAL_FEATURE_COUNT = DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.impl.TaskGraphImpl <em>Graph</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskGraphImpl
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getTaskGraph()
	 * @generated
	 */
	int TASK_GRAPH = 9;

	/**
	 * The feature id for the '<em><b>Task</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_GRAPH__TASK = 0;

	/**
	 * The feature id for the '<em><b>Server</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_GRAPH__SERVER = 1;

	/**
	 * The feature id for the '<em><b>Db</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_GRAPH__DB = 2;

	/**
	 * The number of structural features of the '<em>Graph</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_GRAPH_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.DeadlineKind <em>Deadline Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.DeadlineKind
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getDeadlineKind()
	 * @generated
	 */
	int DEADLINE_KIND = 10;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.ServerKind <em>Server Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.ServerKind
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getServerKind()
	 * @generated
	 */
	int SERVER_KIND = 11;

	/**
	 * The meta object id for the '{@link com.thalesgroup.marte.rapidrma.task.QueueingKind <em>Queueing Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.thalesgroup.marte.rapidrma.task.QueueingKind
	 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getQueueingKind()
	 * @generated
	 */
	int QUEUEING_KIND = 12;


	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.task.Task <em>Task</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Task</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task
	 * @generated
	 */
	EClass getTask();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getName()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_Name();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getReadyTime <em>Ready Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ready Time</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getReadyTime()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_ReadyTime();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getRelDeadline <em>Rel Deadline</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rel Deadline</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getRelDeadline()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_RelDeadline();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getDropDeadline <em>Drop Deadline</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Drop Deadline</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getDropDeadline()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_DropDeadline();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getPhase <em>Phase</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Phase</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getPhase()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_Phase();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getPriority <em>Priority</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Priority</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getPriority()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_Priority();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getNetworkQoS <em>Network Qo S</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Network Qo S</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getNetworkQoS()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_NetworkQoS();

	/**
	 * Returns the meta object for the reference '{@link com.thalesgroup.marte.rapidrma.task.Task#getActiveResource <em>Active Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Active Resource</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getActiveResource()
	 * @see #getTask()
	 * @generated
	 */
	EReference getTask_ActiveResource();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getDeadline <em>Deadline</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Deadline</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getDeadline()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_Deadline();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getInstances <em>Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Instances</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getInstances()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_Instances();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getComments <em>Comments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comments</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getComments()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_Comments();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getXCoord <em>XCoord</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>XCoord</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getXCoord()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_XCoord();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Task#getYCoord <em>YCoord</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>YCoord</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getYCoord()
	 * @see #getTask()
	 * @generated
	 */
	EAttribute getTask_YCoord();

	/**
	 * Returns the meta object for the containment reference '{@link com.thalesgroup.marte.rapidrma.task.Task#getPeriod <em>Period</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Period</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getPeriod()
	 * @see #getTask()
	 * @generated
	 */
	EReference getTask_Period();

	/**
	 * Returns the meta object for the containment reference '{@link com.thalesgroup.marte.rapidrma.task.Task#getAmountOfWork <em>Amount Of Work</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Amount Of Work</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getAmountOfWork()
	 * @see #getTask()
	 * @generated
	 */
	EReference getTask_AmountOfWork();

	/**
	 * Returns the meta object for the containment reference list '{@link com.thalesgroup.marte.rapidrma.task.Task#getIntermediate <em>Intermediate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Intermediate</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getIntermediate()
	 * @see #getTask()
	 * @generated
	 */
	EReference getTask_Intermediate();

	/**
	 * Returns the meta object for the reference list '{@link com.thalesgroup.marte.rapidrma.task.Task#getDependency <em>Dependency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Dependency</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getDependency()
	 * @see #getTask()
	 * @generated
	 */
	EReference getTask_Dependency();

	/**
	 * Returns the meta object for the containment reference list '{@link com.thalesgroup.marte.rapidrma.task.Task#getNonPremptible <em>Non Premptible</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Non Premptible</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getNonPremptible()
	 * @see #getTask()
	 * @generated
	 */
	EReference getTask_NonPremptible();

	/**
	 * Returns the meta object for the containment reference list '{@link com.thalesgroup.marte.rapidrma.task.Task#getResourceusage <em>Resourceusage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Resourceusage</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getResourceusage()
	 * @see #getTask()
	 * @generated
	 */
	EReference getTask_Resourceusage();

	/**
	 * Returns the meta object for the reference '{@link com.thalesgroup.marte.rapidrma.task.Task#getServer <em>Server</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Server</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Task#getServer()
	 * @see #getTask()
	 * @generated
	 */
	EReference getTask_Server();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.task.Distribution <em>Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Distribution</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Distribution
	 * @generated
	 */
	EClass getDistribution();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Distribution#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Distribution#getValue()
	 * @see #getDistribution()
	 * @generated
	 */
	EAttribute getDistribution_Value();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.task.IntermediateDeadline <em>Intermediate Deadline</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Intermediate Deadline</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.IntermediateDeadline
	 * @generated
	 */
	EClass getIntermediateDeadline();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.IntermediateDeadline#getWorkRemaining <em>Work Remaining</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Work Remaining</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.IntermediateDeadline#getWorkRemaining()
	 * @see #getIntermediateDeadline()
	 * @generated
	 */
	EAttribute getIntermediateDeadline_WorkRemaining();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.IntermediateDeadline#getStartTime <em>Start Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Time</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.IntermediateDeadline#getStartTime()
	 * @see #getIntermediateDeadline()
	 * @generated
	 */
	EAttribute getIntermediateDeadline_StartTime();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.IntermediateDeadline#getEndTime <em>End Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End Time</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.IntermediateDeadline#getEndTime()
	 * @see #getIntermediateDeadline()
	 * @generated
	 */
	EAttribute getIntermediateDeadline_EndTime();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.IntermediateDeadline#getIntDeadline <em>Int Deadline</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Int Deadline</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.IntermediateDeadline#getIntDeadline()
	 * @see #getIntermediateDeadline()
	 * @generated
	 */
	EAttribute getIntermediateDeadline_IntDeadline();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.task.NonPremptibleSection <em>Non Premptible Section</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Non Premptible Section</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.NonPremptibleSection
	 * @generated
	 */
	EClass getNonPremptibleSection();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.NonPremptibleSection#getStartTime <em>Start Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Time</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.NonPremptibleSection#getStartTime()
	 * @see #getNonPremptibleSection()
	 * @generated
	 */
	EAttribute getNonPremptibleSection_StartTime();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.NonPremptibleSection#getEndTime <em>End Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End Time</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.NonPremptibleSection#getEndTime()
	 * @see #getNonPremptibleSection()
	 * @generated
	 */
	EAttribute getNonPremptibleSection_EndTime();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.task.ResourceUsage <em>Resource Usage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Resource Usage</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.ResourceUsage
	 * @generated
	 */
	EClass getResourceUsage();

	/**
	 * Returns the meta object for the reference '{@link com.thalesgroup.marte.rapidrma.task.ResourceUsage#getResource <em>Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Resource</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.ResourceUsage#getResource()
	 * @see #getResourceUsage()
	 * @generated
	 */
	EReference getResourceUsage_Resource();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.ResourceUsage#getStartTime <em>Start Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Time</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.ResourceUsage#getStartTime()
	 * @see #getResourceUsage()
	 * @generated
	 */
	EAttribute getResourceUsage_StartTime();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.ResourceUsage#getEndTime <em>End Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End Time</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.ResourceUsage#getEndTime()
	 * @see #getResourceUsage()
	 * @generated
	 */
	EAttribute getResourceUsage_EndTime();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.ResourceUsage#getAcquisitionTime <em>Acquisition Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Acquisition Time</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.ResourceUsage#getAcquisitionTime()
	 * @see #getResourceUsage()
	 * @generated
	 */
	EAttribute getResourceUsage_AcquisitionTime();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.ResourceUsage#getDeacquisitionTime <em>Deacquisition Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Deacquisition Time</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.ResourceUsage#getDeacquisitionTime()
	 * @see #getResourceUsage()
	 * @generated
	 */
	EAttribute getResourceUsage_DeacquisitionTime();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.task.PeriodicServer <em>Periodic Server</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Periodic Server</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.PeriodicServer
	 * @generated
	 */
	EClass getPeriodicServer();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.PeriodicServer#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.PeriodicServer#getName()
	 * @see #getPeriodicServer()
	 * @generated
	 */
	EAttribute getPeriodicServer_Name();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.PeriodicServer#getPeriod <em>Period</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Period</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.PeriodicServer#getPeriod()
	 * @see #getPeriodicServer()
	 * @generated
	 */
	EAttribute getPeriodicServer_Period();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.PeriodicServer#getBudget <em>Budget</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Budget</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.PeriodicServer#getBudget()
	 * @see #getPeriodicServer()
	 * @generated
	 */
	EAttribute getPeriodicServer_Budget();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.PeriodicServer#getRelDeadline <em>Rel Deadline</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rel Deadline</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.PeriodicServer#getRelDeadline()
	 * @see #getPeriodicServer()
	 * @generated
	 */
	EAttribute getPeriodicServer_RelDeadline();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.PeriodicServer#getPhase <em>Phase</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Phase</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.PeriodicServer#getPhase()
	 * @see #getPeriodicServer()
	 * @generated
	 */
	EAttribute getPeriodicServer_Phase();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.PeriodicServer#getPriority <em>Priority</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Priority</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.PeriodicServer#getPriority()
	 * @see #getPeriodicServer()
	 * @generated
	 */
	EAttribute getPeriodicServer_Priority();

	/**
	 * Returns the meta object for the reference '{@link com.thalesgroup.marte.rapidrma.task.PeriodicServer#getActiveResource <em>Active Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Active Resource</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.PeriodicServer#getActiveResource()
	 * @see #getPeriodicServer()
	 * @generated
	 */
	EReference getPeriodicServer_ActiveResource();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.PeriodicServer#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.PeriodicServer#getType()
	 * @see #getPeriodicServer()
	 * @generated
	 */
	EAttribute getPeriodicServer_Type();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.PeriodicServer#getQueueing <em>Queueing</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Queueing</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.PeriodicServer#getQueueing()
	 * @see #getPeriodicServer()
	 * @generated
	 */
	EAttribute getPeriodicServer_Queueing();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.task.Deterministic <em>Deterministic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Deterministic</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Deterministic
	 * @generated
	 */
	EClass getDeterministic();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.task.Uniform <em>Uniform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Uniform</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Uniform
	 * @generated
	 */
	EClass getUniform();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Uniform#getMin <em>Min</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Min</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Uniform#getMin()
	 * @see #getUniform()
	 * @generated
	 */
	EAttribute getUniform_Min();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Uniform#getMax <em>Max</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Uniform#getMax()
	 * @see #getUniform()
	 * @generated
	 */
	EAttribute getUniform_Max();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.task.Exponential <em>Exponential</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Exponential</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Exponential
	 * @generated
	 */
	EClass getExponential();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Exponential#getMin <em>Min</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Min</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Exponential#getMin()
	 * @see #getExponential()
	 * @generated
	 */
	EAttribute getExponential_Min();

	/**
	 * Returns the meta object for the attribute '{@link com.thalesgroup.marte.rapidrma.task.Exponential#getAvg <em>Avg</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Avg</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.Exponential#getAvg()
	 * @see #getExponential()
	 * @generated
	 */
	EAttribute getExponential_Avg();

	/**
	 * Returns the meta object for class '{@link com.thalesgroup.marte.rapidrma.task.TaskGraph <em>Graph</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Graph</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.TaskGraph
	 * @generated
	 */
	EClass getTaskGraph();

	/**
	 * Returns the meta object for the containment reference list '{@link com.thalesgroup.marte.rapidrma.task.TaskGraph#getTask <em>Task</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Task</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.TaskGraph#getTask()
	 * @see #getTaskGraph()
	 * @generated
	 */
	EReference getTaskGraph_Task();

	/**
	 * Returns the meta object for the containment reference list '{@link com.thalesgroup.marte.rapidrma.task.TaskGraph#getServer <em>Server</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Server</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.TaskGraph#getServer()
	 * @see #getTaskGraph()
	 * @generated
	 */
	EReference getTaskGraph_Server();

	/**
	 * Returns the meta object for the reference '{@link com.thalesgroup.marte.rapidrma.task.TaskGraph#getDb <em>Db</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Db</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.TaskGraph#getDb()
	 * @see #getTaskGraph()
	 * @generated
	 */
	EReference getTaskGraph_Db();

	/**
	 * Returns the meta object for enum '{@link com.thalesgroup.marte.rapidrma.task.DeadlineKind <em>Deadline Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Deadline Kind</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.DeadlineKind
	 * @generated
	 */
	EEnum getDeadlineKind();

	/**
	 * Returns the meta object for enum '{@link com.thalesgroup.marte.rapidrma.task.ServerKind <em>Server Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Server Kind</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.ServerKind
	 * @generated
	 */
	EEnum getServerKind();

	/**
	 * Returns the meta object for enum '{@link com.thalesgroup.marte.rapidrma.task.QueueingKind <em>Queueing Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Queueing Kind</em>'.
	 * @see com.thalesgroup.marte.rapidrma.task.QueueingKind
	 * @generated
	 */
	EEnum getQueueingKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	TaskFactory getTaskFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals  {
		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl <em>Task</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskImpl
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getTask()
		 * @generated
		 */
		EClass TASK = eINSTANCE.getTask();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__NAME = eINSTANCE.getTask_Name();

		/**
		 * The meta object literal for the '<em><b>Ready Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__READY_TIME = eINSTANCE.getTask_ReadyTime();

		/**
		 * The meta object literal for the '<em><b>Rel Deadline</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__REL_DEADLINE = eINSTANCE.getTask_RelDeadline();

		/**
		 * The meta object literal for the '<em><b>Drop Deadline</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__DROP_DEADLINE = eINSTANCE.getTask_DropDeadline();

		/**
		 * The meta object literal for the '<em><b>Phase</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__PHASE = eINSTANCE.getTask_Phase();

		/**
		 * The meta object literal for the '<em><b>Priority</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__PRIORITY = eINSTANCE.getTask_Priority();

		/**
		 * The meta object literal for the '<em><b>Network Qo S</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__NETWORK_QO_S = eINSTANCE.getTask_NetworkQoS();

		/**
		 * The meta object literal for the '<em><b>Active Resource</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TASK__ACTIVE_RESOURCE = eINSTANCE.getTask_ActiveResource();

		/**
		 * The meta object literal for the '<em><b>Deadline</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__DEADLINE = eINSTANCE.getTask_Deadline();

		/**
		 * The meta object literal for the '<em><b>Instances</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__INSTANCES = eINSTANCE.getTask_Instances();

		/**
		 * The meta object literal for the '<em><b>Comments</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__COMMENTS = eINSTANCE.getTask_Comments();

		/**
		 * The meta object literal for the '<em><b>XCoord</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__XCOORD = eINSTANCE.getTask_XCoord();

		/**
		 * The meta object literal for the '<em><b>YCoord</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TASK__YCOORD = eINSTANCE.getTask_YCoord();

		/**
		 * The meta object literal for the '<em><b>Period</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TASK__PERIOD = eINSTANCE.getTask_Period();

		/**
		 * The meta object literal for the '<em><b>Amount Of Work</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TASK__AMOUNT_OF_WORK = eINSTANCE.getTask_AmountOfWork();

		/**
		 * The meta object literal for the '<em><b>Intermediate</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TASK__INTERMEDIATE = eINSTANCE.getTask_Intermediate();

		/**
		 * The meta object literal for the '<em><b>Dependency</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TASK__DEPENDENCY = eINSTANCE.getTask_Dependency();

		/**
		 * The meta object literal for the '<em><b>Non Premptible</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TASK__NON_PREMPTIBLE = eINSTANCE.getTask_NonPremptible();

		/**
		 * The meta object literal for the '<em><b>Resourceusage</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TASK__RESOURCEUSAGE = eINSTANCE.getTask_Resourceusage();

		/**
		 * The meta object literal for the '<em><b>Server</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TASK__SERVER = eINSTANCE.getTask_Server();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.impl.DistributionImpl <em>Distribution</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.impl.DistributionImpl
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getDistribution()
		 * @generated
		 */
		EClass DISTRIBUTION = eINSTANCE.getDistribution();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DISTRIBUTION__VALUE = eINSTANCE.getDistribution_Value();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.impl.IntermediateDeadlineImpl <em>Intermediate Deadline</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.impl.IntermediateDeadlineImpl
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getIntermediateDeadline()
		 * @generated
		 */
		EClass INTERMEDIATE_DEADLINE = eINSTANCE.getIntermediateDeadline();

		/**
		 * The meta object literal for the '<em><b>Work Remaining</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INTERMEDIATE_DEADLINE__WORK_REMAINING = eINSTANCE.getIntermediateDeadline_WorkRemaining();

		/**
		 * The meta object literal for the '<em><b>Start Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INTERMEDIATE_DEADLINE__START_TIME = eINSTANCE.getIntermediateDeadline_StartTime();

		/**
		 * The meta object literal for the '<em><b>End Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INTERMEDIATE_DEADLINE__END_TIME = eINSTANCE.getIntermediateDeadline_EndTime();

		/**
		 * The meta object literal for the '<em><b>Int Deadline</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INTERMEDIATE_DEADLINE__INT_DEADLINE = eINSTANCE.getIntermediateDeadline_IntDeadline();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.impl.NonPremptibleSectionImpl <em>Non Premptible Section</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.impl.NonPremptibleSectionImpl
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getNonPremptibleSection()
		 * @generated
		 */
		EClass NON_PREMPTIBLE_SECTION = eINSTANCE.getNonPremptibleSection();

		/**
		 * The meta object literal for the '<em><b>Start Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NON_PREMPTIBLE_SECTION__START_TIME = eINSTANCE.getNonPremptibleSection_StartTime();

		/**
		 * The meta object literal for the '<em><b>End Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NON_PREMPTIBLE_SECTION__END_TIME = eINSTANCE.getNonPremptibleSection_EndTime();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.impl.ResourceUsageImpl <em>Resource Usage</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.impl.ResourceUsageImpl
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getResourceUsage()
		 * @generated
		 */
		EClass RESOURCE_USAGE = eINSTANCE.getResourceUsage();

		/**
		 * The meta object literal for the '<em><b>Resource</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RESOURCE_USAGE__RESOURCE = eINSTANCE.getResourceUsage_Resource();

		/**
		 * The meta object literal for the '<em><b>Start Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESOURCE_USAGE__START_TIME = eINSTANCE.getResourceUsage_StartTime();

		/**
		 * The meta object literal for the '<em><b>End Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESOURCE_USAGE__END_TIME = eINSTANCE.getResourceUsage_EndTime();

		/**
		 * The meta object literal for the '<em><b>Acquisition Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESOURCE_USAGE__ACQUISITION_TIME = eINSTANCE.getResourceUsage_AcquisitionTime();

		/**
		 * The meta object literal for the '<em><b>Deacquisition Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESOURCE_USAGE__DEACQUISITION_TIME = eINSTANCE.getResourceUsage_DeacquisitionTime();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl <em>Periodic Server</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getPeriodicServer()
		 * @generated
		 */
		EClass PERIODIC_SERVER = eINSTANCE.getPeriodicServer();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERIODIC_SERVER__NAME = eINSTANCE.getPeriodicServer_Name();

		/**
		 * The meta object literal for the '<em><b>Period</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERIODIC_SERVER__PERIOD = eINSTANCE.getPeriodicServer_Period();

		/**
		 * The meta object literal for the '<em><b>Budget</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERIODIC_SERVER__BUDGET = eINSTANCE.getPeriodicServer_Budget();

		/**
		 * The meta object literal for the '<em><b>Rel Deadline</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERIODIC_SERVER__REL_DEADLINE = eINSTANCE.getPeriodicServer_RelDeadline();

		/**
		 * The meta object literal for the '<em><b>Phase</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERIODIC_SERVER__PHASE = eINSTANCE.getPeriodicServer_Phase();

		/**
		 * The meta object literal for the '<em><b>Priority</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERIODIC_SERVER__PRIORITY = eINSTANCE.getPeriodicServer_Priority();

		/**
		 * The meta object literal for the '<em><b>Active Resource</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PERIODIC_SERVER__ACTIVE_RESOURCE = eINSTANCE.getPeriodicServer_ActiveResource();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERIODIC_SERVER__TYPE = eINSTANCE.getPeriodicServer_Type();

		/**
		 * The meta object literal for the '<em><b>Queueing</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERIODIC_SERVER__QUEUEING = eINSTANCE.getPeriodicServer_Queueing();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.impl.DeterministicImpl <em>Deterministic</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.impl.DeterministicImpl
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getDeterministic()
		 * @generated
		 */
		EClass DETERMINISTIC = eINSTANCE.getDeterministic();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.impl.UniformImpl <em>Uniform</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.impl.UniformImpl
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getUniform()
		 * @generated
		 */
		EClass UNIFORM = eINSTANCE.getUniform();

		/**
		 * The meta object literal for the '<em><b>Min</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UNIFORM__MIN = eINSTANCE.getUniform_Min();

		/**
		 * The meta object literal for the '<em><b>Max</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UNIFORM__MAX = eINSTANCE.getUniform_Max();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.impl.ExponentialImpl <em>Exponential</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.impl.ExponentialImpl
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getExponential()
		 * @generated
		 */
		EClass EXPONENTIAL = eINSTANCE.getExponential();

		/**
		 * The meta object literal for the '<em><b>Min</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXPONENTIAL__MIN = eINSTANCE.getExponential_Min();

		/**
		 * The meta object literal for the '<em><b>Avg</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXPONENTIAL__AVG = eINSTANCE.getExponential_Avg();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.impl.TaskGraphImpl <em>Graph</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskGraphImpl
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getTaskGraph()
		 * @generated
		 */
		EClass TASK_GRAPH = eINSTANCE.getTaskGraph();

		/**
		 * The meta object literal for the '<em><b>Task</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TASK_GRAPH__TASK = eINSTANCE.getTaskGraph_Task();

		/**
		 * The meta object literal for the '<em><b>Server</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TASK_GRAPH__SERVER = eINSTANCE.getTaskGraph_Server();

		/**
		 * The meta object literal for the '<em><b>Db</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TASK_GRAPH__DB = eINSTANCE.getTaskGraph_Db();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.DeadlineKind <em>Deadline Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.DeadlineKind
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getDeadlineKind()
		 * @generated
		 */
		EEnum DEADLINE_KIND = eINSTANCE.getDeadlineKind();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.ServerKind <em>Server Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.ServerKind
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getServerKind()
		 * @generated
		 */
		EEnum SERVER_KIND = eINSTANCE.getServerKind();

		/**
		 * The meta object literal for the '{@link com.thalesgroup.marte.rapidrma.task.QueueingKind <em>Queueing Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.thalesgroup.marte.rapidrma.task.QueueingKind
		 * @see com.thalesgroup.marte.rapidrma.task.impl.TaskPackageImpl#getQueueingKind()
		 * @generated
		 */
		EEnum QUEUEING_KIND = eINSTANCE.getQueueingKind();

	}

} //TaskPackage
