/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: PeriodicServerImpl.java,v 1.2 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.task.impl;

import com.thalesgroup.marte.rapidrma.resource.Resource;

import com.thalesgroup.marte.rapidrma.task.PeriodicServer;
import com.thalesgroup.marte.rapidrma.task.QueueingKind;
import com.thalesgroup.marte.rapidrma.task.ServerKind;
import com.thalesgroup.marte.rapidrma.task.TaskPackage;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Periodic Server</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl#getName <em>Name</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl#getPeriod <em>Period</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl#getBudget <em>Budget</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl#getRelDeadline <em>Rel Deadline</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl#getPhase <em>Phase</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl#getPriority <em>Priority</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl#getActiveResource <em>Active Resource</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl#getType <em>Type</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.PeriodicServerImpl#getQueueing <em>Queueing</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PeriodicServerImpl extends EObjectImpl implements PeriodicServer {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getPeriod() <em>Period</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPeriod()
	 * @generated
	 * @ordered
	 */
	protected static final int PERIOD_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPeriod() <em>Period</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPeriod()
	 * @generated
	 * @ordered
	 */
	protected int period = PERIOD_EDEFAULT;

	/**
	 * The default value of the '{@link #getBudget() <em>Budget</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBudget()
	 * @generated
	 * @ordered
	 */
	protected static final int BUDGET_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getBudget() <em>Budget</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBudget()
	 * @generated
	 * @ordered
	 */
	protected int budget = BUDGET_EDEFAULT;

	/**
	 * The default value of the '{@link #getRelDeadline() <em>Rel Deadline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRelDeadline()
	 * @generated
	 * @ordered
	 */
	protected static final int REL_DEADLINE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getRelDeadline() <em>Rel Deadline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRelDeadline()
	 * @generated
	 * @ordered
	 */
	protected int relDeadline = REL_DEADLINE_EDEFAULT;

	/**
	 * The default value of the '{@link #getPhase() <em>Phase</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPhase()
	 * @generated
	 * @ordered
	 */
	protected static final int PHASE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPhase() <em>Phase</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPhase()
	 * @generated
	 * @ordered
	 */
	protected int phase = PHASE_EDEFAULT;

	/**
	 * The default value of the '{@link #getPriority() <em>Priority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPriority()
	 * @generated
	 * @ordered
	 */
	protected static final int PRIORITY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPriority() <em>Priority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPriority()
	 * @generated
	 * @ordered
	 */
	protected int priority = PRIORITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getActiveResource() <em>Active Resource</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getActiveResource()
	 * @generated
	 * @ordered
	 */
	protected Resource activeResource = null;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final ServerKind TYPE_EDEFAULT = ServerKind.SPORATIC_LITERAL;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected ServerKind type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getQueueing() <em>Queueing</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQueueing()
	 * @generated
	 * @ordered
	 */
	protected static final QueueingKind QUEUEING_EDEFAULT = QueueingKind.FIFO_LITERAL;

	/**
	 * The cached value of the '{@link #getQueueing() <em>Queueing</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQueueing()
	 * @generated
	 * @ordered
	 */
	protected QueueingKind queueing = QUEUEING_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PeriodicServerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TaskPackage.Literals.PERIODIC_SERVER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.PERIODIC_SERVER__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getPeriod() {
		return period;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPeriod(int newPeriod) {
		int oldPeriod = period;
		period = newPeriod;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.PERIODIC_SERVER__PERIOD, oldPeriod, period));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getBudget() {
		return budget;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBudget(int newBudget) {
		int oldBudget = budget;
		budget = newBudget;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.PERIODIC_SERVER__BUDGET, oldBudget, budget));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getRelDeadline() {
		return relDeadline;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRelDeadline(int newRelDeadline) {
		int oldRelDeadline = relDeadline;
		relDeadline = newRelDeadline;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.PERIODIC_SERVER__REL_DEADLINE, oldRelDeadline, relDeadline));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getPhase() {
		return phase;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPhase(int newPhase) {
		int oldPhase = phase;
		phase = newPhase;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.PERIODIC_SERVER__PHASE, oldPhase, phase));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getPriority() {
		return priority;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPriority(int newPriority) {
		int oldPriority = priority;
		priority = newPriority;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.PERIODIC_SERVER__PRIORITY, oldPriority, priority));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Resource getActiveResource() {
		if (activeResource != null && activeResource.eIsProxy()) {
			InternalEObject oldActiveResource = (InternalEObject)activeResource;
			activeResource = (Resource)eResolveProxy(oldActiveResource);
			if (activeResource != oldActiveResource) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TaskPackage.PERIODIC_SERVER__ACTIVE_RESOURCE, oldActiveResource, activeResource));
			}
		}
		return activeResource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Resource basicGetActiveResource() {
		return activeResource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setActiveResource(Resource newActiveResource) {
		Resource oldActiveResource = activeResource;
		activeResource = newActiveResource;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.PERIODIC_SERVER__ACTIVE_RESOURCE, oldActiveResource, activeResource));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ServerKind getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(ServerKind newType) {
		ServerKind oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.PERIODIC_SERVER__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QueueingKind getQueueing() {
		return queueing;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setQueueing(QueueingKind newQueueing) {
		QueueingKind oldQueueing = queueing;
		queueing = newQueueing == null ? QUEUEING_EDEFAULT : newQueueing;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.PERIODIC_SERVER__QUEUEING, oldQueueing, queueing));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TaskPackage.PERIODIC_SERVER__NAME:
				return getName();
			case TaskPackage.PERIODIC_SERVER__PERIOD:
				return new Integer(getPeriod());
			case TaskPackage.PERIODIC_SERVER__BUDGET:
				return new Integer(getBudget());
			case TaskPackage.PERIODIC_SERVER__REL_DEADLINE:
				return new Integer(getRelDeadline());
			case TaskPackage.PERIODIC_SERVER__PHASE:
				return new Integer(getPhase());
			case TaskPackage.PERIODIC_SERVER__PRIORITY:
				return new Integer(getPriority());
			case TaskPackage.PERIODIC_SERVER__ACTIVE_RESOURCE:
				if (resolve) return getActiveResource();
				return basicGetActiveResource();
			case TaskPackage.PERIODIC_SERVER__TYPE:
				return getType();
			case TaskPackage.PERIODIC_SERVER__QUEUEING:
				return getQueueing();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TaskPackage.PERIODIC_SERVER__NAME:
				setName((String)newValue);
				return;
			case TaskPackage.PERIODIC_SERVER__PERIOD:
				setPeriod(((Integer)newValue).intValue());
				return;
			case TaskPackage.PERIODIC_SERVER__BUDGET:
				setBudget(((Integer)newValue).intValue());
				return;
			case TaskPackage.PERIODIC_SERVER__REL_DEADLINE:
				setRelDeadline(((Integer)newValue).intValue());
				return;
			case TaskPackage.PERIODIC_SERVER__PHASE:
				setPhase(((Integer)newValue).intValue());
				return;
			case TaskPackage.PERIODIC_SERVER__PRIORITY:
				setPriority(((Integer)newValue).intValue());
				return;
			case TaskPackage.PERIODIC_SERVER__ACTIVE_RESOURCE:
				setActiveResource((Resource)newValue);
				return;
			case TaskPackage.PERIODIC_SERVER__TYPE:
				setType((ServerKind)newValue);
				return;
			case TaskPackage.PERIODIC_SERVER__QUEUEING:
				setQueueing((QueueingKind)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case TaskPackage.PERIODIC_SERVER__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TaskPackage.PERIODIC_SERVER__PERIOD:
				setPeriod(PERIOD_EDEFAULT);
				return;
			case TaskPackage.PERIODIC_SERVER__BUDGET:
				setBudget(BUDGET_EDEFAULT);
				return;
			case TaskPackage.PERIODIC_SERVER__REL_DEADLINE:
				setRelDeadline(REL_DEADLINE_EDEFAULT);
				return;
			case TaskPackage.PERIODIC_SERVER__PHASE:
				setPhase(PHASE_EDEFAULT);
				return;
			case TaskPackage.PERIODIC_SERVER__PRIORITY:
				setPriority(PRIORITY_EDEFAULT);
				return;
			case TaskPackage.PERIODIC_SERVER__ACTIVE_RESOURCE:
				setActiveResource((Resource)null);
				return;
			case TaskPackage.PERIODIC_SERVER__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case TaskPackage.PERIODIC_SERVER__QUEUEING:
				setQueueing(QUEUEING_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TaskPackage.PERIODIC_SERVER__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TaskPackage.PERIODIC_SERVER__PERIOD:
				return period != PERIOD_EDEFAULT;
			case TaskPackage.PERIODIC_SERVER__BUDGET:
				return budget != BUDGET_EDEFAULT;
			case TaskPackage.PERIODIC_SERVER__REL_DEADLINE:
				return relDeadline != REL_DEADLINE_EDEFAULT;
			case TaskPackage.PERIODIC_SERVER__PHASE:
				return phase != PHASE_EDEFAULT;
			case TaskPackage.PERIODIC_SERVER__PRIORITY:
				return priority != PRIORITY_EDEFAULT;
			case TaskPackage.PERIODIC_SERVER__ACTIVE_RESOURCE:
				return activeResource != null;
			case TaskPackage.PERIODIC_SERVER__TYPE:
				return type != TYPE_EDEFAULT;
			case TaskPackage.PERIODIC_SERVER__QUEUEING:
				return queueing != QUEUEING_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", period: ");
		result.append(period);
		result.append(", budget: ");
		result.append(budget);
		result.append(", relDeadline: ");
		result.append(relDeadline);
		result.append(", phase: ");
		result.append(phase);
		result.append(", priority: ");
		result.append(priority);
		result.append(", type: ");
		result.append(type);
		result.append(", queueing: ");
		result.append(queueing);
		result.append(')');
		return result.toString();
	}

} //PeriodicServerImpl