/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: TaskGraphImpl.java,v 1.2 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.task.impl;

import com.thalesgroup.marte.rapidrma.database.Database;
import com.thalesgroup.marte.rapidrma.database.DatabasePackage;

import com.thalesgroup.marte.rapidrma.task.PeriodicServer;
import com.thalesgroup.marte.rapidrma.task.Task;
import com.thalesgroup.marte.rapidrma.task.TaskGraph;
import com.thalesgroup.marte.rapidrma.task.TaskPackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Graph</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskGraphImpl#getTask <em>Task</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskGraphImpl#getServer <em>Server</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskGraphImpl#getDb <em>Db</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TaskGraphImpl extends EObjectImpl implements TaskGraph {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * The cached value of the '{@link #getTask() <em>Task</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTask()
	 * @generated
	 * @ordered
	 */
	protected EList task = null;

	/**
	 * The cached value of the '{@link #getServer() <em>Server</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServer()
	 * @generated
	 * @ordered
	 */
	protected EList server = null;

	/**
	 * The cached value of the '{@link #getDb() <em>Db</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDb()
	 * @generated
	 * @ordered
	 */
	protected Database db = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskGraphImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TaskPackage.Literals.TASK_GRAPH;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getTask() {
		if (task == null) {
			task = new EObjectContainmentEList(Task.class, this, TaskPackage.TASK_GRAPH__TASK);
		}
		return task;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getServer() {
		if (server == null) {
			server = new EObjectContainmentEList(PeriodicServer.class, this, TaskPackage.TASK_GRAPH__SERVER);
		}
		return server;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Database getDb() {
		if (db != null && db.eIsProxy()) {
			InternalEObject oldDb = (InternalEObject)db;
			db = (Database)eResolveProxy(oldDb);
			if (db != oldDb) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TaskPackage.TASK_GRAPH__DB, oldDb, db));
			}
		}
		return db;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Database basicGetDb() {
		return db;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDb(Database newDb, NotificationChain msgs) {
		Database oldDb = db;
		db = newDb;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TaskPackage.TASK_GRAPH__DB, oldDb, newDb);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDb(Database newDb) {
		if (newDb != db) {
			NotificationChain msgs = null;
			if (db != null)
				msgs = ((InternalEObject)db).eInverseRemove(this, DatabasePackage.DATABASE__TASK, Database.class, msgs);
			if (newDb != null)
				msgs = ((InternalEObject)newDb).eInverseAdd(this, DatabasePackage.DATABASE__TASK, Database.class, msgs);
			msgs = basicSetDb(newDb, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK_GRAPH__DB, newDb, newDb));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TaskPackage.TASK_GRAPH__DB:
				if (db != null)
					msgs = ((InternalEObject)db).eInverseRemove(this, DatabasePackage.DATABASE__TASK, Database.class, msgs);
				return basicSetDb((Database)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TaskPackage.TASK_GRAPH__TASK:
				return ((InternalEList)getTask()).basicRemove(otherEnd, msgs);
			case TaskPackage.TASK_GRAPH__SERVER:
				return ((InternalEList)getServer()).basicRemove(otherEnd, msgs);
			case TaskPackage.TASK_GRAPH__DB:
				return basicSetDb(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TaskPackage.TASK_GRAPH__TASK:
				return getTask();
			case TaskPackage.TASK_GRAPH__SERVER:
				return getServer();
			case TaskPackage.TASK_GRAPH__DB:
				if (resolve) return getDb();
				return basicGetDb();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TaskPackage.TASK_GRAPH__TASK:
				getTask().clear();
				getTask().addAll((Collection)newValue);
				return;
			case TaskPackage.TASK_GRAPH__SERVER:
				getServer().clear();
				getServer().addAll((Collection)newValue);
				return;
			case TaskPackage.TASK_GRAPH__DB:
				setDb((Database)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case TaskPackage.TASK_GRAPH__TASK:
				getTask().clear();
				return;
			case TaskPackage.TASK_GRAPH__SERVER:
				getServer().clear();
				return;
			case TaskPackage.TASK_GRAPH__DB:
				setDb((Database)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TaskPackage.TASK_GRAPH__TASK:
				return task != null && !task.isEmpty();
			case TaskPackage.TASK_GRAPH__SERVER:
				return server != null && !server.isEmpty();
			case TaskPackage.TASK_GRAPH__DB:
				return db != null;
		}
		return super.eIsSet(featureID);
	}

} //TaskGraphImpl