/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: TaskImpl.java,v 1.2 2008/06/16 13:56:07 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.task.impl;

import com.thalesgroup.marte.rapidrma.resource.Resource;

import com.thalesgroup.marte.rapidrma.task.DeadlineKind;
import com.thalesgroup.marte.rapidrma.task.Distribution;
import com.thalesgroup.marte.rapidrma.task.IntermediateDeadline;
import com.thalesgroup.marte.rapidrma.task.NonPremptibleSection;
import com.thalesgroup.marte.rapidrma.task.PeriodicServer;
import com.thalesgroup.marte.rapidrma.task.ResourceUsage;
import com.thalesgroup.marte.rapidrma.task.Task;
import com.thalesgroup.marte.rapidrma.task.TaskPackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Task</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getName <em>Name</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getReadyTime <em>Ready Time</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getRelDeadline <em>Rel Deadline</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getDropDeadline <em>Drop Deadline</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getPhase <em>Phase</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getPriority <em>Priority</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getNetworkQoS <em>Network Qo S</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getActiveResource <em>Active Resource</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getDeadline <em>Deadline</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getInstances <em>Instances</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getComments <em>Comments</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getXCoord <em>XCoord</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getYCoord <em>YCoord</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getPeriod <em>Period</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getAmountOfWork <em>Amount Of Work</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getIntermediate <em>Intermediate</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getDependency <em>Dependency</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getNonPremptible <em>Non Premptible</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getResourceusage <em>Resourceusage</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.task.impl.TaskImpl#getServer <em>Server</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TaskImpl extends EObjectImpl implements Task {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getReadyTime() <em>Ready Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReadyTime()
	 * @generated
	 * @ordered
	 */
	protected static final int READY_TIME_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getReadyTime() <em>Ready Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReadyTime()
	 * @generated
	 * @ordered
	 */
	protected int readyTime = READY_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getRelDeadline() <em>Rel Deadline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRelDeadline()
	 * @generated
	 * @ordered
	 */
	protected static final int REL_DEADLINE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getRelDeadline() <em>Rel Deadline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRelDeadline()
	 * @generated
	 * @ordered
	 */
	protected int relDeadline = REL_DEADLINE_EDEFAULT;

	/**
	 * The default value of the '{@link #getDropDeadline() <em>Drop Deadline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDropDeadline()
	 * @generated
	 * @ordered
	 */
	protected static final int DROP_DEADLINE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getDropDeadline() <em>Drop Deadline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDropDeadline()
	 * @generated
	 * @ordered
	 */
	protected int dropDeadline = DROP_DEADLINE_EDEFAULT;

	/**
	 * The default value of the '{@link #getPhase() <em>Phase</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPhase()
	 * @generated
	 * @ordered
	 */
	protected static final int PHASE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPhase() <em>Phase</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPhase()
	 * @generated
	 * @ordered
	 */
	protected int phase = PHASE_EDEFAULT;

	/**
	 * The default value of the '{@link #getPriority() <em>Priority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPriority()
	 * @generated
	 * @ordered
	 */
	protected static final int PRIORITY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPriority() <em>Priority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPriority()
	 * @generated
	 * @ordered
	 */
	protected int priority = PRIORITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getNetworkQoS() <em>Network Qo S</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNetworkQoS()
	 * @generated
	 * @ordered
	 */
	protected static final int NETWORK_QO_S_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getNetworkQoS() <em>Network Qo S</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNetworkQoS()
	 * @generated
	 * @ordered
	 */
	protected int networkQoS = NETWORK_QO_S_EDEFAULT;

	/**
	 * The cached value of the '{@link #getActiveResource() <em>Active Resource</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getActiveResource()
	 * @generated
	 * @ordered
	 */
	protected Resource activeResource = null;

	/**
	 * The default value of the '{@link #getDeadline() <em>Deadline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeadline()
	 * @generated
	 * @ordered
	 */
	protected static final DeadlineKind DEADLINE_EDEFAULT = DeadlineKind.HARD_DEADLINE_LITERAL;

	/**
	 * The cached value of the '{@link #getDeadline() <em>Deadline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeadline()
	 * @generated
	 * @ordered
	 */
	protected DeadlineKind deadline = DEADLINE_EDEFAULT;

	/**
	 * The default value of the '{@link #getInstances() <em>Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstances()
	 * @generated
	 * @ordered
	 */
	protected static final int INSTANCES_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getInstances() <em>Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstances()
	 * @generated
	 * @ordered
	 */
	protected int instances = INSTANCES_EDEFAULT;

	/**
	 * The default value of the '{@link #getComments() <em>Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComments()
	 * @generated
	 * @ordered
	 */
	protected static final String COMMENTS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getComments() <em>Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComments()
	 * @generated
	 * @ordered
	 */
	protected String comments = COMMENTS_EDEFAULT;

	/**
	 * The default value of the '{@link #getXCoord() <em>XCoord</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXCoord()
	 * @generated
	 * @ordered
	 */
	protected static final int XCOORD_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getXCoord() <em>XCoord</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXCoord()
	 * @generated
	 * @ordered
	 */
	protected int xCoord = XCOORD_EDEFAULT;

	/**
	 * The default value of the '{@link #getYCoord() <em>YCoord</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getYCoord()
	 * @generated
	 * @ordered
	 */
	protected static final int YCOORD_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getYCoord() <em>YCoord</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getYCoord()
	 * @generated
	 * @ordered
	 */
	protected int yCoord = YCOORD_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPeriod() <em>Period</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPeriod()
	 * @generated
	 * @ordered
	 */
	protected Distribution period = null;

	/**
	 * The cached value of the '{@link #getAmountOfWork() <em>Amount Of Work</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAmountOfWork()
	 * @generated
	 * @ordered
	 */
	protected Distribution amountOfWork = null;

	/**
	 * The cached value of the '{@link #getIntermediate() <em>Intermediate</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIntermediate()
	 * @generated
	 * @ordered
	 */
	protected EList intermediate = null;

	/**
	 * The cached value of the '{@link #getDependency() <em>Dependency</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDependency()
	 * @generated
	 * @ordered
	 */
	protected EList dependency = null;

	/**
	 * The cached value of the '{@link #getNonPremptible() <em>Non Premptible</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNonPremptible()
	 * @generated
	 * @ordered
	 */
	protected EList nonPremptible = null;

	/**
	 * The cached value of the '{@link #getResourceusage() <em>Resourceusage</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResourceusage()
	 * @generated
	 * @ordered
	 */
	protected EList resourceusage = null;

	/**
	 * The cached value of the '{@link #getServer() <em>Server</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServer()
	 * @generated
	 * @ordered
	 */
	protected PeriodicServer server = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TaskPackage.Literals.TASK;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getReadyTime() {
		return readyTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReadyTime(int newReadyTime) {
		int oldReadyTime = readyTime;
		readyTime = newReadyTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__READY_TIME, oldReadyTime, readyTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getRelDeadline() {
		return relDeadline;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRelDeadline(int newRelDeadline) {
		int oldRelDeadline = relDeadline;
		relDeadline = newRelDeadline;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__REL_DEADLINE, oldRelDeadline, relDeadline));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getDropDeadline() {
		return dropDeadline;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDropDeadline(int newDropDeadline) {
		int oldDropDeadline = dropDeadline;
		dropDeadline = newDropDeadline;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__DROP_DEADLINE, oldDropDeadline, dropDeadline));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getPhase() {
		return phase;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPhase(int newPhase) {
		int oldPhase = phase;
		phase = newPhase;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__PHASE, oldPhase, phase));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getPriority() {
		return priority;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPriority(int newPriority) {
		int oldPriority = priority;
		priority = newPriority;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__PRIORITY, oldPriority, priority));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getNetworkQoS() {
		return networkQoS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNetworkQoS(int newNetworkQoS) {
		int oldNetworkQoS = networkQoS;
		networkQoS = newNetworkQoS;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__NETWORK_QO_S, oldNetworkQoS, networkQoS));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Resource getActiveResource() {
		if (activeResource != null && activeResource.eIsProxy()) {
			InternalEObject oldActiveResource = (InternalEObject)activeResource;
			activeResource = (Resource)eResolveProxy(oldActiveResource);
			if (activeResource != oldActiveResource) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TaskPackage.TASK__ACTIVE_RESOURCE, oldActiveResource, activeResource));
			}
		}
		return activeResource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Resource basicGetActiveResource() {
		return activeResource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setActiveResource(Resource newActiveResource) {
		Resource oldActiveResource = activeResource;
		activeResource = newActiveResource;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__ACTIVE_RESOURCE, oldActiveResource, activeResource));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeadlineKind getDeadline() {
		return deadline;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeadline(DeadlineKind newDeadline) {
		DeadlineKind oldDeadline = deadline;
		deadline = newDeadline == null ? DEADLINE_EDEFAULT : newDeadline;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__DEADLINE, oldDeadline, deadline));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getInstances() {
		return instances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInstances(int newInstances) {
		int oldInstances = instances;
		instances = newInstances;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__INSTANCES, oldInstances, instances));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getComments() {
		return comments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setComments(String newComments) {
		String oldComments = comments;
		comments = newComments;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__COMMENTS, oldComments, comments));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getXCoord() {
		return xCoord;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setXCoord(int newXCoord) {
		int oldXCoord = xCoord;
		xCoord = newXCoord;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__XCOORD, oldXCoord, xCoord));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getYCoord() {
		return yCoord;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setYCoord(int newYCoord) {
		int oldYCoord = yCoord;
		yCoord = newYCoord;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__YCOORD, oldYCoord, yCoord));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Distribution getPeriod() {
		return period;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPeriod(Distribution newPeriod, NotificationChain msgs) {
		Distribution oldPeriod = period;
		period = newPeriod;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__PERIOD, oldPeriod, newPeriod);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPeriod(Distribution newPeriod) {
		if (newPeriod != period) {
			NotificationChain msgs = null;
			if (period != null)
				msgs = ((InternalEObject)period).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - TaskPackage.TASK__PERIOD, null, msgs);
			if (newPeriod != null)
				msgs = ((InternalEObject)newPeriod).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - TaskPackage.TASK__PERIOD, null, msgs);
			msgs = basicSetPeriod(newPeriod, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__PERIOD, newPeriod, newPeriod));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Distribution getAmountOfWork() {
		return amountOfWork;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAmountOfWork(Distribution newAmountOfWork, NotificationChain msgs) {
		Distribution oldAmountOfWork = amountOfWork;
		amountOfWork = newAmountOfWork;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__AMOUNT_OF_WORK, oldAmountOfWork, newAmountOfWork);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAmountOfWork(Distribution newAmountOfWork) {
		if (newAmountOfWork != amountOfWork) {
			NotificationChain msgs = null;
			if (amountOfWork != null)
				msgs = ((InternalEObject)amountOfWork).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - TaskPackage.TASK__AMOUNT_OF_WORK, null, msgs);
			if (newAmountOfWork != null)
				msgs = ((InternalEObject)newAmountOfWork).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - TaskPackage.TASK__AMOUNT_OF_WORK, null, msgs);
			msgs = basicSetAmountOfWork(newAmountOfWork, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__AMOUNT_OF_WORK, newAmountOfWork, newAmountOfWork));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getIntermediate() {
		if (intermediate == null) {
			intermediate = new EObjectContainmentEList(IntermediateDeadline.class, this, TaskPackage.TASK__INTERMEDIATE);
		}
		return intermediate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDependency() {
		if (dependency == null) {
			dependency = new EObjectResolvingEList(Task.class, this, TaskPackage.TASK__DEPENDENCY);
		}
		return dependency;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getNonPremptible() {
		if (nonPremptible == null) {
			nonPremptible = new EObjectContainmentEList(NonPremptibleSection.class, this, TaskPackage.TASK__NON_PREMPTIBLE);
		}
		return nonPremptible;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getResourceusage() {
		if (resourceusage == null) {
			resourceusage = new EObjectContainmentEList(ResourceUsage.class, this, TaskPackage.TASK__RESOURCEUSAGE);
		}
		return resourceusage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PeriodicServer getServer() {
		if (server != null && server.eIsProxy()) {
			InternalEObject oldServer = (InternalEObject)server;
			server = (PeriodicServer)eResolveProxy(oldServer);
			if (server != oldServer) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TaskPackage.TASK__SERVER, oldServer, server));
			}
		}
		return server;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PeriodicServer basicGetServer() {
		return server;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setServer(PeriodicServer newServer) {
		PeriodicServer oldServer = server;
		server = newServer;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TaskPackage.TASK__SERVER, oldServer, server));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TaskPackage.TASK__PERIOD:
				return basicSetPeriod(null, msgs);
			case TaskPackage.TASK__AMOUNT_OF_WORK:
				return basicSetAmountOfWork(null, msgs);
			case TaskPackage.TASK__INTERMEDIATE:
				return ((InternalEList)getIntermediate()).basicRemove(otherEnd, msgs);
			case TaskPackage.TASK__NON_PREMPTIBLE:
				return ((InternalEList)getNonPremptible()).basicRemove(otherEnd, msgs);
			case TaskPackage.TASK__RESOURCEUSAGE:
				return ((InternalEList)getResourceusage()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TaskPackage.TASK__NAME:
				return getName();
			case TaskPackage.TASK__READY_TIME:
				return new Integer(getReadyTime());
			case TaskPackage.TASK__REL_DEADLINE:
				return new Integer(getRelDeadline());
			case TaskPackage.TASK__DROP_DEADLINE:
				return new Integer(getDropDeadline());
			case TaskPackage.TASK__PHASE:
				return new Integer(getPhase());
			case TaskPackage.TASK__PRIORITY:
				return new Integer(getPriority());
			case TaskPackage.TASK__NETWORK_QO_S:
				return new Integer(getNetworkQoS());
			case TaskPackage.TASK__ACTIVE_RESOURCE:
				if (resolve) return getActiveResource();
				return basicGetActiveResource();
			case TaskPackage.TASK__DEADLINE:
				return getDeadline();
			case TaskPackage.TASK__INSTANCES:
				return new Integer(getInstances());
			case TaskPackage.TASK__COMMENTS:
				return getComments();
			case TaskPackage.TASK__XCOORD:
				return new Integer(getXCoord());
			case TaskPackage.TASK__YCOORD:
				return new Integer(getYCoord());
			case TaskPackage.TASK__PERIOD:
				return getPeriod();
			case TaskPackage.TASK__AMOUNT_OF_WORK:
				return getAmountOfWork();
			case TaskPackage.TASK__INTERMEDIATE:
				return getIntermediate();
			case TaskPackage.TASK__DEPENDENCY:
				return getDependency();
			case TaskPackage.TASK__NON_PREMPTIBLE:
				return getNonPremptible();
			case TaskPackage.TASK__RESOURCEUSAGE:
				return getResourceusage();
			case TaskPackage.TASK__SERVER:
				if (resolve) return getServer();
				return basicGetServer();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TaskPackage.TASK__NAME:
				setName((String)newValue);
				return;
			case TaskPackage.TASK__READY_TIME:
				setReadyTime(((Integer)newValue).intValue());
				return;
			case TaskPackage.TASK__REL_DEADLINE:
				setRelDeadline(((Integer)newValue).intValue());
				return;
			case TaskPackage.TASK__DROP_DEADLINE:
				setDropDeadline(((Integer)newValue).intValue());
				return;
			case TaskPackage.TASK__PHASE:
				setPhase(((Integer)newValue).intValue());
				return;
			case TaskPackage.TASK__PRIORITY:
				setPriority(((Integer)newValue).intValue());
				return;
			case TaskPackage.TASK__NETWORK_QO_S:
				setNetworkQoS(((Integer)newValue).intValue());
				return;
			case TaskPackage.TASK__ACTIVE_RESOURCE:
				setActiveResource((Resource)newValue);
				return;
			case TaskPackage.TASK__DEADLINE:
				setDeadline((DeadlineKind)newValue);
				return;
			case TaskPackage.TASK__INSTANCES:
				setInstances(((Integer)newValue).intValue());
				return;
			case TaskPackage.TASK__COMMENTS:
				setComments((String)newValue);
				return;
			case TaskPackage.TASK__XCOORD:
				setXCoord(((Integer)newValue).intValue());
				return;
			case TaskPackage.TASK__YCOORD:
				setYCoord(((Integer)newValue).intValue());
				return;
			case TaskPackage.TASK__PERIOD:
				setPeriod((Distribution)newValue);
				return;
			case TaskPackage.TASK__AMOUNT_OF_WORK:
				setAmountOfWork((Distribution)newValue);
				return;
			case TaskPackage.TASK__INTERMEDIATE:
				getIntermediate().clear();
				getIntermediate().addAll((Collection)newValue);
				return;
			case TaskPackage.TASK__DEPENDENCY:
				getDependency().clear();
				getDependency().addAll((Collection)newValue);
				return;
			case TaskPackage.TASK__NON_PREMPTIBLE:
				getNonPremptible().clear();
				getNonPremptible().addAll((Collection)newValue);
				return;
			case TaskPackage.TASK__RESOURCEUSAGE:
				getResourceusage().clear();
				getResourceusage().addAll((Collection)newValue);
				return;
			case TaskPackage.TASK__SERVER:
				setServer((PeriodicServer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case TaskPackage.TASK__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TaskPackage.TASK__READY_TIME:
				setReadyTime(READY_TIME_EDEFAULT);
				return;
			case TaskPackage.TASK__REL_DEADLINE:
				setRelDeadline(REL_DEADLINE_EDEFAULT);
				return;
			case TaskPackage.TASK__DROP_DEADLINE:
				setDropDeadline(DROP_DEADLINE_EDEFAULT);
				return;
			case TaskPackage.TASK__PHASE:
				setPhase(PHASE_EDEFAULT);
				return;
			case TaskPackage.TASK__PRIORITY:
				setPriority(PRIORITY_EDEFAULT);
				return;
			case TaskPackage.TASK__NETWORK_QO_S:
				setNetworkQoS(NETWORK_QO_S_EDEFAULT);
				return;
			case TaskPackage.TASK__ACTIVE_RESOURCE:
				setActiveResource((Resource)null);
				return;
			case TaskPackage.TASK__DEADLINE:
				setDeadline(DEADLINE_EDEFAULT);
				return;
			case TaskPackage.TASK__INSTANCES:
				setInstances(INSTANCES_EDEFAULT);
				return;
			case TaskPackage.TASK__COMMENTS:
				setComments(COMMENTS_EDEFAULT);
				return;
			case TaskPackage.TASK__XCOORD:
				setXCoord(XCOORD_EDEFAULT);
				return;
			case TaskPackage.TASK__YCOORD:
				setYCoord(YCOORD_EDEFAULT);
				return;
			case TaskPackage.TASK__PERIOD:
				setPeriod((Distribution)null);
				return;
			case TaskPackage.TASK__AMOUNT_OF_WORK:
				setAmountOfWork((Distribution)null);
				return;
			case TaskPackage.TASK__INTERMEDIATE:
				getIntermediate().clear();
				return;
			case TaskPackage.TASK__DEPENDENCY:
				getDependency().clear();
				return;
			case TaskPackage.TASK__NON_PREMPTIBLE:
				getNonPremptible().clear();
				return;
			case TaskPackage.TASK__RESOURCEUSAGE:
				getResourceusage().clear();
				return;
			case TaskPackage.TASK__SERVER:
				setServer((PeriodicServer)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TaskPackage.TASK__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TaskPackage.TASK__READY_TIME:
				return readyTime != READY_TIME_EDEFAULT;
			case TaskPackage.TASK__REL_DEADLINE:
				return relDeadline != REL_DEADLINE_EDEFAULT;
			case TaskPackage.TASK__DROP_DEADLINE:
				return dropDeadline != DROP_DEADLINE_EDEFAULT;
			case TaskPackage.TASK__PHASE:
				return phase != PHASE_EDEFAULT;
			case TaskPackage.TASK__PRIORITY:
				return priority != PRIORITY_EDEFAULT;
			case TaskPackage.TASK__NETWORK_QO_S:
				return networkQoS != NETWORK_QO_S_EDEFAULT;
			case TaskPackage.TASK__ACTIVE_RESOURCE:
				return activeResource != null;
			case TaskPackage.TASK__DEADLINE:
				return deadline != DEADLINE_EDEFAULT;
			case TaskPackage.TASK__INSTANCES:
				return instances != INSTANCES_EDEFAULT;
			case TaskPackage.TASK__COMMENTS:
				return COMMENTS_EDEFAULT == null ? comments != null : !COMMENTS_EDEFAULT.equals(comments);
			case TaskPackage.TASK__XCOORD:
				return xCoord != XCOORD_EDEFAULT;
			case TaskPackage.TASK__YCOORD:
				return yCoord != YCOORD_EDEFAULT;
			case TaskPackage.TASK__PERIOD:
				return period != null;
			case TaskPackage.TASK__AMOUNT_OF_WORK:
				return amountOfWork != null;
			case TaskPackage.TASK__INTERMEDIATE:
				return intermediate != null && !intermediate.isEmpty();
			case TaskPackage.TASK__DEPENDENCY:
				return dependency != null && !dependency.isEmpty();
			case TaskPackage.TASK__NON_PREMPTIBLE:
				return nonPremptible != null && !nonPremptible.isEmpty();
			case TaskPackage.TASK__RESOURCEUSAGE:
				return resourceusage != null && !resourceusage.isEmpty();
			case TaskPackage.TASK__SERVER:
				return server != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", readyTime: ");
		result.append(readyTime);
		result.append(", relDeadline: ");
		result.append(relDeadline);
		result.append(", dropDeadline: ");
		result.append(dropDeadline);
		result.append(", phase: ");
		result.append(phase);
		result.append(", priority: ");
		result.append(priority);
		result.append(", networkQoS: ");
		result.append(networkQoS);
		result.append(", deadline: ");
		result.append(deadline);
		result.append(", instances: ");
		result.append(instances);
		result.append(", comments: ");
		result.append(comments);
		result.append(", xCoord: ");
		result.append(xCoord);
		result.append(", yCoord: ");
		result.append(yCoord);
		result.append(')');
		return result.toString();
	}

} //TaskImpl