/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 */

package com.thalesgroup.vslviewer.extension;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.uml2.uml.ValueSpecification;

/**
 * The interface converter must implements.
 * This interface is used by the tree view when selection change to get
 * a VSL model from the selection (empty if not revelant). 
 * @author T0081227 Francois NIZOU - 18 oct. 07 
 *
 */
public interface VSLSelectionConverter {

	/**
	 * This method is called when the selection change. Implementer have
	 * to (if revelant) compute VSL Expression corresponding to the selection.
	 * @param selection the current selection
	 * @return the vsl expression represented/owned by the selection.
	 */
	public ValueSpecification convert(ISelection selection);
}
