/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright> 
 */

package com.thalesgroup.vslviewer.views;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.thalesgroup.vslviewer.treeObject.VSLTreeNode;


/**
 * This class is the content provider of the TreeView.
 * 
 * @see IContentProvider for more details
 * @author T0081227 Francois NIZOU - 18 oct. 07
 * 
 */
public class VSLContentProvider implements ITreeContentProvider {

	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof VSLTreeNode) {
			VSLTreeNode node = (VSLTreeNode) parentElement;
			if (!node.isLeaf())
				return node.getChilds().toArray();
			else
				return null;
		} else
			return null;
	}

	public Object getParent(Object element) {
		return null;
	}

	public boolean hasChildren(Object element) {
		if (element instanceof VSLTreeNode)
			return !((VSLTreeNode) element).isLeaf();
		else
			return false;
	}

	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

	public void dispose() {

	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {

	}

}
