/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright> 
 */

package com.thalesgroup.vslviewer.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.uml2.uml.ValueSpecification;

import com.thalesgroup.vslviewer.extension.ExtensionPoint;
import com.thalesgroup.vslviewer.extension.VSLSelectionConverter;
import com.thalesgroup.vslviewer.treeObject.VSLTreeNode;


/**
 * This class build the view, linking providers, treeview and selection listener
 * together.
 * 
 * @author T0081227 Francois NIZOU - 18 oct. 07
 * 
 */
public class VSLView extends ViewPart {

	protected TreeViewer treeViewer;

	@Override
	public void createPartControl(Composite parent) {
		treeViewer = new TreeViewer(parent);
		treeViewer.addDoubleClickListener(new DoubleCLickListener());
		treeViewer.setContentProvider(new VSLContentProvider());
		treeViewer.setLabelProvider(new VSLLabelProvider());
		setInitalInput();
		treeViewer.expandAll();

		PlatformUI.getWorkbench().getActiveWorkbenchWindow()
				.getSelectionService().addPostSelectionListener(
						new SelectionListener(treeViewer));

		IWorkbenchPage activePage = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();
		if (activePage != null)
			activePage.addSelectionListener(new SelectionListener(treeViewer));

	}

	private void setInitalInput() {
		IWorkbenchPage activePage = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();
		if (activePage != null) {
			ISelection selection = activePage.getSelection();
			VSLSelectionConverter converter = ExtensionPoint.instance()
					.getConverter();
			if (converter != null) {
				ValueSpecification vsl = converter.convert(selection);
				if (vsl != null) {
					VSLTreeNode root = VSLTreeNode.makeRoot(vsl);
					treeViewer.setInput(root);
					treeViewer.refresh();
					treeViewer.expandAll();
				}

			}
		}
	}

	@Override
	public void setFocus() {

	}

}
