/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: ConditionalExpression.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL;

import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.ValueSpecification;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Conditional Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link VSL.ConditionalExpression#getConditionExpr <em>Condition Expr</em>}</li>
 *   <li>{@link VSL.ConditionalExpression#getIfTrueExpr <em>If True Expr</em>}</li>
 *   <li>{@link VSL.ConditionalExpression#getIfFalseExpr <em>If False Expr</em>}</li>
 * </ul>
 * </p>
 *
 * @see VSL.VSLPackage#getConditionalExpression()
 * @model
 * @generated
 */
public interface ConditionalExpression extends Expression {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Condition Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Condition Expr</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Condition Expr</em>' containment reference.
	 * @see #setConditionExpr(ValueSpecification)
	 * @see VSL.VSLPackage#getConditionalExpression_ConditionExpr()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ValueSpecification getConditionExpr();

	/**
	 * Sets the value of the '{@link VSL.ConditionalExpression#getConditionExpr <em>Condition Expr</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Condition Expr</em>' containment reference.
	 * @see #getConditionExpr()
	 * @generated
	 */
	void setConditionExpr(ValueSpecification value);

	/**
	 * Returns the value of the '<em><b>If True Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>If True Expr</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>If True Expr</em>' containment reference.
	 * @see #setIfTrueExpr(ValueSpecification)
	 * @see VSL.VSLPackage#getConditionalExpression_IfTrueExpr()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ValueSpecification getIfTrueExpr();

	/**
	 * Sets the value of the '{@link VSL.ConditionalExpression#getIfTrueExpr <em>If True Expr</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>If True Expr</em>' containment reference.
	 * @see #getIfTrueExpr()
	 * @generated
	 */
	void setIfTrueExpr(ValueSpecification value);

	/**
	 * Returns the value of the '<em><b>If False Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>If False Expr</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>If False Expr</em>' containment reference.
	 * @see #setIfFalseExpr(ValueSpecification)
	 * @see VSL.VSLPackage#getConditionalExpression_IfFalseExpr()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ValueSpecification getIfFalseExpr();

	/**
	 * Sets the value of the '{@link VSL.ConditionalExpression#getIfFalseExpr <em>If False Expr</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>If False Expr</em>' containment reference.
	 * @see #getIfFalseExpr()
	 * @generated
	 */
	void setIfFalseExpr(ValueSpecification value);

} // ConditionalExpression