/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: OperationCallExpression.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL;

import org.eclipse.emf.common.util.EList;

import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.Operation;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Operation Call Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link VSL.OperationCallExpression#getOperation <em>Operation</em>}</li>
 *   <li>{@link VSL.OperationCallExpression#getDefiningOperation <em>Defining Operation</em>}</li>
 *   <li>{@link VSL.OperationCallExpression#getArgument <em>Argument</em>}</li>
 * </ul>
 * </p>
 *
 * @see VSL.VSLPackage#getOperationCallExpression()
 * @model
 * @generated
 */
public interface OperationCallExpression extends Expression {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operation</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operation</em>' attribute.
	 * @see #setOperation(String)
	 * @see VSL.VSLPackage#getOperationCallExpression_Operation()
	 * @model dataType="org.eclipse.uml2.uml.String" derived="true"
	 * @generated
	 */
	String getOperation();

	/**
	 * Sets the value of the '{@link VSL.OperationCallExpression#getOperation <em>Operation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operation</em>' attribute.
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(String value);

	/**
	 * Returns the value of the '<em><b>Defining Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Defining Operation</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Defining Operation</em>' reference.
	 * @see #setDefiningOperation(Operation)
	 * @see VSL.VSLPackage#getOperationCallExpression_DefiningOperation()
	 * @model
	 * @generated
	 */
	Operation getDefiningOperation();

	/**
	 * Sets the value of the '{@link VSL.OperationCallExpression#getDefiningOperation <em>Defining Operation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Defining Operation</em>' reference.
	 * @see #getDefiningOperation()
	 * @generated
	 */
	void setDefiningOperation(Operation value);

	/**
	 * Returns the value of the '<em><b>Argument</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.uml2.uml.ValueSpecification}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Argument</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Argument</em>' containment reference list.
	 * @see VSL.VSLPackage#getOperationCallExpression_Argument()
	 * @model type="org.eclipse.uml2.uml.ValueSpecification" containment="true"
	 * @generated
	 */
	EList getArgument();

} // OperationCallExpression