/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: PropertyCallExpression.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL;

import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.Property;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Property Call Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link VSL.PropertyCallExpression#getDefiningProperty <em>Defining Property</em>}</li>
 *   <li>{@link VSL.PropertyCallExpression#getProperty <em>Property</em>}</li>
 * </ul>
 * </p>
 *
 * @see VSL.VSLPackage#getPropertyCallExpression()
 * @model
 * @generated
 */
public interface PropertyCallExpression extends Expression {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Defining Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Defining Property</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Defining Property</em>' reference.
	 * @see #setDefiningProperty(Property)
	 * @see VSL.VSLPackage#getPropertyCallExpression_DefiningProperty()
	 * @model required="true"
	 * @generated
	 */
	Property getDefiningProperty();

	/**
	 * Sets the value of the '{@link VSL.PropertyCallExpression#getDefiningProperty <em>Defining Property</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Defining Property</em>' reference.
	 * @see #getDefiningProperty()
	 * @generated
	 */
	void setDefiningProperty(Property value);

	/**
	 * Returns the value of the '<em><b>Property</b></em>' attribute.
	 * The default value is <code>""</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Property</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Property</em>' attribute.
	 * @see #setProperty(String)
	 * @see VSL.VSLPackage#getPropertyCallExpression_Property()
	 * @model default="" dataType="org.eclipse.uml2.uml.String" volatile="true" derived="true"
	 * @generated
	 */
	String getProperty();

	/**
	 * Sets the value of the '{@link VSL.PropertyCallExpression#getProperty <em>Property</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Property</em>' attribute.
	 * @see #getProperty()
	 * @generated
	 */
	void setProperty(String value);

} // PropertyCallExpression