/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: BoundedSubtypeImpl.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL.impl;

import VSL.BoundedSubtype;
import VSL.VSLPackage;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Bounded Subtype</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link VSL.impl.BoundedSubtypeImpl#getMinValue <em>Min Value</em>}</li>
 *   <li>{@link VSL.impl.BoundedSubtypeImpl#getMaxValue <em>Max Value</em>}</li>
 *   <li>{@link VSL.impl.BoundedSubtypeImpl#isIsMinOpen <em>Is Min Open</em>}</li>
 *   <li>{@link VSL.impl.BoundedSubtypeImpl#isIsMaxOpen <em>Is Max Open</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BoundedSubtypeImpl extends SubtypeImpl implements BoundedSubtype {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * The default value of the '{@link #getMinValue() <em>Min Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMinValue()
	 * @generated
	 * @ordered
	 */
	protected static final String MIN_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMinValue() <em>Min Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMinValue()
	 * @generated
	 * @ordered
	 */
	protected String minValue = MIN_VALUE_EDEFAULT;

	/**
	 * The default value of the '{@link #getMaxValue() <em>Max Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxValue()
	 * @generated
	 * @ordered
	 */
	protected static final String MAX_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMaxValue() <em>Max Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxValue()
	 * @generated
	 * @ordered
	 */
	protected String maxValue = MAX_VALUE_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsMinOpen() <em>Is Min Open</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsMinOpen()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_MIN_OPEN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsMinOpen() <em>Is Min Open</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsMinOpen()
	 * @generated
	 * @ordered
	 */
	protected boolean isMinOpen = IS_MIN_OPEN_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsMaxOpen() <em>Is Max Open</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsMaxOpen()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_MAX_OPEN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsMaxOpen() <em>Is Max Open</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsMaxOpen()
	 * @generated
	 * @ordered
	 */
	protected boolean isMaxOpen = IS_MAX_OPEN_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BoundedSubtypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return VSLPackage.Literals.BOUNDED_SUBTYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getMinValue() {
		return minValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMinValue(String newMinValue) {
		String oldMinValue = minValue;
		minValue = newMinValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.BOUNDED_SUBTYPE__MIN_VALUE, oldMinValue, minValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getMaxValue() {
		return maxValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaxValue(String newMaxValue) {
		String oldMaxValue = maxValue;
		maxValue = newMaxValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.BOUNDED_SUBTYPE__MAX_VALUE, oldMaxValue, maxValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsMinOpen() {
		return isMinOpen;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsMinOpen(boolean newIsMinOpen) {
		boolean oldIsMinOpen = isMinOpen;
		isMinOpen = newIsMinOpen;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.BOUNDED_SUBTYPE__IS_MIN_OPEN, oldIsMinOpen, isMinOpen));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsMaxOpen() {
		return isMaxOpen;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsMaxOpen(boolean newIsMaxOpen) {
		boolean oldIsMaxOpen = isMaxOpen;
		isMaxOpen = newIsMaxOpen;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.BOUNDED_SUBTYPE__IS_MAX_OPEN, oldIsMaxOpen, isMaxOpen));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VSLPackage.BOUNDED_SUBTYPE__MIN_VALUE:
				return getMinValue();
			case VSLPackage.BOUNDED_SUBTYPE__MAX_VALUE:
				return getMaxValue();
			case VSLPackage.BOUNDED_SUBTYPE__IS_MIN_OPEN:
				return isIsMinOpen() ? Boolean.TRUE : Boolean.FALSE;
			case VSLPackage.BOUNDED_SUBTYPE__IS_MAX_OPEN:
				return isIsMaxOpen() ? Boolean.TRUE : Boolean.FALSE;
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VSLPackage.BOUNDED_SUBTYPE__MIN_VALUE:
				setMinValue((String)newValue);
				return;
			case VSLPackage.BOUNDED_SUBTYPE__MAX_VALUE:
				setMaxValue((String)newValue);
				return;
			case VSLPackage.BOUNDED_SUBTYPE__IS_MIN_OPEN:
				setIsMinOpen(((Boolean)newValue).booleanValue());
				return;
			case VSLPackage.BOUNDED_SUBTYPE__IS_MAX_OPEN:
				setIsMaxOpen(((Boolean)newValue).booleanValue());
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case VSLPackage.BOUNDED_SUBTYPE__MIN_VALUE:
				setMinValue(MIN_VALUE_EDEFAULT);
				return;
			case VSLPackage.BOUNDED_SUBTYPE__MAX_VALUE:
				setMaxValue(MAX_VALUE_EDEFAULT);
				return;
			case VSLPackage.BOUNDED_SUBTYPE__IS_MIN_OPEN:
				setIsMinOpen(IS_MIN_OPEN_EDEFAULT);
				return;
			case VSLPackage.BOUNDED_SUBTYPE__IS_MAX_OPEN:
				setIsMaxOpen(IS_MAX_OPEN_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VSLPackage.BOUNDED_SUBTYPE__MIN_VALUE:
				return MIN_VALUE_EDEFAULT == null ? minValue != null : !MIN_VALUE_EDEFAULT.equals(minValue);
			case VSLPackage.BOUNDED_SUBTYPE__MAX_VALUE:
				return MAX_VALUE_EDEFAULT == null ? maxValue != null : !MAX_VALUE_EDEFAULT.equals(maxValue);
			case VSLPackage.BOUNDED_SUBTYPE__IS_MIN_OPEN:
				return isMinOpen != IS_MIN_OPEN_EDEFAULT;
			case VSLPackage.BOUNDED_SUBTYPE__IS_MAX_OPEN:
				return isMaxOpen != IS_MAX_OPEN_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (minValue: ");
		result.append(minValue);
		result.append(", maxValue: ");
		result.append(maxValue);
		result.append(", isMinOpen: ");
		result.append(isMinOpen);
		result.append(", isMaxOpen: ");
		result.append(isMaxOpen);
		result.append(')');
		return result.toString();
	}

} //BoundedSubtypeImpl