/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: ChoiceTypeImpl.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL.impl;

import VSL.ChoiceType;
import VSL.VSLPackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.uml2.uml.Property;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Choice Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link VSL.impl.ChoiceTypeImpl#getDefaultAttribute <em>Default Attribute</em>}</li>
 *   <li>{@link VSL.impl.ChoiceTypeImpl#getChoiceAttributes <em>Choice Attributes</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ChoiceTypeImpl extends CompositeTypeImpl implements ChoiceType {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * The cached value of the '{@link #getDefaultAttribute() <em>Default Attribute</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefaultAttribute()
	 * @generated
	 * @ordered
	 */
	protected Property defaultAttribute = null;

	/**
	 * The cached value of the '{@link #getChoiceAttributes() <em>Choice Attributes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChoiceAttributes()
	 * @generated
	 * @ordered
	 */
	protected EList choiceAttributes = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChoiceTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return VSLPackage.Literals.CHOICE_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Property getDefaultAttribute() {
		return defaultAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDefaultAttribute(Property newDefaultAttribute, NotificationChain msgs) {
		Property oldDefaultAttribute = defaultAttribute;
		defaultAttribute = newDefaultAttribute;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VSLPackage.CHOICE_TYPE__DEFAULT_ATTRIBUTE, oldDefaultAttribute, newDefaultAttribute);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefaultAttribute(Property newDefaultAttribute) {
		if (newDefaultAttribute != defaultAttribute) {
			NotificationChain msgs = null;
			if (defaultAttribute != null)
				msgs = ((InternalEObject)defaultAttribute).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VSLPackage.CHOICE_TYPE__DEFAULT_ATTRIBUTE, null, msgs);
			if (newDefaultAttribute != null)
				msgs = ((InternalEObject)newDefaultAttribute).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VSLPackage.CHOICE_TYPE__DEFAULT_ATTRIBUTE, null, msgs);
			msgs = basicSetDefaultAttribute(newDefaultAttribute, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.CHOICE_TYPE__DEFAULT_ATTRIBUTE, newDefaultAttribute, newDefaultAttribute));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getChoiceAttributes() {
		if (choiceAttributes == null) {
			choiceAttributes = new EObjectContainmentEList(Property.class, this, VSLPackage.CHOICE_TYPE__CHOICE_ATTRIBUTES);
		}
		return choiceAttributes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VSLPackage.CHOICE_TYPE__DEFAULT_ATTRIBUTE:
				return basicSetDefaultAttribute(null, msgs);
			case VSLPackage.CHOICE_TYPE__CHOICE_ATTRIBUTES:
				return ((InternalEList)getChoiceAttributes()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VSLPackage.CHOICE_TYPE__DEFAULT_ATTRIBUTE:
				return getDefaultAttribute();
			case VSLPackage.CHOICE_TYPE__CHOICE_ATTRIBUTES:
				return getChoiceAttributes();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VSLPackage.CHOICE_TYPE__DEFAULT_ATTRIBUTE:
				setDefaultAttribute((Property)newValue);
				return;
			case VSLPackage.CHOICE_TYPE__CHOICE_ATTRIBUTES:
				getChoiceAttributes().clear();
				getChoiceAttributes().addAll((Collection)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case VSLPackage.CHOICE_TYPE__DEFAULT_ATTRIBUTE:
				setDefaultAttribute((Property)null);
				return;
			case VSLPackage.CHOICE_TYPE__CHOICE_ATTRIBUTES:
				getChoiceAttributes().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VSLPackage.CHOICE_TYPE__DEFAULT_ATTRIBUTE:
				return defaultAttribute != null;
			case VSLPackage.CHOICE_TYPE__CHOICE_ATTRIBUTES:
				return choiceAttributes != null && !choiceAttributes.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //ChoiceTypeImpl