/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: IntervalSpecificationImpl.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL.impl;

import VSL.IntervalSpecification;
import VSL.VSLPackage;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.uml2.uml.ValueSpecification;

import org.eclipse.uml2.uml.internal.impl.ValueSpecificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Interval Specification</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link VSL.impl.IntervalSpecificationImpl#isIsLowerOpen <em>Is Lower Open</em>}</li>
 *   <li>{@link VSL.impl.IntervalSpecificationImpl#isIsUpperOpen <em>Is Upper Open</em>}</li>
 *   <li>{@link VSL.impl.IntervalSpecificationImpl#getMin <em>Min</em>}</li>
 *   <li>{@link VSL.impl.IntervalSpecificationImpl#getMax <em>Max</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IntervalSpecificationImpl extends ValueSpecificationImpl implements IntervalSpecification {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * The default value of the '{@link #isIsLowerOpen() <em>Is Lower Open</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsLowerOpen()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_LOWER_OPEN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsLowerOpen() <em>Is Lower Open</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsLowerOpen()
	 * @generated
	 * @ordered
	 */
	protected boolean isLowerOpen = IS_LOWER_OPEN_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsUpperOpen() <em>Is Upper Open</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsUpperOpen()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_UPPER_OPEN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsUpperOpen() <em>Is Upper Open</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsUpperOpen()
	 * @generated
	 * @ordered
	 */
	protected boolean isUpperOpen = IS_UPPER_OPEN_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMin() <em>Min</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMin()
	 * @generated
	 * @ordered
	 */
	protected ValueSpecification min = null;

	/**
	 * The cached value of the '{@link #getMax() <em>Max</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMax()
	 * @generated
	 * @ordered
	 */
	protected ValueSpecification max = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntervalSpecificationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return VSLPackage.Literals.INTERVAL_SPECIFICATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsLowerOpen() {
		return isLowerOpen;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsLowerOpen(boolean newIsLowerOpen) {
		boolean oldIsLowerOpen = isLowerOpen;
		isLowerOpen = newIsLowerOpen;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.INTERVAL_SPECIFICATION__IS_LOWER_OPEN, oldIsLowerOpen, isLowerOpen));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsUpperOpen() {
		return isUpperOpen;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsUpperOpen(boolean newIsUpperOpen) {
		boolean oldIsUpperOpen = isUpperOpen;
		isUpperOpen = newIsUpperOpen;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.INTERVAL_SPECIFICATION__IS_UPPER_OPEN, oldIsUpperOpen, isUpperOpen));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification getMin() {
		return min;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMin(ValueSpecification newMin, NotificationChain msgs) {
		ValueSpecification oldMin = min;
		min = newMin;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VSLPackage.INTERVAL_SPECIFICATION__MIN, oldMin, newMin);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMin(ValueSpecification newMin) {
		if (newMin != min) {
			NotificationChain msgs = null;
			if (min != null)
				msgs = ((InternalEObject)min).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VSLPackage.INTERVAL_SPECIFICATION__MIN, null, msgs);
			if (newMin != null)
				msgs = ((InternalEObject)newMin).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VSLPackage.INTERVAL_SPECIFICATION__MIN, null, msgs);
			msgs = basicSetMin(newMin, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.INTERVAL_SPECIFICATION__MIN, newMin, newMin));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification getMax() {
		return max;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMax(ValueSpecification newMax, NotificationChain msgs) {
		ValueSpecification oldMax = max;
		max = newMax;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VSLPackage.INTERVAL_SPECIFICATION__MAX, oldMax, newMax);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMax(ValueSpecification newMax) {
		if (newMax != max) {
			NotificationChain msgs = null;
			if (max != null)
				msgs = ((InternalEObject)max).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VSLPackage.INTERVAL_SPECIFICATION__MAX, null, msgs);
			if (newMax != null)
				msgs = ((InternalEObject)newMax).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VSLPackage.INTERVAL_SPECIFICATION__MAX, null, msgs);
			msgs = basicSetMax(newMax, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.INTERVAL_SPECIFICATION__MAX, newMax, newMax));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VSLPackage.INTERVAL_SPECIFICATION__MIN:
				return basicSetMin(null, msgs);
			case VSLPackage.INTERVAL_SPECIFICATION__MAX:
				return basicSetMax(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VSLPackage.INTERVAL_SPECIFICATION__IS_LOWER_OPEN:
				return isIsLowerOpen() ? Boolean.TRUE : Boolean.FALSE;
			case VSLPackage.INTERVAL_SPECIFICATION__IS_UPPER_OPEN:
				return isIsUpperOpen() ? Boolean.TRUE : Boolean.FALSE;
			case VSLPackage.INTERVAL_SPECIFICATION__MIN:
				return getMin();
			case VSLPackage.INTERVAL_SPECIFICATION__MAX:
				return getMax();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VSLPackage.INTERVAL_SPECIFICATION__IS_LOWER_OPEN:
				setIsLowerOpen(((Boolean)newValue).booleanValue());
				return;
			case VSLPackage.INTERVAL_SPECIFICATION__IS_UPPER_OPEN:
				setIsUpperOpen(((Boolean)newValue).booleanValue());
				return;
			case VSLPackage.INTERVAL_SPECIFICATION__MIN:
				setMin((ValueSpecification)newValue);
				return;
			case VSLPackage.INTERVAL_SPECIFICATION__MAX:
				setMax((ValueSpecification)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case VSLPackage.INTERVAL_SPECIFICATION__IS_LOWER_OPEN:
				setIsLowerOpen(IS_LOWER_OPEN_EDEFAULT);
				return;
			case VSLPackage.INTERVAL_SPECIFICATION__IS_UPPER_OPEN:
				setIsUpperOpen(IS_UPPER_OPEN_EDEFAULT);
				return;
			case VSLPackage.INTERVAL_SPECIFICATION__MIN:
				setMin((ValueSpecification)null);
				return;
			case VSLPackage.INTERVAL_SPECIFICATION__MAX:
				setMax((ValueSpecification)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VSLPackage.INTERVAL_SPECIFICATION__IS_LOWER_OPEN:
				return isLowerOpen != IS_LOWER_OPEN_EDEFAULT;
			case VSLPackage.INTERVAL_SPECIFICATION__IS_UPPER_OPEN:
				return isUpperOpen != IS_UPPER_OPEN_EDEFAULT;
			case VSLPackage.INTERVAL_SPECIFICATION__MIN:
				return min != null;
			case VSLPackage.INTERVAL_SPECIFICATION__MAX:
				return max != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (isLowerOpen: ");
		result.append(isLowerOpen);
		result.append(", isUpperOpen: ");
		result.append(isUpperOpen);
		result.append(')');
		return result.toString();
	}

} //IntervalSpecificationImpl