/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: TupleItemValueImpl.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL.impl;

import VSL.TupleItemValue;
import VSL.VSLPackage;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Tuple Item Value</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link VSL.impl.TupleItemValueImpl#getItemValue <em>Item Value</em>}</li>
 *   <li>{@link VSL.impl.TupleItemValueImpl#getTupleItemName <em>Tuple Item Name</em>}</li>
 *   <li>{@link VSL.impl.TupleItemValueImpl#getTupleAttribute <em>Tuple Attribute</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TupleItemValueImpl extends EObjectImpl implements TupleItemValue {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * The cached value of the '{@link #getItemValue() <em>Item Value</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getItemValue()
	 * @generated
	 * @ordered
	 */
	protected ValueSpecification itemValue = null;

	/**
	 * The default value of the '{@link #getTupleItemName() <em>Tuple Item Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTupleItemName()
	 * @generated
	 * @ordered
	 */
	protected static final String TUPLE_ITEM_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTupleItemName() <em>Tuple Item Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTupleItemName()
	 * @generated
	 * @ordered
	 */
	protected String tupleItemName = TUPLE_ITEM_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTupleAttribute() <em>Tuple Attribute</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTupleAttribute()
	 * @generated
	 * @ordered
	 */
	protected Property tupleAttribute = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TupleItemValueImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return VSLPackage.Literals.TUPLE_ITEM_VALUE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification getItemValue() {
		return itemValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetItemValue(ValueSpecification newItemValue, NotificationChain msgs) {
		ValueSpecification oldItemValue = itemValue;
		itemValue = newItemValue;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VSLPackage.TUPLE_ITEM_VALUE__ITEM_VALUE, oldItemValue, newItemValue);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setItemValue(ValueSpecification newItemValue) {
		if (newItemValue != itemValue) {
			NotificationChain msgs = null;
			if (itemValue != null)
				msgs = ((InternalEObject)itemValue).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VSLPackage.TUPLE_ITEM_VALUE__ITEM_VALUE, null, msgs);
			if (newItemValue != null)
				msgs = ((InternalEObject)newItemValue).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VSLPackage.TUPLE_ITEM_VALUE__ITEM_VALUE, null, msgs);
			msgs = basicSetItemValue(newItemValue, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.TUPLE_ITEM_VALUE__ITEM_VALUE, newItemValue, newItemValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTupleItemName() {
		return tupleItemName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTupleItemName(String newTupleItemName) {
		String oldTupleItemName = tupleItemName;
		tupleItemName = newTupleItemName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.TUPLE_ITEM_VALUE__TUPLE_ITEM_NAME, oldTupleItemName, tupleItemName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Property getTupleAttribute() {
		if (tupleAttribute != null && tupleAttribute.eIsProxy()) {
			InternalEObject oldTupleAttribute = (InternalEObject)tupleAttribute;
			tupleAttribute = (Property)eResolveProxy(oldTupleAttribute);
			if (tupleAttribute != oldTupleAttribute) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, VSLPackage.TUPLE_ITEM_VALUE__TUPLE_ATTRIBUTE, oldTupleAttribute, tupleAttribute));
			}
		}
		return tupleAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Property basicGetTupleAttribute() {
		return tupleAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTupleAttribute(Property newTupleAttribute) {
		Property oldTupleAttribute = tupleAttribute;
		tupleAttribute = newTupleAttribute;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.TUPLE_ITEM_VALUE__TUPLE_ATTRIBUTE, oldTupleAttribute, tupleAttribute));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VSLPackage.TUPLE_ITEM_VALUE__ITEM_VALUE:
				return basicSetItemValue(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VSLPackage.TUPLE_ITEM_VALUE__ITEM_VALUE:
				return getItemValue();
			case VSLPackage.TUPLE_ITEM_VALUE__TUPLE_ITEM_NAME:
				return getTupleItemName();
			case VSLPackage.TUPLE_ITEM_VALUE__TUPLE_ATTRIBUTE:
				if (resolve) return getTupleAttribute();
				return basicGetTupleAttribute();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VSLPackage.TUPLE_ITEM_VALUE__ITEM_VALUE:
				setItemValue((ValueSpecification)newValue);
				return;
			case VSLPackage.TUPLE_ITEM_VALUE__TUPLE_ITEM_NAME:
				setTupleItemName((String)newValue);
				return;
			case VSLPackage.TUPLE_ITEM_VALUE__TUPLE_ATTRIBUTE:
				setTupleAttribute((Property)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case VSLPackage.TUPLE_ITEM_VALUE__ITEM_VALUE:
				setItemValue((ValueSpecification)null);
				return;
			case VSLPackage.TUPLE_ITEM_VALUE__TUPLE_ITEM_NAME:
				setTupleItemName(TUPLE_ITEM_NAME_EDEFAULT);
				return;
			case VSLPackage.TUPLE_ITEM_VALUE__TUPLE_ATTRIBUTE:
				setTupleAttribute((Property)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VSLPackage.TUPLE_ITEM_VALUE__ITEM_VALUE:
				return itemValue != null;
			case VSLPackage.TUPLE_ITEM_VALUE__TUPLE_ITEM_NAME:
				return TUPLE_ITEM_NAME_EDEFAULT == null ? tupleItemName != null : !TUPLE_ITEM_NAME_EDEFAULT.equals(tupleItemName);
			case VSLPackage.TUPLE_ITEM_VALUE__TUPLE_ATTRIBUTE:
				return tupleAttribute != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (tupleItemName: ");
		result.append(tupleItemName);
		result.append(')');
		return result.toString();
	}

} //TupleItemValueImpl