/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: CreationHelper.java,v 1.3 2007/10/15 09:30:32 fnizou Exp $
 */


package com.thalesgroup.marte.vsl;

import java.util.ArrayList;

import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralSpecification;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

import VSL.ChoiceSpecification;
import VSL.CollectionSpecification;
import VSL.ConditionalExpression;
import VSL.DurationExpression;
import VSL.EnumerationSpecification;
import VSL.ExpressionContext;
import VSL.InstantExpression;
import VSL.IntervalSpecification;
import VSL.JitterExpression;
import VSL.LiteralDateTime;
import VSL.LiteralDefault;
import VSL.LiteralReal;
import VSL.ObsCallExpression;
import VSL.OperationCallExpression;
import VSL.TupleItemValue;
import VSL.TupleSpecification;
import VSL.VSLFactory;
import VSL.Variable;
import VSL.VariableCallExpression;
import VSL.VariableDirectionKind;

/**
 * This class is a helper for the parsers to build the AST.
 * It is NOT intended to be used elsewhere.
 * @author T0081227 Francois NIZOU - 27 juil. 07 
 */

public class CreationHelper {

	
	public static ChoiceSpecification createChoiceSpecification(String name,
			ValueSpecification vs) {
		ChoiceSpecification choice = VSLFactory.eINSTANCE
				.createChoiceSpecification();
		choice.setChosenAlternative(name);
		choice.setValue(vs);
		return choice;
	}

	public static ChoiceSpecification createChoiceSpecification(String name,
			ArrayList<TupleItemValue> lst) {
		ChoiceSpecification choice = VSLFactory.eINSTANCE
				.createChoiceSpecification();
		choice.setChosenAlternative(name);
		ValueSpecification vs = createTuple(lst);
		choice.setValue(vs);
		return choice;
	}

	public static IntervalSpecification createIntervalSpecification(
			boolean lowerOpen, boolean upperOpen, ValueSpecification min,
			ValueSpecification max) {
		IntervalSpecification is = VSLFactory.eINSTANCE
				.createIntervalSpecification();
		is.setIsLowerOpen(lowerOpen);
		is.setIsUpperOpen(upperOpen);
		is.setMax(max);
		is.setMin(min);
		return is;
	}

	public static CollectionSpecification createCollection(
			ArrayList<ValueSpecification> lst) {
		CollectionSpecification cs = VSLFactory.eINSTANCE
				.createCollectionSpecification();
		cs.getItemValue().addAll(lst);
		return cs;

	}

	public static TupleSpecification createTuple(ArrayList<TupleItemValue> lst) {
		TupleSpecification ts = VSLFactory.eINSTANCE.createTupleSpecification();
		ts.getTupleItem().addAll(lst);
		return ts;
	}

	public static void changeLiteralNumberSigne(LiteralSpecification ls) {
		if (ls instanceof LiteralInteger) {
			LiteralInteger li = (LiteralInteger) ls;
			li.setValue(-li.integerValue());
		} else if (ls instanceof LiteralReal) {
			LiteralReal lr = (LiteralReal) ls;
			lr.setValue(-lr.getValue());
		}
	}

	public static LiteralString createLiteralString(String text) {
		LiteralString ls = UMLFactory.eINSTANCE.createLiteralString();
		ls.setValue(text);
		return ls;
	}

	public static LiteralBoolean createLiteralBoolean(boolean b) {
		LiteralBoolean lb = UMLFactory.eINSTANCE.createLiteralBoolean();
		lb.setValue(b);
		return lb;
	}

	public static LiteralDateTime createLiteralDateTime(VSLDate c1) {
		LiteralDateTime ldt = VSLFactory.eINSTANCE.createLiteralDateTime();
		ldt.setValue(c1);
		return ldt;
	}

	public static LiteralNull createLiteralNull() {
		return UMLFactory.eINSTANCE.createLiteralNull();
	}

	public static LiteralDefault createLiteralDefault() {
		return VSLFactory.eINSTANCE.createLiteralDefault();
	}

	public static EnumerationSpecification createEnumerationSpecification(
			String text) {
		EnumerationSpecification es = VSLFactory.eINSTANCE
				.createEnumerationSpecification();
		EnumerationLiteral value = UMLFactory.eINSTANCE
				.createEnumerationLiteral();
		value.setName(text);
		es.setEnumLiteral(value);
		return es;
	}

	public static LiteralInteger createLiteralInteger(int i) {
		LiteralInteger li = UMLFactory.eINSTANCE.createLiteralInteger();
		li.setValue(i);
		return li;
	}

	public static LiteralReal createLiteralReal(double d) {
		LiteralReal lr = VSLFactory.eINSTANCE.createLiteralReal();
		lr.setValue(d);
		return lr;
	}

	public static LiteralUnlimitedNatural createLiteralUnlimitedNatural(int i) {
		LiteralUnlimitedNatural lun = UMLFactory.eINSTANCE
				.createLiteralUnlimitedNatural();
		lun.setValue(i);
		return lun;
	}

	public static ObsCallExpression createObsCallExpression(String name,
			ValueSpecification occurIndex, ValueSpecification whenExpr) {
		ObsCallExpression oce = VSLFactory.eINSTANCE.createObsCallExpression();
		if (whenExpr != null)
			oce.setConditionExpr(whenExpr);
		if (occurIndex != null)
			oce.setOccurIndexExpr(occurIndex);

		StringExpression obsName = UMLFactory.eINSTANCE
				.createStringExpression();
		obsName.setName(name);

		oce.setNameExpression(obsName);

		return oce;
	}

	public static TupleItemValue creaTupleItemValue(String name,
			ValueSpecification vs) {
		TupleItemValue tiv = VSLFactory.eINSTANCE.createTupleItemValue();
		tiv.setTupleItemName(name);
		tiv.setItemValue(vs);
		return tiv;
	}

	public static VariableCallExpression createVariableCallExpression(
			String name, String ns) {
		VariableCallExpression vce = VSLFactory.eINSTANCE
				.createVariableCallExpression();
		if (ns.trim().length() > 0)
			vce.setName(ns + "." + name);
		else
			vce.setName(name);
		return vce;
	}

	public static OperationCallExpression createOperationCallExpression(
			String operationOwnerName, String opName,
			ArrayList<ValueSpecification> args) {
		OperationCallExpression oce = VSLFactory.eINSTANCE
				.createOperationCallExpression();
		oce.setOperation(operationOwnerName + "." + opName);

		if (args != null && args.size() > 0) {
			oce.getArgument().addAll(args);
		}
		return oce;
	}

	public static OperationCallExpression createOperationCallExpression(
			ValueSpecification vs, String opName,
			ArrayList<ValueSpecification> args) {
		OperationCallExpression oce = VSLFactory.eINSTANCE
				.createOperationCallExpression();
		oce.setOperation(opName);

		oce.getArgument().add(vs);
		if (args != null && args.size() > 0) {
			oce.getArgument().addAll(args);
		}
		return oce;
	}

	public static DurationExpression createDurationExpression(
			ObsCallExpression left, ObsCallExpression right) {
		DurationExpression de = VSLFactory.eINSTANCE.createDurationExpression();
		de.getObsExpr().add(left);
		de.getObsExpr().add(right);
		return de;
	}

	public static InstantExpression createInstantExpression(
			ObsCallExpression left, ObsCallExpression right) {
		InstantExpression ie = VSLFactory.eINSTANCE.createInstantExpression();
		ie.getObsExpr().add(left);
		ie.getObsExpr().add(right);
		return ie;
	}

	public static JitterExpression createJitterExpression(
			ObsCallExpression left, ObsCallExpression right) {
		JitterExpression je = VSLFactory.eINSTANCE.createJitterExpression();
		je.getObsExpr().add(left);
		if (right != null)
			je.getObsExpr().add(right);
		return je;
	}

	public static VSL.TimeExpression createTimeExpression(ObsCallExpression obs) {
		VSL.TimeExpression te = VSLFactory.eINSTANCE.createTimeExpression();
		te.getObsExpr().add(obs);
		return te;
	}

	public static Variable createVariable(String name, String ctxName,
			VariableDirectionKind dir, String typName, ValueSpecification vs) {
		Variable v = VSLFactory.eINSTANCE.createVariable();
		v.setDirection(dir);
		v.setName(name);
		// TODO: link to the real COntextExpression
		ExpressionContext ctx = VSLFactory.eINSTANCE.createExpressionContext();
		ctx.setName(ctxName);
		v.setContext(ctx);

		if (vs != null)
			v.setInitExpression(vs);

		v.setDataTypeName(typName);

		return v;
	}

	public static ConditionalExpression createConditionalExpression(
			ValueSpecification vs, ConditionalExpression cond) {
		cond.setConditionExpr(vs);
		return cond;
	}

	public static ConditionalExpression createConditionalExpression(
			ValueSpecification ifTrue, ValueSpecification ifFalse) {
		ConditionalExpression ce = VSLFactory.eINSTANCE
				.createConditionalExpression();
		ce.setIfFalseExpr(ifFalse);
		ce.setIfTrueExpr(ifTrue);
		return ce;
	}

	public static ConditionalExpression createConditionalExpression(
			ValueSpecification vs, ValueSpecification ifTrue,
			ValueSpecification ifFalse) {
		ConditionalExpression ce = VSLFactory.eINSTANCE
				.createConditionalExpression();
		ce.setConditionExpr(vs);
		ce.setIfFalseExpr(ifFalse);
		ce.setIfTrueExpr(ifTrue);
		return ce;
	}

	public static StringExpression createStringExpression(String name) {
		StringExpression se = UMLFactory.eINSTANCE.createStringExpression();
		se.setName(name);
		return se;
	}

	public static Expression createExpression(String opName,
			ArrayList<ValueSpecification> lst) {
		Expression expr = UMLFactory.eINSTANCE.createExpression();
		expr.setSymbol(opName);
		if (lst != null && lst.size() > 0)
			expr.getOperands().addAll(lst);
		return expr;
	}

}
