// $ANTLR 2.7.6 (2005-12-22): "resources/grammars/VSL_Parser.g" -> "VSLParser.java"$

	/*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
   
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   - added, removed and modified many rules to fit with the BNF and 
 *				- Added VSL model construction
 *******************************************************************************/
package com.cea.nfp.parsers.antlr;

import com.cea.nfp.parsers.texteditor.vsldatatypes.IContext;
import VSL.*;
import VSL.util.*;
import VSL.Variable;
import VSL.TimeExpression;
import org.eclipse.uml2.uml.*;
import com.thalesgroup.marte.vsl.CreationHelper;
import com.thalesgroup.marte.vsl.VSLDate;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.collections.AST;
import java.util.Hashtable;
import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

public class VSLParser extends antlr.LLkParser       implements VSLTokenTypes
 {

	private	VSLFactory vsFactory = VSLFactory.eINSTANCE;
	private UMLFactory umlFactory = UMLFactory.eINSTANCE;
	
	private int context = -1;
	
	/**
	 * Validation state (true = validation : does not modify the property
	 */
	private boolean isValidation = false;
	
	
	private static final boolean DEBUG = false;
	/**
	 * @return the isValidation boolean
	 */
	public boolean isValidation() {
		return isValidation;
	}

	/**
	 * @param isValidation the isValidation to set (true -> do not modify the property)
	 */
	public void setValidation(boolean isValidation) {
		this.isValidation = isValidation;
	}
	
	
	public int getContext() {
		return context;
	}
	
	public void setContext(int context) {
		this.context = context;
	}
	
	private void debug(String value) {
		System.out.println(value);
	}
	
	private void error(String value) {
		System.err.println(value);
	}

// whenAfterRBRACK, test if there is a WHEN after an RBRACK
	
	protected boolean whenAfterRBRACK() throws TokenStreamException {
		int i = 1;
		int la = LA(i);
		while (la != RBRACK && la != EOF) {
			la = LA(++i);
		}
		la = LA(++i);
		return (la == WHEN);
	}

// manualy lookahead if we are in a question
	protected boolean isQuestion() throws TokenStreamException {
		boolean isQuestion = false;

		int i = 1;
		int openedParen = 0;
		int la = LA(i);
		while (la != EOF) {
			switch (la) {
			case LPAREN:
				openedParen++;
				break;
			case RPAREN:
				openedParen--;
				break;
			case QUESTION:
				if (openedParen == 0)
					isQuestion = true;
				break;
			default:
				break;
			}
			if (isQuestion)
				break;
			la = LA(++i);
		}

		return isQuestion;

	}
	
	
		protected boolean isTimeExpr() throws TokenStreamException {
		if (LA(1) == JITTER)
			return true;
		int i = 1;
		int la = LA(i);
		boolean haveSeenNegOrPlus = false;
		while (la != EOF && la != RPAREN) {
			if (la == COMMA)
				return false;
			if (la == PLUS || la == MINUS)
				haveSeenNegOrPlus = true;
			la = LA(++i);
		}
		return haveSeenNegOrPlus;
	}
	
	// utility

	protected Integer intFromBinaryString(String s){
		s =  s.replaceFirst("0b", "");
		return Integer.parseInt(s, 2);
	}	

    protected Integer intFromHexaString(String s){
		s =  s.replaceFirst("0x", "");
		return Integer.parseInt(s, 16);
	}	

	public String notParsedEndMessage() throws TokenStreamException {
		if (LA(1) == EOF) {
			return null;
		} else {
			String s = "";

			Token token = LT(1);
			s += token.getText();
			int col = token.getColumn();
			inputState.getInput().consume();
			while (LA(1) != EOF) {
				token = LT(1);
				s += token.getText();
				inputState.getInput().consume();
			}

			return "'" + s + "' at column " + col;
		}
	}


protected VSLParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public VSLParser(TokenBuffer tokenBuf) {
  this(tokenBuf,5);
}

protected VSLParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public VSLParser(TokenStream lexer) {
  this(lexer,5);
}

public VSLParser(ParserSharedInputState state) {
  super(state,5);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

	public final ValueSpecification  valueSpecification() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST valueSpecification_AST = null;
		
			context = IContext.NFP_VALUE_SPECIFICATION;
			ValueSpecification e1 = null;
			ValueSpecification e2 = null;
			String symbol = null;
		
		
		{
		e1=internalValueSpecification();
		astFactory.addASTChild(currentAST, returnAST);
		{
		if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			{
			if ((_tokenSet_3.member(LA(1))) && (_tokenSet_4.member(LA(2))) && (_tokenSet_5.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
				symbol=operationSymbol();
				astFactory.addASTChild(currentAST, returnAST);
				e2=valueSpecification();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
		}
		else if ((LA(1)==EOF) && (_tokenSet_0.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			AST tmp1_AST = null;
			tmp1_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp1_AST);
			match(Token.EOF_TYPE);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		}
		
		if (symbol !=null){
			 java.util.ArrayList<ValueSpecification> lst = new java.util.ArrayList<ValueSpecification>();
			 lst.add(e2);
			 vs = CreationHelper.createOperationCallExpression(e1 ,symbol, lst); 
			} else {
			 vs = e1;
			}
		
		valueSpecification_AST = (AST)currentAST.root;
		returnAST = valueSpecification_AST;
		return vs;
	}
	
	protected final ValueSpecification  internalValueSpecification() throws RecognitionException, TokenStreamException {
		ValueSpecification e;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST internalValueSpecification_AST = null;
		
		
				context = IContext.NFP_VALUE_SPECIFICATION;
				e = null;
				String opname = null;
				java.util.ArrayList<ValueSpecification> lst = null;
				ValueSpecification ifTrue = null;
				ValueSpecification ifFalse = null;
			
		{
		{
		switch ( LA(1)) {
		case LBRACK:
		case RBRACK:
		{
			e=interval();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LCURLY:
		{
			e=collection();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		default:
			if ((LA(1)==IDENT) && (LA(2)==LPAREN) && (_tokenSet_4.member(LA(3))) && (_tokenSet_6.member(LA(4))) && (_tokenSet_7.member(LA(5)))) {
				e=choice();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((LA(1)==IDENT) && (LA(2)==LBRACK) && (_tokenSet_4.member(LA(3))) && (_tokenSet_8.member(LA(4))) && (_tokenSet_7.member(LA(5)))) {
				e=obsExpressionWithOccurIndex();
				astFactory.addASTChild(currentAST, returnAST);
				e =CreationHelper.createTimeExpression((ObsCallExpression)e);
			}
			else if ((_tokenSet_9.member(LA(1))) && (_tokenSet_10.member(LA(2))) && (_tokenSet_11.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
				e=literal();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if (((LA(1)==LPAREN||LA(1)==IDENT||LA(1)==JITTER) && (_tokenSet_12.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5))))&&( !isQuestion() & isTimeExpr())) {
				e=timeExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if (((LA(1)==LPAREN) && (_tokenSet_4.member(LA(2))) && (_tokenSet_6.member(LA(3))) && (_tokenSet_7.member(LA(4))) && (_tokenSet_2.member(LA(5))))&&(!isQuestion())) {
				e=tuple();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_13.member(LA(1))) && (_tokenSet_14.member(LA(2))) && (_tokenSet_15.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
				e=expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((LA(1)==LPAREN||LA(1)==IDENT||LA(1)==JITTER) && (_tokenSet_12.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
				e=timeExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		if ((LA(1)==DOT) && (LA(2)==IDENT) && (LA(3)==LPAREN) && (_tokenSet_16.member(LA(4))) && (_tokenSet_5.member(LA(5)))) {
			AST tmp2_AST = null;
			tmp2_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp2_AST);
			match(DOT);
			opname=operationName();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp3_AST = null;
			tmp3_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp3_AST);
			match(LPAREN);
			{
			switch ( LA(1)) {
			case LBRACK:
			case RBRACK:
			case LCURLY:
			case STAR:
			case DECIMAL_STRING:
			case BINARY_STRING:
			case HEXADECIMAL_STRING:
			case LPAREN:
			case IDENT:
			case SHARP:
			case PLUS:
			case MINUS:
			case TRUE:
			case FALSE:
			case NULL:
			case STRING_TEXT:
			case IN_DIR:
			case OUT_DIR:
			case INOUT_DIR:
			case JITTER:
			{
				lst=argumentValueList();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case RPAREN:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			AST tmp4_AST = null;
			tmp4_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp4_AST);
			match(RPAREN);
		}
		else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		}
		if (opname != null) e = CreationHelper.createOperationCallExpression(e ,opname, lst) ;
		internalValueSpecification_AST = (AST)currentAST.root;
		returnAST = internalValueSpecification_AST;
		return e;
	}
	
	public final String  operationSymbol() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST operationSymbol_AST = null;
		Token  id = null;
		AST id_AST = null;
		Token  id1 = null;
		AST id1_AST = null;
		Token  id2 = null;
		AST id2_AST = null;
		Token  id3 = null;
		AST id3_AST = null;
		Token  id4 = null;
		AST id4_AST = null;
		Token  id5 = null;
		AST id5_AST = null;
		Token  id6 = null;
		AST id6_AST = null;
		Token  id7 = null;
		AST id7_AST = null;
		Token  id8 = null;
		AST id8_AST = null;
		Token  id9 = null;
		AST id9_AST = null;
		Token  id10 = null;
		AST id10_AST = null;
		
		
				context = IContext.OPERATION_SYMBOL;
			
		{
		switch ( LA(1)) {
		case PLUS:
		{
			id = LT(1);
			id_AST = astFactory.create(id);
			astFactory.addASTChild(currentAST, id_AST);
			match(PLUS);
			s = id.getText();
			break;
		}
		case MINUS:
		{
			id1 = LT(1);
			id1_AST = astFactory.create(id1);
			astFactory.addASTChild(currentAST, id1_AST);
			match(MINUS);
			s = id1.getText();
			break;
		}
		case LE:
		{
			id2 = LT(1);
			id2_AST = astFactory.create(id2);
			astFactory.addASTChild(currentAST, id2_AST);
			match(LE);
			s = id2.getText();
			break;
		}
		case LT:
		{
			id3 = LT(1);
			id3_AST = astFactory.create(id3);
			astFactory.addASTChild(currentAST, id3_AST);
			match(LT);
			s = id3.getText();
			break;
		}
		case GE:
		{
			id4 = LT(1);
			id4_AST = astFactory.create(id4);
			astFactory.addASTChild(currentAST, id4_AST);
			match(GE);
			s = id4.getText();
			break;
		}
		case GT:
		{
			id5 = LT(1);
			id5_AST = astFactory.create(id5);
			astFactory.addASTChild(currentAST, id5_AST);
			match(GT);
			s = id5.getText();
			break;
		}
		case EQUAL:
		{
			id6 = LT(1);
			id6_AST = astFactory.create(id6);
			astFactory.addASTChild(currentAST, id6_AST);
			match(EQUAL);
			s = id6.getText();
			break;
		}
		case DIFF:
		{
			id7 = LT(1);
			id7_AST = astFactory.create(id7);
			astFactory.addASTChild(currentAST, id7_AST);
			match(DIFF);
			s = id7.getText();
			break;
		}
		case DIV:
		{
			id8 = LT(1);
			id8_AST = astFactory.create(id8);
			astFactory.addASTChild(currentAST, id8_AST);
			match(DIV);
			s = id8.getText();
			break;
		}
		case STAR:
		{
			id9 = LT(1);
			id9_AST = astFactory.create(id9);
			astFactory.addASTChild(currentAST, id9_AST);
			match(STAR);
			s = id9.getText();
			break;
		}
		case MOD:
		{
			id10 = LT(1);
			id10_AST = astFactory.create(id10);
			astFactory.addASTChild(currentAST, id10_AST);
			match(MOD);
			s = id10.getText();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		operationSymbol_AST = (AST)currentAST.root;
		returnAST = operationSymbol_AST;
		return s;
	}
	
	public final ChoiceSpecification  choice() throws RecognitionException, TokenStreamException {
		ChoiceSpecification cs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST choice_AST = null;
		
		
				context = IContext.CHOICE;
				java.util.ArrayList<TupleItemValue> lst = null;
				String name = "";
				ValueSpecification vs = null;
				
			
		{
		{
		name=chosenAlternativeName();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp5_AST = null;
		tmp5_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp5_AST);
		match(LPAREN);
		{
		if ((_tokenSet_4.member(LA(1))) && (_tokenSet_6.member(LA(2))) && (_tokenSet_7.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			lst=tupleItemList();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_4.member(LA(1))) && (_tokenSet_17.member(LA(2))) && (_tokenSet_7.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			vs=valueSpecification();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		AST tmp6_AST = null;
		tmp6_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp6_AST);
		match(RPAREN);
		}
		
					name = (name == null)? "-": name;
					if (vs != null){
						cs = CreationHelper.createChoiceSpecification(name, vs);
					} else {
						cs = CreationHelper.createChoiceSpecification(name, lst);
					}
			
		}
		choice_AST = (AST)currentAST.root;
		returnAST = choice_AST;
		return cs;
	}
	
	protected final ObsCallExpression  obsExpressionWithOccurIndex() throws RecognitionException, TokenStreamException {
		ObsCallExpression oce;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST obsExpressionWithOccurIndex_AST = null;
		Token  id = null;
		AST id_AST = null;
		
		ValueSpecification occurIndex = null;
		ValueSpecification whenExpr = null;
		context = IContext.TIME_EXPR;
		
		
		{
		id = LT(1);
		id_AST = astFactory.create(id);
		astFactory.addASTChild(currentAST, id_AST);
		match(IDENT);
		AST tmp7_AST = null;
		tmp7_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp7_AST);
		match(LBRACK);
		{
		occurIndex=valueSpecification();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp8_AST = null;
		tmp8_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp8_AST);
		match(RBRACK);
		}
		{
		switch ( LA(1)) {
		case WHEN:
		{
			AST tmp9_AST = null;
			tmp9_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp9_AST);
			match(WHEN);
			whenExpr=valueSpecification();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case EOF:
		case MOD:
		case DOT:
		case DOTDOT:
		case LBRACK:
		case RBRACK:
		case RCURLY:
		case COMMA:
		case COLON:
		case STAR:
		case RPAREN:
		case PLUS:
		case MINUS:
		case LE:
		case LT:
		case GE:
		case GT:
		case EQUAL:
		case DIFF:
		case DIV:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		
		
				oce = CreationHelper.createObsCallExpression(id.getText(), 
														occurIndex, 
														whenExpr);
		
			   		context = IContext.SINGLE_OBS_EXPR;
		
		
			
		
		obsExpressionWithOccurIndex_AST = (AST)currentAST.root;
		returnAST = obsExpressionWithOccurIndex_AST;
		return oce;
	}
	
	public final ValueSpecification  literal() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST literal_AST = null;
		Token  m = null;
		AST m_AST = null;
		
		LiteralSpecification ls = null;
				context = IContext.LITERAL;
			
		{
		switch ( LA(1)) {
		case STRING_TEXT:
		{
			vs=stringLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case TRUE:
		case FALSE:
		{
			vs=booleanLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case SHARP:
		{
			vs=datetimeLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case NULL:
		{
			vs=nullLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case IDENT:
		{
			vs=variableCallExpr();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		default:
			if ((LA(1)==MINUS) && (_tokenSet_18.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
				{
				m = LT(1);
				m_AST = astFactory.create(m);
				astFactory.addASTChild(currentAST, m_AST);
				match(MINUS);
				{
				if ((_tokenSet_19.member(LA(1))) && (_tokenSet_18.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
					ls=numberLiteral();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				}
				
					 	if ( ls != null){
					 		CreationHelper.changeLiteralNumberSigne(ls);
					 		vs = ls;
					 	} else {
					 		vs = CreationHelper.createLiteralDefault();
					 	}
					 	
					
			}
			else if ((_tokenSet_19.member(LA(1))) && (_tokenSet_18.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
				vs=numberLiteral();
				astFactory.addASTChild(currentAST, returnAST);
			}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		literal_AST = (AST)currentAST.root;
		returnAST = literal_AST;
		return vs;
	}
	
	public final IntervalSpecification  interval() throws RecognitionException, TokenStreamException {
		IntervalSpecification is;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST interval_AST = null;
		Token  brack1 = null;
		AST brack1_AST = null;
		Token  brack2 = null;
		AST brack2_AST = null;
		
		
				context = IContext.INTERVAL;
				ValueSpecification min = null, max = null;
				ValueSpecification[] interval = null;
			
		{
		{
		switch ( LA(1)) {
		case LBRACK:
		{
			brack1 = LT(1);
			brack1_AST = astFactory.create(brack1);
			astFactory.addASTChild(currentAST, brack1_AST);
			match(LBRACK);
			break;
		}
		case RBRACK:
		{
			AST tmp10_AST = null;
			tmp10_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp10_AST);
			match(RBRACK);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		{
		min=intervalBound();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp11_AST = null;
		tmp11_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp11_AST);
		match(DOTDOT);
		max=intervalBound();
		astFactory.addASTChild(currentAST, returnAST);
		}
		}
		{
		switch ( LA(1)) {
		case RBRACK:
		{
			brack2 = LT(1);
			brack2_AST = astFactory.create(brack2);
			astFactory.addASTChild(currentAST, brack2_AST);
			match(RBRACK);
			break;
		}
		case LBRACK:
		{
			AST tmp12_AST = null;
			tmp12_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp12_AST);
			match(LBRACK);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		
			 boolean lowerOpen = ( brack1 != null)? false: true;
			 boolean upperOpen = (brack2 != null)? false: true;
			 if (interval == null){
			 	 is = CreationHelper.createIntervalSpecification(lowerOpen, upperOpen, min, max);
			  } else {
			is = CreationHelper.createIntervalSpecification(lowerOpen, upperOpen, interval[0], interval[1]);
			  }	
			
		interval_AST = (AST)currentAST.root;
		returnAST = interval_AST;
		return is;
	}
	
	public final CollectionSpecification  collection() throws RecognitionException, TokenStreamException {
		CollectionSpecification cs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST collection_AST = null;
		
		
				context = IContext.COLLECTION;
				java.util.ArrayList<ValueSpecification> lst = null;
			
		{
		AST tmp13_AST = null;
		tmp13_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp13_AST);
		match(LCURLY);
		{
		switch ( LA(1)) {
		case LBRACK:
		case RBRACK:
		case LCURLY:
		case STAR:
		case DECIMAL_STRING:
		case BINARY_STRING:
		case HEXADECIMAL_STRING:
		case LPAREN:
		case IDENT:
		case SHARP:
		case PLUS:
		case MINUS:
		case TRUE:
		case FALSE:
		case NULL:
		case STRING_TEXT:
		case IN_DIR:
		case OUT_DIR:
		case INOUT_DIR:
		case JITTER:
		{
			lst=valueSpecificationList();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp14_AST = null;
		tmp14_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp14_AST);
		match(RCURLY);
		{
		switch ( LA(1)) {
		case LCURLY:
		{
			AST tmp15_AST = null;
			tmp15_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp15_AST);
			match(LCURLY);
			unlimitedLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp16_AST = null;
			tmp16_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp16_AST);
			match(RCURLY);
			break;
		}
		case EOF:
		case MOD:
		case DOT:
		case DOTDOT:
		case LBRACK:
		case RBRACK:
		case RCURLY:
		case COMMA:
		case COLON:
		case STAR:
		case RPAREN:
		case PLUS:
		case MINUS:
		case LE:
		case LT:
		case GE:
		case GT:
		case EQUAL:
		case DIFF:
		case DIV:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		
				  if (lst== null)
				   lst = new java.util.ArrayList<ValueSpecification>();
				  cs = CreationHelper.createCollection(lst);	
				
		}
		collection_AST = (AST)currentAST.root;
		returnAST = collection_AST;
		return cs;
	}
	
	public final TimeExpression  timeExpression() throws RecognitionException, TokenStreamException {
		TimeExpression te;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST timeExpression_AST = null;
		
			 te = null;
			 context = IContext.TIME_EXPR;
		
		
		switch ( LA(1)) {
		case LPAREN:
		case IDENT:
		{
			te=durationOrInstantExpression();
			astFactory.addASTChild(currentAST, returnAST);
			timeExpression_AST = (AST)currentAST.root;
			break;
		}
		case JITTER:
		{
			te=jitterExpression();
			astFactory.addASTChild(currentAST, returnAST);
			timeExpression_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = timeExpression_AST;
		return te;
	}
	
	public final TupleSpecification  tuple() throws RecognitionException, TokenStreamException {
		TupleSpecification ts;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST tuple_AST = null;
		
		
				context = IContext.TUPLE;
				java.util.ArrayList<TupleItemValue> lst = null;
			
		{
		AST tmp17_AST = null;
		tmp17_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp17_AST);
		match(LPAREN);
		lst=tupleItemList();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp18_AST = null;
		tmp18_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp18_AST);
		match(RPAREN);
		
				 ts = CreationHelper.createTuple(lst);
				
		}
		tuple_AST = (AST)currentAST.root;
		returnAST = tuple_AST;
		return ts;
	}
	
	public final ValueSpecification  expression() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expression_AST = null;
		Token  q = null;
		AST q_AST = null;
		
		
				context = IContext.EXPRESSION;
				ValueSpecification ifTrue =null, ifFalse = null, e = null;
				String name = null;
				java.util.ArrayList<ValueSpecification> lst = null;
				ValueSpecification opCall = null;
				ValueSpecification left = null;
				ValueSpecification right = null;
				String symbol = null;
			
		{
		switch ( LA(1)) {
		case IN_DIR:
		case OUT_DIR:
		case INOUT_DIR:
		{
			{
			vs=variableDeclaration();
			astFactory.addASTChild(currentAST, returnAST);
			{
			if ((LA(1)==DOT) && (LA(2)==IDENT) && (LA(3)==LPAREN) && (_tokenSet_16.member(LA(4))) && (_tokenSet_5.member(LA(5)))) {
				AST tmp19_AST = null;
				tmp19_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp19_AST);
				match(DOT);
				name=operationName();
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp20_AST = null;
				tmp20_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp20_AST);
				match(LPAREN);
				{
				switch ( LA(1)) {
				case LBRACK:
				case RBRACK:
				case LCURLY:
				case STAR:
				case DECIMAL_STRING:
				case BINARY_STRING:
				case HEXADECIMAL_STRING:
				case LPAREN:
				case IDENT:
				case SHARP:
				case PLUS:
				case MINUS:
				case TRUE:
				case FALSE:
				case NULL:
				case STRING_TEXT:
				case IN_DIR:
				case OUT_DIR:
				case INOUT_DIR:
				case JITTER:
				{
					lst=argumentValueList();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				AST tmp21_AST = null;
				tmp21_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp21_AST);
				match(RPAREN);
			}
			else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			}
			if (name != null) vs = CreationHelper.createOperationCallExpression(vs ,name, lst) ;
			break;
		}
		case LPAREN:
		{
			{
			{
			{
			AST tmp22_AST = null;
			tmp22_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp22_AST);
			match(LPAREN);
			e=valueSpecification();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp23_AST = null;
			tmp23_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp23_AST);
			match(RPAREN);
			q = LT(1);
			q_AST = astFactory.create(q);
			astFactory.addASTChild(currentAST, q_AST);
			match(QUESTION);
			{
			switch ( LA(1)) {
			case LBRACK:
			case RBRACK:
			case LCURLY:
			case STAR:
			case DECIMAL_STRING:
			case BINARY_STRING:
			case HEXADECIMAL_STRING:
			case LPAREN:
			case IDENT:
			case SHARP:
			case PLUS:
			case MINUS:
			case TRUE:
			case FALSE:
			case NULL:
			case STRING_TEXT:
			case IN_DIR:
			case OUT_DIR:
			case INOUT_DIR:
			case JITTER:
			{
				ifTrue=ifTrueExpr();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case COLON:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			AST tmp24_AST = null;
			tmp24_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp24_AST);
			match(COLON);
			{
			if ((_tokenSet_4.member(LA(1))) && (_tokenSet_5.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
				ifFalse=ifFalseExpr();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			}
			{
			if ((LA(1)==DOT) && (LA(2)==IDENT) && (LA(3)==LPAREN) && (_tokenSet_16.member(LA(4))) && (_tokenSet_5.member(LA(5)))) {
				AST tmp25_AST = null;
				tmp25_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp25_AST);
				match(DOT);
				name=operationName();
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp26_AST = null;
				tmp26_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp26_AST);
				match(LPAREN);
				{
				switch ( LA(1)) {
				case LBRACK:
				case RBRACK:
				case LCURLY:
				case STAR:
				case DECIMAL_STRING:
				case BINARY_STRING:
				case HEXADECIMAL_STRING:
				case LPAREN:
				case IDENT:
				case SHARP:
				case PLUS:
				case MINUS:
				case TRUE:
				case FALSE:
				case NULL:
				case STRING_TEXT:
				case IN_DIR:
				case OUT_DIR:
				case INOUT_DIR:
				case JITTER:
				{
					lst=argumentValueList();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				AST tmp27_AST = null;
				tmp27_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp27_AST);
				match(RPAREN);
			}
			else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			}
			
						context = IContext.COND_EXPR;
						
						String msg = "";
						if (e == null) msg += "Missing condition";
						if (e == null) msg += "Condition can only be a variable declaration, a variable call expression or a property call";
						if (ifTrue == null) msg = msg + " missing consequence";
						if (ifFalse == null) msg = msg + " missing alternant";
						
						if (msg.length() != 0) 
							throw new RecognitionException(msg);
						
						vs = CreationHelper.createConditionalExpression(e, ifTrue, ifFalse);
					   
					   if (name != null) vs = CreationHelper.createOperationCallExpression(vs ,name, lst) ;
					
			}
			break;
		}
		default:
			if ((_tokenSet_9.member(LA(1))) && (_tokenSet_20.member(LA(2))) && (_tokenSet_21.member(LA(3))) && (_tokenSet_22.member(LA(4))) && (_tokenSet_23.member(LA(5)))) {
				{
				vs=literal();
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp28_AST = null;
				tmp28_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp28_AST);
				match(DOT);
				name=operationName();
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp29_AST = null;
				tmp29_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp29_AST);
				match(LPAREN);
				{
				switch ( LA(1)) {
				case LBRACK:
				case RBRACK:
				case LCURLY:
				case STAR:
				case DECIMAL_STRING:
				case BINARY_STRING:
				case HEXADECIMAL_STRING:
				case LPAREN:
				case IDENT:
				case SHARP:
				case PLUS:
				case MINUS:
				case TRUE:
				case FALSE:
				case NULL:
				case STRING_TEXT:
				case IN_DIR:
				case OUT_DIR:
				case INOUT_DIR:
				case JITTER:
				{
					lst=argumentValueList();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				AST tmp30_AST = null;
				tmp30_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp30_AST);
				match(RPAREN);
				}
				if (name != null) vs = CreationHelper.createOperationCallExpression(vs ,name, lst) ;
			}
			else if ((LA(1)==IDENT) && (_tokenSet_0.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
				{
				vs=variableCallExpr();
				astFactory.addASTChild(currentAST, returnAST);
				{
				if ((LA(1)==DOT) && (LA(2)==IDENT) && (LA(3)==LPAREN) && (_tokenSet_16.member(LA(4))) && (_tokenSet_5.member(LA(5)))) {
					AST tmp31_AST = null;
					tmp31_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp31_AST);
					match(DOT);
					name=operationName();
					astFactory.addASTChild(currentAST, returnAST);
					AST tmp32_AST = null;
					tmp32_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp32_AST);
					match(LPAREN);
					{
					switch ( LA(1)) {
					case LBRACK:
					case RBRACK:
					case LCURLY:
					case STAR:
					case DECIMAL_STRING:
					case BINARY_STRING:
					case HEXADECIMAL_STRING:
					case LPAREN:
					case IDENT:
					case SHARP:
					case PLUS:
					case MINUS:
					case TRUE:
					case FALSE:
					case NULL:
					case STRING_TEXT:
					case IN_DIR:
					case OUT_DIR:
					case INOUT_DIR:
					case JITTER:
					{
						lst=argumentValueList();
						astFactory.addASTChild(currentAST, returnAST);
						break;
					}
					case RPAREN:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					AST tmp33_AST = null;
					tmp33_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp33_AST);
					match(RPAREN);
				}
				else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				}
				if (name != null) vs = CreationHelper.createOperationCallExpression(vs ,name, lst) ;
			}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		expression_AST = (AST)currentAST.root;
		returnAST = expression_AST;
		return vs;
	}
	
	public final String  operationName() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST operationName_AST = null;
		Token  id = null;
		AST id_AST = null;
		
		
				context = IContext.OPERATION_NAME;
			
		{
		id = LT(1);
		id_AST = astFactory.create(id);
		astFactory.addASTChild(currentAST, id_AST);
		match(IDENT);
		s = id.getText();
		}
		operationName_AST = (AST)currentAST.root;
		returnAST = operationName_AST;
		return s;
	}
	
	public final java.util.ArrayList<ValueSpecification>  argumentValueList() throws RecognitionException, TokenStreamException {
		java.util.ArrayList<ValueSpecification> lst;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST argumentValueList_AST = null;
		
		
				lst = new java.util.ArrayList<ValueSpecification>();
				ValueSpecification vs = null;
				java.util.ArrayList<ValueSpecification> rec = null;
			
		{
		vs=argumentValue();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case COMMA:
		{
			AST tmp34_AST = null;
			tmp34_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp34_AST);
			match(COMMA);
			{
			rec=argumentValueList();
			astFactory.addASTChild(currentAST, returnAST);
			}
			break;
		}
		case RPAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		
				 lst.add(vs) ;
				 if ( rec != null)
				  lst.addAll(rec);
			
		argumentValueList_AST = (AST)currentAST.root;
		returnAST = argumentValueList_AST;
		return lst;
	}
	
	public final LiteralSpecification  numberLiteral() throws RecognitionException, TokenStreamException {
		LiteralSpecification ls;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST numberLiteral_AST = null;
		
		
				context = IContext.NUMBER_LITERAL;
			
		{
		if ((LA(1)==DECIMAL_STRING||LA(1)==PLUS||LA(1)==MINUS) && (LA(2)==DOT||LA(2)==DECIMAL_STRING) && (LA(3)==DOT||LA(3)==DECIMAL_STRING) && (_tokenSet_24.member(LA(4))) && (_tokenSet_1.member(LA(5)))) {
			ls=realLiteral();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_25.member(LA(1))) && (_tokenSet_18.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			ls=integerLiteral();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_19.member(LA(1))) && (_tokenSet_18.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			ls=unlimitedLiteral();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		numberLiteral_AST = (AST)currentAST.root;
		returnAST = numberLiteral_AST;
		return ls;
	}
	
	public final LiteralString  stringLiteral() throws RecognitionException, TokenStreamException {
		LiteralString ls;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST stringLiteral_AST = null;
		Token  s = null;
		AST s_AST = null;
		
		
				context = IContext.STRING_LITERAL;
			
		{
		s = LT(1);
		s_AST = astFactory.create(s);
		astFactory.addASTChild(currentAST, s_AST);
		match(STRING_TEXT);
		ls = CreationHelper.createLiteralString(s.getText()) ;
		}
		stringLiteral_AST = (AST)currentAST.root;
		returnAST = stringLiteral_AST;
		return ls;
	}
	
	public final LiteralBoolean  booleanLiteral() throws RecognitionException, TokenStreamException {
		LiteralBoolean lb;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST booleanLiteral_AST = null;
		
		
				context = IContext.BOOLEAN_LITERAL;
			
		{
		switch ( LA(1)) {
		case TRUE:
		{
			AST tmp35_AST = null;
			tmp35_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp35_AST);
			match(TRUE);
			lb =  CreationHelper.createLiteralBoolean(true);
			break;
		}
		case FALSE:
		{
			AST tmp36_AST = null;
			tmp36_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp36_AST);
			match(FALSE);
			lb =  CreationHelper.createLiteralBoolean(false);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		booleanLiteral_AST = (AST)currentAST.root;
		returnAST = booleanLiteral_AST;
		return lb;
	}
	
	public final LiteralDateTime  datetimeLiteral() throws RecognitionException, TokenStreamException {
		LiteralDateTime ld;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST datetimeLiteral_AST = null;
		
		
				VSLDate c2 = null;
				context = IContext.DATETIME_LITERAL;
				VSLDate c1 = null;
				VSLDate c3 = null;
			
		{
		AST tmp37_AST = null;
		tmp37_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp37_AST);
		match(SHARP);
		{
		switch ( LA(1)) {
		case TIME:
		{
			{
			c1=timeStr();
			astFactory.addASTChild(currentAST, returnAST);
			{
			switch ( LA(1)) {
			case DATE:
			{
				c2=dateStr();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case DAY:
			case SHARP:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			switch ( LA(1)) {
			case DAY:
			{
				c3=dayStr();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case SHARP:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			}
			
												if (c2 != null){
					                             c1.year =  c2.year;
												 c1.month =  c2.month;
												 c1.dayOfMonth = c2.dayOfMonth;
												} 
												if (c3 != null) {
												 c1.dayOfWeek = c3.dayOfWeek;	
												}
					
			break;
		}
		case DATE:
		{
			{
			c1=dateStr();
			astFactory.addASTChild(currentAST, returnAST);
			{
			switch ( LA(1)) {
			case DAY:
			{
				c2=dayStr();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case SHARP:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			}
			
					                            if (c2 != null){
					 							 c1.dayOfWeek = c2.dayOfWeek;
					                            }
											
			break;
		}
		case DAY:
		{
			{
			c1=dayStr();
			astFactory.addASTChild(currentAST, returnAST);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp38_AST = null;
		tmp38_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp38_AST);
		match(SHARP);
		}
		
					ld = CreationHelper.createLiteralDateTime(c1) ;
		
			
		datetimeLiteral_AST = (AST)currentAST.root;
		returnAST = datetimeLiteral_AST;
		return ld;
	}
	
	public final LiteralNull  nullLiteral() throws RecognitionException, TokenStreamException {
		LiteralNull ln;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST nullLiteral_AST = null;
		
		
				context = IContext.NULL_LITERAL;
			
		{
		AST tmp39_AST = null;
		tmp39_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp39_AST);
		match(NULL);
		ln = CreationHelper.createLiteralNull();
		}
		nullLiteral_AST = (AST)currentAST.root;
		returnAST = nullLiteral_AST;
		return ln;
	}
	
	public final Expression  variableCallExpr() throws RecognitionException, TokenStreamException {
		Expression vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST variableCallExpr_AST = null;
		
		
				context = IContext.NAME_EXPRESSION;
				// context = IContext.VARIABLE_CALL_EXPR;
				String s = null;
				String name = "";
				java.util.ArrayList<ValueSpecification> lst = null;
			
		{
		s=nameExpression();
		astFactory.addASTChild(currentAST, returnAST);
		vs = CreationHelper.createStringExpression(s);
		}
		variableCallExpr_AST = (AST)currentAST.root;
		returnAST = variableCallExpr_AST;
		return vs;
	}
	
	public final ValueSpecification  enumerationSpecification() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST enumerationSpecification_AST = null;
		Token  ident = null;
		AST ident_AST = null;
		
		
				context = IContext.ENUMERATION;
			
		{
		ident = LT(1);
		ident_AST = astFactory.create(ident);
		astFactory.addASTChild(currentAST, ident_AST);
		match(IDENT);
		//es =  CreationHelper.createEnumerationSpecification(ident.getText()); 
				vs =  CreationHelper.createStringExpression(ident.getText());
				
		}
		enumerationSpecification_AST = (AST)currentAST.root;
		returnAST = enumerationSpecification_AST;
		return vs;
	}
	
	public final LiteralReal  realLiteral() throws RecognitionException, TokenStreamException {
		LiteralReal lr;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST realLiteral_AST = null;
		Token  m = null;
		AST m_AST = null;
		Token  a = null;
		AST a_AST = null;
		Token  b = null;
		AST b_AST = null;
		Token  e = null;
		AST e_AST = null;
		
		
				context = IContext.REAL_LITERAL;
			
		{
		{
		{
		switch ( LA(1)) {
		case PLUS:
		{
			AST tmp40_AST = null;
			tmp40_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp40_AST);
			match(PLUS);
			break;
		}
		case MINUS:
		{
			m = LT(1);
			m_AST = astFactory.create(m);
			astFactory.addASTChild(currentAST, m_AST);
			match(MINUS);
			break;
		}
		case DECIMAL_STRING:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		a = LT(1);
		a_AST = astFactory.create(a);
		astFactory.addASTChild(currentAST, a_AST);
		match(DECIMAL_STRING);
		AST tmp41_AST = null;
		tmp41_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp41_AST);
		match(DOT);
		b = LT(1);
		b_AST = astFactory.create(b);
		astFactory.addASTChild(currentAST, b_AST);
		match(DECIMAL_STRING);
		{
		switch ( LA(1)) {
		case IDENT:
		{
			e = LT(1);
			e_AST = astFactory.create(e);
			astFactory.addASTChild(currentAST, e_AST);
			match(IDENT);
			break;
		}
		case EOF:
		case MOD:
		case DOT:
		case DOTDOT:
		case LBRACK:
		case RBRACK:
		case RCURLY:
		case COMMA:
		case COLON:
		case STAR:
		case RPAREN:
		case PLUS:
		case MINUS:
		case LE:
		case LT:
		case GE:
		case GT:
		case EQUAL:
		case DIFF:
		case DIV:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		}
		
			   	String sign = (m == null)? "": "-";
			   	String expo = (e == null)? "": e.getText();
			   	try {
			   	lr=CreationHelper.createLiteralReal(Double.parseDouble(sign + a.getText() + "." +  b.getText() + expo)) ;
			   	} catch (Exception exn){
			   		throw new RecognitionException("not a correct scientific Real");
			   	}
			
		}
		realLiteral_AST = (AST)currentAST.root;
		returnAST = realLiteral_AST;
		return lr;
	}
	
	public final LiteralInteger  integerLiteral() throws RecognitionException, TokenStreamException {
		LiteralInteger li;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST integerLiteral_AST = null;
		Token  m1 = null;
		AST m1_AST = null;
		Token  i = null;
		AST i_AST = null;
		Token  m2 = null;
		AST m2_AST = null;
		Token  j = null;
		AST j_AST = null;
		Token  m3 = null;
		AST m3_AST = null;
		Token  k = null;
		AST k_AST = null;
		
		
				context = IContext.INTEGER_LITERAL;
			
		{
		if ((LA(1)==DECIMAL_STRING||LA(1)==PLUS||LA(1)==MINUS) && (_tokenSet_26.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			{
			{
			{
			switch ( LA(1)) {
			case PLUS:
			{
				AST tmp42_AST = null;
				tmp42_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp42_AST);
				match(PLUS);
				break;
			}
			case MINUS:
			{
				m1 = LT(1);
				m1_AST = astFactory.create(m1);
				astFactory.addASTChild(currentAST, m1_AST);
				match(MINUS);
				break;
			}
			case DECIMAL_STRING:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			i = LT(1);
			i_AST = astFactory.create(i);
			astFactory.addASTChild(currentAST, i_AST);
			match(DECIMAL_STRING);
			}
			
							String sign = (m1 == null)? "": "-";
							li = CreationHelper.createLiteralInteger(Integer.parseInt(sign + i.getText())) ;
						
			}
		}
		else if ((LA(1)==HEXADECIMAL_STRING||LA(1)==PLUS||LA(1)==MINUS) && (_tokenSet_27.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			{
			{
			{
			switch ( LA(1)) {
			case PLUS:
			{
				AST tmp43_AST = null;
				tmp43_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp43_AST);
				match(PLUS);
				break;
			}
			case MINUS:
			{
				m2 = LT(1);
				m2_AST = astFactory.create(m2);
				astFactory.addASTChild(currentAST, m2_AST);
				match(MINUS);
				break;
			}
			case HEXADECIMAL_STRING:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			j = LT(1);
			j_AST = astFactory.create(j);
			astFactory.addASTChild(currentAST, j_AST);
			match(HEXADECIMAL_STRING);
			}
			
						 int val = (m2==null)?intFromHexaString(j.getText()): -intFromHexaString(j.getText());
						 li = CreationHelper.createLiteralInteger(val) ; 
						
			}
		}
		else if ((LA(1)==BINARY_STRING||LA(1)==PLUS||LA(1)==MINUS) && (_tokenSet_28.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			{
			{
			{
			switch ( LA(1)) {
			case PLUS:
			{
				AST tmp44_AST = null;
				tmp44_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp44_AST);
				match(PLUS);
				break;
			}
			case MINUS:
			{
				m3 = LT(1);
				m3_AST = astFactory.create(m3);
				astFactory.addASTChild(currentAST, m3_AST);
				match(MINUS);
				break;
			}
			case BINARY_STRING:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			k = LT(1);
			k_AST = astFactory.create(k);
			astFactory.addASTChild(currentAST, k_AST);
			match(BINARY_STRING);
			}
			
						int val  = (m3==null)? intFromBinaryString(k.getText()): - intFromBinaryString(k.getText());
						li =CreationHelper.createLiteralInteger(val) ; 
						
			}
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		integerLiteral_AST = (AST)currentAST.root;
		returnAST = integerLiteral_AST;
		return li;
	}
	
	public final LiteralUnlimitedNatural  unlimitedLiteral() throws RecognitionException, TokenStreamException {
		LiteralUnlimitedNatural lun;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST unlimitedLiteral_AST = null;
		Token  i = null;
		AST i_AST = null;
		
		
				context = IContext.UNLIMITED_LITERAL;
				LiteralInteger li = null;
				lun = null;
			
		{
		{
		switch ( LA(1)) {
		case STAR:
		{
			i = LT(1);
			i_AST = astFactory.create(i);
			astFactory.addASTChild(currentAST, i_AST);
			match(STAR);
			break;
		}
		case DECIMAL_STRING:
		case BINARY_STRING:
		case HEXADECIMAL_STRING:
		case PLUS:
		case MINUS:
		{
			li=integerLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		
				      	String s = (i != null)?i.getText(): li.getValue() + "";
				      	if (s.equals("*")){
				      	 lun = CreationHelper.createLiteralUnlimitedNatural(-1);
				      	} else {
				      	 if (li.getValue() < 0)
				      	  throw new RecognitionException("Unlimited Naturals are positiv or null");
				      	 else
				      	 lun = CreationHelper.createLiteralUnlimitedNatural(Integer.parseInt(s)) ;
				      	}
					
		}
		unlimitedLiteral_AST = (AST)currentAST.root;
		returnAST = unlimitedLiteral_AST;
		return lun;
	}
	
	public final LiteralDefault  defaultLiteral() throws RecognitionException, TokenStreamException {
		LiteralDefault ld;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST defaultLiteral_AST = null;
		
		
				context = IContext.DEFAULT_LITERAL;
			
		{
		AST tmp45_AST = null;
		tmp45_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp45_AST);
		match(44);
		ld = CreationHelper.createLiteralDefault();
		}
		defaultLiteral_AST = (AST)currentAST.root;
		returnAST = defaultLiteral_AST;
		return ld;
	}
	
	public final VSLDate  timeStr() throws RecognitionException, TokenStreamException {
		VSLDate c;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST timeStr_AST = null;
		Token  t = null;
		AST t_AST = null;
		
		
				context = IContext.TIME_STR;
				c = new VSLDate();
			    String h,m,s,cs = "";
			
		t = LT(1);
		t_AST = astFactory.create(t);
		astFactory.addASTChild(currentAST, t_AST);
		match(TIME);
		
				try {
				c.parseTime(t.getText());
				} catch (Exception e){
				  throw new  RecognitionException(e.getMessage());
				}
			
		timeStr_AST = (AST)currentAST.root;
		returnAST = timeStr_AST;
		return c;
	}
	
	public final VSLDate  dateStr() throws RecognitionException, TokenStreamException {
		VSLDate c;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST dateStr_AST = null;
		Token  date = null;
		AST date_AST = null;
		
		
				context = IContext.DATE_STR;
				c = new VSLDate();
				String y,m,d = "";
		
			
		{
		date = LT(1);
		date_AST = astFactory.create(date);
		astFactory.addASTChild(currentAST, date_AST);
		match(DATE);
		
			 	try {
			 		c.parseDate(date.getText());
			 	} catch (Exception e) {
			 	 throw new RecognitionException(e.getMessage());
			 	}
			
		}
		dateStr_AST = (AST)currentAST.root;
		returnAST = dateStr_AST;
		return c;
	}
	
	public final VSLDate  dayStr() throws RecognitionException, TokenStreamException {
		VSLDate c;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST dayStr_AST = null;
		Token  i = null;
		AST i_AST = null;
		
		
				context = IContext.DAY_STR;
				c = new VSLDate();
				
			
		{
		i = LT(1);
		i_AST = astFactory.create(i);
		astFactory.addASTChild(currentAST, i_AST);
		match(DAY);
		String s = i.getText();
					      if (s.equals("Mon")){
					      	c.dayOfWeek = VSLDate.DayOfWeek.MONDAY;
					      }  else if (s.equals("Tue")){
					      c.dayOfWeek = VSLDate.DayOfWeek.TUESDAY;
					      } else if (s.equals("Wed")){
					      	c.dayOfWeek = VSLDate.DayOfWeek.WEDNESDAY;
					      } else if (s.equals("Thr")){
					      	c.dayOfWeek = VSLDate.DayOfWeek.THURSDAY;
					      } else if (s.equals("Fri")){
					      	c.dayOfWeek = VSLDate.DayOfWeek.FRIDAY;
						  } else if (s.equals("Sat")) {
						 	c.dayOfWeek = VSLDate.DayOfWeek.SATURDAY;
						  } else {
							c.dayOfWeek = VSLDate.DayOfWeek.SUNDAY;
						  }
				
		}
		dayStr_AST = (AST)currentAST.root;
		returnAST = dayStr_AST;
		return c;
	}
	
	public final String  hour() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST hour_AST = null;
		Token  in = null;
		AST in_AST = null;
		
		
				context = IContext.HOUR;
			
		{
		in = LT(1);
		in_AST = astFactory.create(in);
		astFactory.addASTChild(currentAST, in_AST);
		match(DECIMAL_STRING);
		
					int value = Integer.valueOf(in.getText()).intValue();
					if(value > 23 || value < 0) {
						error("error!!!!! not an hour : "+in.getText());	
					}
					s = in.getText();
				
		}
		hour_AST = (AST)currentAST.root;
		returnAST = hour_AST;
		return s;
	}
	
	public final String  minute() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST minute_AST = null;
		Token  in = null;
		AST in_AST = null;
		
		
				context = IContext.MINUTE;
			
		{
		in = LT(1);
		in_AST = astFactory.create(in);
		astFactory.addASTChild(currentAST, in_AST);
		match(DECIMAL_STRING);
		
					int value = Integer.valueOf(in.getText()).intValue();
					if(value > 59 || value < 0) {
						error("error!!!!! not a minute : "+in.getText());	
					}
					s = in.getText();
				
		}
		minute_AST = (AST)currentAST.root;
		returnAST = minute_AST;
		return s;
	}
	
	public final String  second() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST second_AST = null;
		Token  in = null;
		AST in_AST = null;
		
		
				context = IContext.SECOND;
			
		{
		in = LT(1);
		in_AST = astFactory.create(in);
		astFactory.addASTChild(currentAST, in_AST);
		match(DECIMAL_STRING);
		
					int value = Integer.valueOf(in.getText()).intValue();
					if(value > 59 || value < 0) {
						error("error!!!!! not a second : "+in.getText());	
					}
					s = in.getText();
				
		}
		second_AST = (AST)currentAST.root;
		returnAST = second_AST;
		return s;
	}
	
	public final String  centisec() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST centisec_AST = null;
		Token  in = null;
		AST in_AST = null;
		
		
				context = IContext.CENTISEC;
			
		{
		in = LT(1);
		in_AST = astFactory.create(in);
		astFactory.addASTChild(currentAST, in_AST);
		match(DECIMAL_STRING);
		
					int value = Integer.valueOf(in.getText()).intValue();
					if(value > 99 || value < 0) {
						error("error!!!!! not a centisecond : "+in.getText());	
					}
					s = in.getText();
				
		}
		centisec_AST = (AST)currentAST.root;
		returnAST = centisec_AST;
		return s;
	}
	
	public final String  year() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST year_AST = null;
		Token  in = null;
		AST in_AST = null;
		
		
				context = IContext.YEAR;
			
		{
		in = LT(1);
		in_AST = astFactory.create(in);
		astFactory.addASTChild(currentAST, in_AST);
		match(DECIMAL_STRING);
		
					int value = Integer.valueOf(in.getText()).intValue();
					if(value > 9999 || value < 0) {
						error("error!!!!! not a year : "+in.getText());	
					}
					s = in.getText();
				
		}
		year_AST = (AST)currentAST.root;
		returnAST = year_AST;
		return s;
	}
	
	public final String  month() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST month_AST = null;
		Token  in = null;
		AST in_AST = null;
		
		
				context = IContext.MONTH;
			
		{
		in = LT(1);
		in_AST = astFactory.create(in);
		astFactory.addASTChild(currentAST, in_AST);
		match(DECIMAL_STRING);
		
					int value = Integer.valueOf(in.getText()).intValue();
					if(value > 12 || value < 1) {
						error("error!!!!! not a month : "+in.getText());	
					}
					s = in.getText();
				
		}
		month_AST = (AST)currentAST.root;
		returnAST = month_AST;
		return s;
	}
	
	public final String  dayOfMonth() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST dayOfMonth_AST = null;
		Token  in = null;
		AST in_AST = null;
		
		
				context = IContext.DAY_OF_MONTH;
			
		{
		in = LT(1);
		in_AST = astFactory.create(in);
		astFactory.addASTChild(currentAST, in_AST);
		match(DECIMAL_STRING);
		
					int value = Integer.valueOf(in.getText()).intValue();
					if(value > 31 || value < 1) {
						error("error!!!!! not a day of month : "+in.getText());	
					}
					s = in.getText();
				
		}
		dayOfMonth_AST = (AST)currentAST.root;
		returnAST = dayOfMonth_AST;
		return s;
	}
	
	public final String  nowStr() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST nowStr_AST = null;
		
		
				context = IContext.NOW;
				s = "now";
			
		{
		AST tmp46_AST = null;
		tmp46_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp46_AST);
		match(LITERAL_now);
		}
		nowStr_AST = (AST)currentAST.root;
		returnAST = nowStr_AST;
		return s;
	}
	
	public final ValueSpecification  intervalBound() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST intervalBound_AST = null;
		
		
				context = IContext.INTERVAL_BOUND;
			
		{
		if ((_tokenSet_29.member(LA(1))) && (_tokenSet_30.member(LA(2))) && (_tokenSet_31.member(LA(3))) && (_tokenSet_15.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			vs=literalIntervalBound();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((LA(1)==LPAREN) && (_tokenSet_4.member(LA(2))) && (_tokenSet_6.member(LA(3))) && (_tokenSet_7.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			vs=tupleIntervalBound();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((LA(1)==IDENT) && (LA(2)==LPAREN) && (_tokenSet_4.member(LA(3))) && (_tokenSet_6.member(LA(4))) && (_tokenSet_7.member(LA(5)))) {
			vs=choiceIntervalBound();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_13.member(LA(1))) && (_tokenSet_32.member(LA(2))) && (_tokenSet_5.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			vs=expressionIntervalBound();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		intervalBound_AST = (AST)currentAST.root;
		returnAST = intervalBound_AST;
		return vs;
	}
	
	public final ValueSpecification  literalIntervalBound() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST literalIntervalBound_AST = null;
		
		
				context = IContext.LITERAL_INTERVAL_BOUND;
			
		{
		switch ( LA(1)) {
		case STAR:
		case DECIMAL_STRING:
		case BINARY_STRING:
		case HEXADECIMAL_STRING:
		case PLUS:
		case MINUS:
		{
			vs=numberLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case SHARP:
		{
			vs=datetimeLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		literalIntervalBound_AST = (AST)currentAST.root;
		returnAST = literalIntervalBound_AST;
		return vs;
	}
	
	public final ValueSpecification  tupleIntervalBound() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST tupleIntervalBound_AST = null;
		
		
				context = IContext.TUPLE_INTERVAL_BOUND;
			
		{
		vs=tuple();
		astFactory.addASTChild(currentAST, returnAST);
		}
		tupleIntervalBound_AST = (AST)currentAST.root;
		returnAST = tupleIntervalBound_AST;
		return vs;
	}
	
	public final ValueSpecification  choiceIntervalBound() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST choiceIntervalBound_AST = null;
		
		
				context = IContext.CHOICE_INTERVAL_BOUND;
			
		{
		vs=choice();
		astFactory.addASTChild(currentAST, returnAST);
		}
		choiceIntervalBound_AST = (AST)currentAST.root;
		returnAST = choiceIntervalBound_AST;
		return vs;
	}
	
	public final ValueSpecification  expressionIntervalBound() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expressionIntervalBound_AST = null;
		
		
				context = IContext.EXPRESSION_INTERVAL_BOUND;
			
		{
		vs=expression();
		astFactory.addASTChild(currentAST, returnAST);
		}
		expressionIntervalBound_AST = (AST)currentAST.root;
		returnAST = expressionIntervalBound_AST;
		return vs;
	}
	
	public final java.util.ArrayList<ValueSpecification>  valueSpecificationList() throws RecognitionException, TokenStreamException {
		java.util.ArrayList<ValueSpecification> lst;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST valueSpecificationList_AST = null;
		
		
				lst = new java.util.ArrayList<ValueSpecification>();
				ValueSpecification ls = null;
				java.util.ArrayList<ValueSpecification> rec = null;
			
		{
		{
		ls=valueSpecification();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case COMMA:
		{
			AST tmp47_AST = null;
			tmp47_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp47_AST);
			match(COMMA);
			{
			rec=valueSpecificationList();
			astFactory.addASTChild(currentAST, returnAST);
			}
			break;
		}
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		
				 lst.add(ls) ;
				 if (rec != null)
				  lst.addAll(rec);
			
		}
		valueSpecificationList_AST = (AST)currentAST.root;
		returnAST = valueSpecificationList_AST;
		return lst;
	}
	
	public final java.util.ArrayList<TupleItemValue>  tupleItemList() throws RecognitionException, TokenStreamException {
		java.util.ArrayList<TupleItemValue> lst;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST tupleItemList_AST = null;
		
		
				lst = new java.util.ArrayList<TupleItemValue>();
				TupleItemValue ti = null;
				java.util.ArrayList<TupleItemValue> rec = null;
			
		{
		ti=tupleItem();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case COMMA:
		{
			AST tmp48_AST = null;
			tmp48_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp48_AST);
			match(COMMA);
			{
			rec=tupleItemList();
			astFactory.addASTChild(currentAST, returnAST);
			}
			break;
		}
		case RPAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		
				 lst.add(ti) ;
				 if (rec != null)
				  lst.addAll(rec);
			
		tupleItemList_AST = (AST)currentAST.root;
		returnAST = tupleItemList_AST;
		return lst;
	}
	
	public final  TupleItemValue  tupleItem() throws RecognitionException, TokenStreamException {
		 TupleItemValue tiv ;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST tupleItem_AST = null;
		Token  id = null;
		AST id_AST = null;
		
		
				context = IContext.TUPLEITEM;
				ValueSpecification vs = null;
			
		{
		{
		{
		if ((LA(1)==IDENT) && (LA(2)==ASSIGN)) {
			id = LT(1);
			id_AST = astFactory.create(id);
			astFactory.addASTChild(currentAST, id_AST);
			match(IDENT);
			AST tmp49_AST = null;
			tmp49_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp49_AST);
			match(ASSIGN);
		}
		else if ((_tokenSet_4.member(LA(1))) && (_tokenSet_33.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		}
		vs=valueSpecification();
		astFactory.addASTChild(currentAST, returnAST);
		
				 	String tname = (id == null)? "": id.getText();
				 	tiv = CreationHelper.creaTupleItemValue(tname, vs);
				
		}
		tupleItem_AST = (AST)currentAST.root;
		returnAST = tupleItem_AST;
		return tiv ;
	}
	
	public final  String  chosenAlternativeName() throws RecognitionException, TokenStreamException {
		 String s ;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST chosenAlternativeName_AST = null;
		Token  id = null;
		AST id_AST = null;
		
		
				//context = IContext.CHOSEN_ALTERNATIVE_NAME;
			
		{
		id = LT(1);
		id_AST = astFactory.create(id);
		astFactory.addASTChild(currentAST, id_AST);
		match(IDENT);
		s = id.getText();
		}
		chosenAlternativeName_AST = (AST)currentAST.root;
		returnAST = chosenAlternativeName_AST;
		return s ;
	}
	
	public final Variable  variableDeclaration() throws RecognitionException, TokenStreamException {
		Variable v;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST variableDeclaration_AST = null;
		
		
				context = IContext.VARIABLE_DECLARATION;
				String[] name = null;
				String typName = "";
				VariableDirectionKind dir = null;
				ValueSpecification vs = null;
			
		{
		{
		dir=variableDirection();
		astFactory.addASTChild(currentAST, returnAST);
		name=variableName();
		astFactory.addASTChild(currentAST, returnAST);
		{
		AST tmp50_AST = null;
		tmp50_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp50_AST);
		match(COLON);
		typName=typeName();
		astFactory.addASTChild(currentAST, returnAST);
		}
		{
		switch ( LA(1)) {
		case ASSIGN:
		{
			AST tmp51_AST = null;
			tmp51_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp51_AST);
			match(ASSIGN);
			vs=valueSpecification();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case EOF:
		case MOD:
		case DOT:
		case DOTDOT:
		case LBRACK:
		case RBRACK:
		case RCURLY:
		case COMMA:
		case COLON:
		case STAR:
		case RPAREN:
		case PLUS:
		case MINUS:
		case LE:
		case LT:
		case GE:
		case GT:
		case EQUAL:
		case DIFF:
		case DIV:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		
					v = CreationHelper.createVariable(name[1], name[0], dir, typName, vs);
			
		}
		variableDeclaration_AST = (AST)currentAST.root;
		returnAST = variableDeclaration_AST;
		return v;
	}
	
	public final ValueSpecification  ifTrueExpr() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST ifTrueExpr_AST = null;
		
		
				context = IContext.IF_TRUE_EXPR;
			
		{
		vs=valueSpecification();
		astFactory.addASTChild(currentAST, returnAST);
		}
		ifTrueExpr_AST = (AST)currentAST.root;
		returnAST = ifTrueExpr_AST;
		return vs;
	}
	
	public final ValueSpecification  ifFalseExpr() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST ifFalseExpr_AST = null;
		
		
				context = IContext.IF_FALSE_EXPR;
			
		{
		vs=valueSpecification();
		astFactory.addASTChild(currentAST, returnAST);
		}
		ifFalseExpr_AST = (AST)currentAST.root;
		returnAST = ifFalseExpr_AST;
		return vs;
	}
	
	public final String  nameExpression() throws RecognitionException, TokenStreamException {
		String name;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST nameExpression_AST = null;
		Token  s1 = null;
		AST s1_AST = null;
		
		
			String s2 = null;
		
		{
		s1 = LT(1);
		s1_AST = astFactory.create(s1);
		astFactory.addASTChild(currentAST, s1_AST);
		match(IDENT);
		{
		if ((LA(1)==DOT) && (LA(2)==IDENT) && (_tokenSet_0.member(LA(3))) && (_tokenSet_1.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			AST tmp52_AST = null;
			tmp52_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp52_AST);
			match(DOT);
			s2=nameExpression();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		}
		
				name = s1.getText();
				if (s2 != null)
				 name += "." + s2;
				
			
		nameExpression_AST = (AST)currentAST.root;
		returnAST = nameExpression_AST;
		return name;
	}
	
	public final VariableDirectionKind  variableDirection() throws RecognitionException, TokenStreamException {
		VariableDirectionKind dir;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST variableDirection_AST = null;
		
		
				context = IContext.VARIABLE_DIRECTION;
			
		{
		switch ( LA(1)) {
		case IN_DIR:
		{
			AST tmp53_AST = null;
			tmp53_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp53_AST);
			match(IN_DIR);
			dir = VariableDirectionKind.IN_LITERAL;
			break;
		}
		case OUT_DIR:
		{
			AST tmp54_AST = null;
			tmp54_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp54_AST);
			match(OUT_DIR);
			dir = VariableDirectionKind.OUT_LITERAL;
			break;
		}
		case INOUT_DIR:
		{
			AST tmp55_AST = null;
			tmp55_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp55_AST);
			match(INOUT_DIR);
			dir = VariableDirectionKind.INOUT_LITERAL;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		variableDirection_AST = (AST)currentAST.root;
		returnAST = variableDirection_AST;
		return dir;
	}
	
	public final String[]  variableName() throws RecognitionException, TokenStreamException {
		String[] s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST variableName_AST = null;
		Token  id = null;
		AST id_AST = null;
		
		
				context = IContext.VARIABLE_NAME;
				s = new String[2];
				String ns = "";
			
		{
		{
		{
		if ((LA(1)==IDENT) && (LA(2)==DOT)) {
			ns=namespace();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp56_AST = null;
			tmp56_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp56_AST);
			match(DOT);
		}
		else if ((LA(1)==IDENT) && (LA(2)==COLON)) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		id = LT(1);
		id_AST = astFactory.create(id);
		astFactory.addASTChild(currentAST, id_AST);
		match(IDENT);
		}
		
					 s[0] = ns;
					 
					 
					 s[1] = id.getText(); 
				
		}
		variableName_AST = (AST)currentAST.root;
		returnAST = variableName_AST;
		return s;
	}
	
	public final String  typeName() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeName_AST = null;
		Token  id = null;
		AST id_AST = null;
		
		
				context = IContext.TYPE_NAME;
			
		{
		id = LT(1);
		id_AST = astFactory.create(id);
		astFactory.addASTChild(currentAST, id_AST);
		match(IDENT);
		s = id.getText();
		}
		typeName_AST = (AST)currentAST.root;
		returnAST = typeName_AST;
		return s;
	}
	
	public final String  namespace() throws RecognitionException, TokenStreamException {
		String s;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST namespace_AST = null;
		Token  id = null;
		AST id_AST = null;
		
		
				context = IContext.NAMESPACE;
			
		{
		id = LT(1);
		id_AST = astFactory.create(id);
		astFactory.addASTChild(currentAST, id_AST);
		match(IDENT);
		s = id.getText();
		}
		namespace_AST = (AST)currentAST.root;
		returnAST = namespace_AST;
		return s;
	}
	
	public final ValueSpecification  initExpr() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST initExpr_AST = null;
		
		
				context = IContext.INIT_EXPR;
			
		{
		vs=valueSpecification();
		astFactory.addASTChild(currentAST, returnAST);
		}
		initExpr_AST = (AST)currentAST.root;
		returnAST = initExpr_AST;
		return vs;
	}
	
	public final OperationCallExpression  operationCallExpr() throws RecognitionException, TokenStreamException {
		OperationCallExpression oce;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST operationCallExpr_AST = null;
		
		
				context = IContext.OPERATION_CALL_EXPR;
				String name = "";
				java.util.ArrayList<ValueSpecification> lst = null;
				ValueSpecification right, left = null;
				
				
			
		{
		{
		left=internalValueSpecification();
		astFactory.addASTChild(currentAST, returnAST);
		name=operationSymbol();
		astFactory.addASTChild(currentAST, returnAST);
		right=internalValueSpecification();
		astFactory.addASTChild(currentAST, returnAST);
		}
		
					lst = new java.util.ArrayList<ValueSpecification>();
					lst.add(right);
					oce = CreationHelper.createOperationCallExpression(left, name, lst); 
				
		}
		operationCallExpr_AST = (AST)currentAST.root;
		returnAST = operationCallExpr_AST;
		return oce;
	}
	
	public final ValueSpecification  argumentValue() throws RecognitionException, TokenStreamException {
		ValueSpecification vs;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST argumentValue_AST = null;
		
		
				context = IContext.ARGUMENT_VALUE;
			
		{
		vs=valueSpecification();
		astFactory.addASTChild(currentAST, returnAST);
		}
		argumentValue_AST = (AST)currentAST.root;
		returnAST = argumentValue_AST;
		return vs;
	}
	
	public final TimeExpression  durationOrInstantExpression() throws RecognitionException, TokenStreamException {
		TimeExpression te;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST durationOrInstantExpression_AST = null;
		Token  id = null;
		AST id_AST = null;
		Token  id2 = null;
		AST id2_AST = null;
		Token  m = null;
		AST m_AST = null;
		Token  p = null;
		AST p_AST = null;
		
			te = null;
			ValueSpecification afterWhenExpr = null;
			ValueSpecification occurIndex = null;
			ValueSpecification whenExpr = null;
			ObsCallExpression right = null;
			ObsCallExpression left = null;
			context = IContext.OBS_EXPRESSION;
		
		
		if ((LA(1)==IDENT)) {
			right=obsExpression();
			astFactory.addASTChild(currentAST, returnAST);
			te =CreationHelper.createTimeExpression(right);
			durationOrInstantExpression_AST = (AST)currentAST.root;
		}
		else if (((LA(1)==LPAREN) && (LA(2)==IDENT) && (LA(3)==LBRACK) && (_tokenSet_4.member(LA(4))) && (_tokenSet_8.member(LA(5))))&&( whenAfterRBRACK() )) {
			{
			AST tmp57_AST = null;
			tmp57_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp57_AST);
			match(LPAREN);
			id = LT(1);
			id_AST = astFactory.create(id);
			astFactory.addASTChild(currentAST, id_AST);
			match(IDENT);
			AST tmp58_AST = null;
			tmp58_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp58_AST);
			match(LBRACK);
			occurIndex=valueSpecification();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp59_AST = null;
			tmp59_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp59_AST);
			match(RBRACK);
			AST tmp60_AST = null;
			tmp60_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp60_AST);
			match(WHEN);
			afterWhenExpr=valueSpecification();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp61_AST = null;
			tmp61_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp61_AST);
			match(RPAREN);
			}
			
				
				context = IContext.OBS_EXPRESSION;
			if (! (afterWhenExpr instanceof OperationCallExpression))
				throw new RecognitionException ("expecting symbol + (for instant) or - ");
				String symbol = ((OperationCallExpression)afterWhenExpr).getOperation(); 
				if (! (symbol.equals("+") || symbol.equals("-"))) {
				 throw new RecognitionException ("expecting symbol + (for instant) or - for duration but found " + symbol );
				}
			
				OperationCallExpression opCall = (OperationCallExpression)afterWhenExpr;
				whenExpr = (ValueSpecification)opCall.getArgument().get(0);
				
				Element leftArg = (Element)opCall.getArgument().get(1);
				
				if (leftArg instanceof TimeExpression)
					leftArg = (ObsCallExpression)((TimeExpression)leftArg).getObsExpr().get(0);
				
				if (! ( leftArg instanceof  ObsCallExpression) && ! ( leftArg instanceof  StringExpression))
							 	throw new RecognitionException ("expecting Obs Call Expression after " + symbol + " found " + leftArg.eClass().getName());
				
				if (leftArg instanceof StringExpression)
					right = CreationHelper.createObsCallExpression(((StringExpression)leftArg).getName(), 
															null, 
															null);
			else   												
					right = (ObsCallExpression)leftArg;
				
				left = CreationHelper.createObsCallExpression(id.getText(), 
															occurIndex, 
															whenExpr);
			
			if (symbol.equals("-")){
				te = CreationHelper.createDurationExpression(left, right);
				context = IContext.DURATION_EXPR;
			} else {
				te = CreationHelper.createInstantExpression(left, right);
				context = IContext.INSTANT_EXPR;
				
			}	
			
			durationOrInstantExpression_AST = (AST)currentAST.root;
		}
		else if ((LA(1)==LPAREN) && (LA(2)==IDENT) && (LA(3)==WHEN) && (_tokenSet_4.member(LA(4))) && (_tokenSet_17.member(LA(5)))) {
			{
			AST tmp62_AST = null;
			tmp62_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp62_AST);
			match(LPAREN);
			id2 = LT(1);
			id2_AST = astFactory.create(id2);
			astFactory.addASTChild(currentAST, id2_AST);
			match(IDENT);
			AST tmp63_AST = null;
			tmp63_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp63_AST);
			match(WHEN);
			afterWhenExpr=valueSpecification();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp64_AST = null;
			tmp64_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp64_AST);
			match(RPAREN);
			}
			
			
			context = IContext.OBS_EXPRESSION;
			if (! (afterWhenExpr instanceof OperationCallExpression))
				throw new RecognitionException ("expecting symbol + (for instant) or - ");
				String symbol = ((OperationCallExpression)afterWhenExpr).getOperation(); 
				if (! (symbol.equals("+") || symbol.equals("-"))) {
				 throw new RecognitionException ("expecting symbol + (for instant) or - for duration but found " + symbol );
				}
			
				OperationCallExpression opCall = (OperationCallExpression)afterWhenExpr;
				whenExpr = (ValueSpecification)opCall.getArgument().get(0);
				
				Element leftArg = (Element)opCall.getArgument().get(1);
				
				if (leftArg instanceof TimeExpression)
					leftArg = (ObsCallExpression)((TimeExpression)leftArg).getObsExpr().get(0);
					
				if (! ( leftArg instanceof  ObsCallExpression) && ! ( leftArg instanceof  StringExpression))
							 	throw new RecognitionException ("expecting Obs Call Expression after " + symbol + " found " + leftArg.eClass().getName());
				if (leftArg instanceof StringExpression)
					right = CreationHelper.createObsCallExpression(((StringExpression)leftArg).getName(), 
															null, 
															null);
			else   												
					right = (ObsCallExpression)leftArg;
				
				left = CreationHelper.createObsCallExpression(id2.getText(), 
															occurIndex, 
															whenExpr);
			
			if (symbol.equals("-")){
				te = CreationHelper.createDurationExpression(left, right);
				context = IContext.DURATION_EXPR;
			} else {
				te = CreationHelper.createInstantExpression(left, right);
				context = IContext.INSTANT_EXPR;
				
			}
			
			durationOrInstantExpression_AST = (AST)currentAST.root;
		}
		else if ((LA(1)==LPAREN) && (LA(2)==IDENT) && (_tokenSet_34.member(LA(3))) && (_tokenSet_4.member(LA(4))) && (_tokenSet_17.member(LA(5)))) {
			{
			AST tmp65_AST = null;
			tmp65_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp65_AST);
			match(LPAREN);
			left=obsExpression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			switch ( LA(1)) {
			case MINUS:
			{
				m = LT(1);
				m_AST = astFactory.create(m);
				astFactory.addASTChild(currentAST, m_AST);
				match(MINUS);
				break;
			}
			case PLUS:
			{
				p = LT(1);
				p_AST = astFactory.create(p);
				astFactory.addASTChild(currentAST, p_AST);
				match(PLUS);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			right=obsExpression();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp66_AST = null;
			tmp66_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp66_AST);
			match(RPAREN);
			}
			
				context = IContext.OBS_EXPRESSION;
				if (m != null){
					te = CreationHelper.createDurationExpression(left, right);
					context = IContext.DURATION_EXPR;
				}
				else {
					te = CreationHelper.createInstantExpression(left, right);
					context = IContext.INSTANT_EXPR;
				}
			
			durationOrInstantExpression_AST = (AST)currentAST.root;
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = durationOrInstantExpression_AST;
		return te;
	}
	
	public final JitterExpression  jitterExpression() throws RecognitionException, TokenStreamException {
		JitterExpression je;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST jitterExpression_AST = null;
		
			 je = null;
			 ObsCallExpression obsExpr = null;
			 ObsCallExpression afterComma = null;
			  context = IContext.JITTER_EXPR;
		
		
		{
		AST tmp67_AST = null;
		tmp67_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp67_AST);
		match(JITTER);
		AST tmp68_AST = null;
		tmp68_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp68_AST);
		match(LPAREN);
		obsExpr=obsExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case COMMA:
		{
			AST tmp69_AST = null;
			tmp69_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp69_AST);
			match(COMMA);
			afterComma=obsExpression();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case RPAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp70_AST = null;
		tmp70_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp70_AST);
		match(RPAREN);
		}
		
			// TODO: check that durationOrInstantExpression does not return a duration 
			je = CreationHelper.createJitterExpression(obsExpr, afterComma);
			context = IContext.JITTER_EXPR;
		
		jitterExpression_AST = (AST)currentAST.root;
		returnAST = jitterExpression_AST;
		return je;
	}
	
	public final ObsCallExpression  obsExpression() throws RecognitionException, TokenStreamException {
		ObsCallExpression oce;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST obsExpression_AST = null;
		Token  id = null;
		AST id_AST = null;
		
		ValueSpecification whenExpr = null;
		context = IContext.OBS_EXPRESSION;
		
		
		if ((LA(1)==IDENT) && (LA(2)==LBRACK) && (_tokenSet_4.member(LA(3))) && (_tokenSet_8.member(LA(4))) && (_tokenSet_7.member(LA(5)))) {
			oce=obsExpressionWithOccurIndex();
			astFactory.addASTChild(currentAST, returnAST);
			obsExpression_AST = (AST)currentAST.root;
		}
		else if ((LA(1)==IDENT) && (_tokenSet_35.member(LA(2))) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_2.member(LA(5)))) {
			{
			id = LT(1);
			id_AST = astFactory.create(id);
			astFactory.addASTChild(currentAST, id_AST);
			match(IDENT);
			{
			switch ( LA(1)) {
			case WHEN:
			{
				AST tmp71_AST = null;
				tmp71_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp71_AST);
				match(WHEN);
				whenExpr=valueSpecification();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case EOF:
			case MOD:
			case DOT:
			case DOTDOT:
			case LBRACK:
			case RBRACK:
			case RCURLY:
			case COMMA:
			case COLON:
			case STAR:
			case RPAREN:
			case PLUS:
			case MINUS:
			case LE:
			case LT:
			case GE:
			case GT:
			case EQUAL:
			case DIFF:
			case DIV:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			}
			
				oce = CreationHelper.createObsCallExpression(id.getText(), 
															null, 
															whenExpr);
			context = IContext.SINGLE_OBS_EXPR;
			
			obsExpression_AST = (AST)currentAST.root;
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = obsExpression_AST;
		return oce;
	}
	
	public final ObsCallExpression  obsCallExpression() throws RecognitionException, TokenStreamException {
		ObsCallExpression oce;
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST obsCallExpression_AST = null;
		
			 oce = null;
		
		
		obsExpression();
		astFactory.addASTChild(currentAST, returnAST);
		obsCallExpression_AST = (AST)currentAST.root;
		returnAST = obsCallExpression_AST;
		return oce;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"DATE",
		"TIME",
		"MOD",
		"DOT",
		"DOTDOT",
		"LBRACK",
		"RBRACK",
		"LCURLY",
		"RCURLY",
		"COMMA",
		"COLON",
		"STAR",
		"DECIMAL_STRING",
		"BINARY_STRING",
		"HEXADECIMAL_STRING",
		"QUOTE",
		"DAY",
		"RPAREN",
		"LPAREN",
		"ASSIGN",
		"IDENT",
		"SHARP",
		"PLUS",
		"MINUS",
		"LE",
		"LT",
		"GE",
		"GT",
		"EQUAL",
		"DIFF",
		"DIV",
		"TRUE",
		"FALSE",
		"NULL",
		"STRING_TEXT",
		"IN_DIR",
		"OUT_DIR",
		"INOUT_DIR",
		"JITTER",
		"WHEN",
		"\"-\"",
		"\"now\"",
		"QUESTION"
	};
	
	protected void buildTokenTypeASTClassMap() {
		tokenTypeToASTClassMap=null;
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 34294790082L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 87960920260546L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = { 87960929697778L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = { 34292662336L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	private static final long[] mk_tokenSet_4() {
		long[] data = { 8761989631488L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
	private static final long[] mk_tokenSet_5() {
		long[] data = { 17592177131506L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
	private static final long[] mk_tokenSet_6() {
		long[] data = { 17592185503474L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
	private static final long[] mk_tokenSet_7() {
		long[] data = { 17592185520114L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
	private static final long[] mk_tokenSet_8() {
		long[] data = { 17592175009522L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
	private static final long[] mk_tokenSet_9() {
		long[] data = { 515648225280L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
	private static final long[] mk_tokenSet_10() {
		long[] data = { 34296297458L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());
	private static final long[] mk_tokenSet_11() {
		long[] data = { 87960921309138L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_11 = new BitSet(mk_tokenSet_11());
	private static final long[] mk_tokenSet_12() {
		long[] data = { 8830408783810L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_12 = new BitSet(mk_tokenSet_12());
	private static final long[] mk_tokenSet_13() {
		long[] data = { 4363943116800L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_13 = new BitSet(mk_tokenSet_13());
	private static final long[] mk_tokenSet_14() {
		long[] data = { 8796084109298L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_14 = new BitSet(mk_tokenSet_14());
	private static final long[] mk_tokenSet_15() {
		long[] data = { 87960921309170L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_15 = new BitSet(mk_tokenSet_15());
	private static final long[] mk_tokenSet_16() {
		long[] data = { 8761991728640L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_16 = new BitSet(mk_tokenSet_16());
	private static final long[] mk_tokenSet_17() {
		long[] data = { 17592177106674L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_17 = new BitSet(mk_tokenSet_17());
	private static final long[] mk_tokenSet_18() {
		long[] data = { 34295248834L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_18 = new BitSet(mk_tokenSet_18());
	private static final long[] mk_tokenSet_19() {
		long[] data = { 201818112L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_19 = new BitSet(mk_tokenSet_19());
	private static final long[] mk_tokenSet_20() {
		long[] data = { 202866864L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_20 = new BitSet(mk_tokenSet_20());
	private static final long[] mk_tokenSet_21() {
		long[] data = { 51839120L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_21 = new BitSet(mk_tokenSet_21());
	private static final long[] mk_tokenSet_22() {
		long[] data = { 55640192L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_22 = new BitSet(mk_tokenSet_22());
	private static final long[] mk_tokenSet_23() {
		long[] data = { 8761991728768L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_23 = new BitSet(mk_tokenSet_23());
	private static final long[] mk_tokenSet_24() {
		long[] data = { 34311632834L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_24 = new BitSet(mk_tokenSet_24());
	private static final long[] mk_tokenSet_25() {
		long[] data = { 201785344L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_25 = new BitSet(mk_tokenSet_25());
	private static final long[] mk_tokenSet_26() {
		long[] data = { 34294855618L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_26 = new BitSet(mk_tokenSet_26());
	private static final long[] mk_tokenSet_27() {
		long[] data = { 34295052226L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_27 = new BitSet(mk_tokenSet_27());
	private static final long[] mk_tokenSet_28() {
		long[] data = { 34294921154L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_28 = new BitSet(mk_tokenSet_28());
	private static final long[] mk_tokenSet_29() {
		long[] data = { 235372544L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_29 = new BitSet(mk_tokenSet_29());
	private static final long[] mk_tokenSet_30() {
		long[] data = { 1509296L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_30 = new BitSet(mk_tokenSet_30());
	private static final long[] mk_tokenSet_31() {
		long[] data = { 4398037596114L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_31 = new BitSet(mk_tokenSet_31());
	private static final long[] mk_tokenSet_32() {
		long[] data = { 8761990680496L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_32 = new BitSet(mk_tokenSet_32());
	private static final long[] mk_tokenSet_33() {
		long[] data = { 17592177114866L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_33 = new BitSet(mk_tokenSet_33());
	private static final long[] mk_tokenSet_34() {
		long[] data = { 8796294349312L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_34 = new BitSet(mk_tokenSet_34());
	private static final long[] mk_tokenSet_35() {
		long[] data = { 8830387812290L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_35 = new BitSet(mk_tokenSet_35());
	
	}
