///*******************************************************************************
//* Copyright (c) 2007 CEA List, THALES.
//* All rights reserved. This program and the accompanying materials
// * are made available under the terms of the Eclipse Public License v1.0
// * which accompanies this distribution, and is available at
// * http://www.eclipse.org/legal/epl-v10.html
//  
// * This software is distributed in the hope that it will be useful,
// * but WITHOUT ANY WARRANTY; without even the implied
// * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// * See the Eclipse Public License for more details.
// *
// * Contributors:
// *     CEA List - initial API and implementation
// *     THALES   - correction to lexems
// *******************************************************************************/

header {
 /*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
   
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   
 *******************************************************************************/
	/** @author Francois NIZOU july 6 2007 */
package com.cea.nfp.parsers.antlr;
}

/* #################################################
   ###                  LEXER                    ###
   #################################################
*/
class VSLLexer extends Lexer;

options {
	k =6;
	importVocab = VSL;  // Telling the export language is VSL
	testLiterals=false;    // don't automatically test for literals
	charVocabulary='\u0003'..'\uFFFF';
}

// antlr use whitespace to separate token but do not pass them to the parser.
WHITESPACE
    : (' ' | '\t' | '\r' | '\n') { $setType(Token.SKIP); }
    ;
    
// OPERATORS
QUESTION		:	'?'		;
LPAREN			:	'('		;
RPAREN			:	')'		;
LBRACK			:	'['		;
RBRACK			:	']'		;
LCURLY			:	'{'		;
RCURLY			:	'}'		;
COLON			:	':'		;
COMMA			:	','		;
ASSIGN			:	'='		;
EQUAL			:	"=="	;
LNOT			:	'!'		;
BNOT			:	'~'		;
NOT_EQUAL		:	"!="	;
DIV				:	'/'		;
DIV_ASSIGN		:	"/="	;
PLUS			:	'+'		;
PLUS_ASSIGN		:	"+="	;
INC				:	"++"	;
MINUS			:	'-'		;
MINUS_ASSIGN	:	"-="	;
DEC				:	"--"	;
STAR			:	'*'		;
STAR_ASSIGN		:	"*="	;
MOD				:	'%'		;
MOD_ASSIGN		:	"%="	;
SR				:	">>"	;
SR_ASSIGN		:	">>="	;
BSR				:	">>>"	;
BSR_ASSIGN		:	">>>="	;
GE				:	">="	;
GT				:	">"		;
SL				:	"<<"	;
SL_ASSIGN		:	"<<="	;
LE				:	"<="	;
LT				:	'<'		;
BXOR			:	'^'		;
BXOR_ASSIGN		:	"^="	;
BOR				:	'|'		;
BOR_ASSIGN		:	"|="	;
LOR				:	"||"	;
BAND			:	'&'		;
BAND_ASSIGN		:	"&="	;
LAND			:	"&&"	;
SEMI			:	';'		;
QUOTE 			:	'\''	;
SHARP			:	'#'		;
DIFF			:	"<>"	;


// Date and Times
// Francois: date and time are now tokens for recognition reason.
TIME: ('0'..'2')('0'..'9')':'('0'..'5')('0'..'9')':'('0'..'5')('0'..'9')(':'('0'..'9')('0'..'9'))?;
DATE: ('0'..'9')('0'..'9')('0'..'9')('0'..'9')'/'('0'..'1')('0'..'9')'/'('0'..'3')('0'..'9');

// variables
//VAR_PDECL		:	'@'		;
IN_DIR			:	"in$"	;
OUT_DIR			:	"out$"	;
INOUT_DIR		:	"inout$"	;

// literals


DECIMAL_STRING	:	('0'..'9')+;
BINARY_STRING	:	"0b" ('0' | '1')+ ;
HEXADECIMAL_STRING :	"0x" (('0'..'9') | ('A'..'F') | ('a'..'f'))+ ;

// boolean literal
TRUE			: 	"true"	;
FALSE			: 	"false"	;

// null literal 
NULL			:	"null"	;

// dot
DOT				:	'.';
DOTDOT			:	"..";

// datetime literal
DAY				:	"Mon" | "Tue" | "Wed" | "Thr" | "Fri" | "Sat" | "Sun";


// string literal
STRING_TEXT		:	QUOTE (SAFEUTF8CHAR)* QUOTE;

JITTER			:	"jitter" ;
WHEN			: 	"when" 	 ;


// UTF-8 character set
protected SAFEUTF8CHAR:
    '\u0001'..'\u0021' |
    '\u0023'..'\u0026' |
    '\u0028'..'\u007F' |
   // '\u0023'..'\u007F' | 
   //Francois: removed \u0028, the char quote because the last quote
   // is something eat by SAFEUTF8CHAR (e.g 'a'.plus('b') ).
    '\u00c0'..'\u00d6' |
    '\u00d8'..'\u00f6' |
    '\u00f8'..'\u00ff' |
    '\u0100'..'\u1fff' |
    '\u3040'..'\u318f' |
    '\u3300'..'\u337f' |
    '\u3400'..'\u3d2d' |
    '\u4e00'..'\u9fff' |
    '\uf900'..'\ufaff' ;

// EXPONENT was doing too much collision with IDENT. Therefor we treat Exponent as
// an ident and check in the real litteral rule if that is a correct one.
IDENT	:	(('a'..'z'|'A'..'Z'|'_') ( 'a'..'z'|'A'..'Z'|'_'|'0'..'9')*) 
            | (('E'|'e')('+'|'-')('0'..'9')*);


