// /*******************************************************************************
// * Copyright (c) 2007 CEA List, THALES.
// * All rights reserved. This program and the accompanying materials
// * are made available under the terms of the Eclipse Public License v1.0
// * which accompanies this distribution, and is available at
// * http://www.eclipse.org/legal/epl-v10.html
//   
// * This software is distributed in the hope that it will be useful,
// * but WITHOUT ANY WARRANTY; without even the implied
// * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// * See the Eclipse Public License for more details.
// *
// * Contributors:
// *     CEA List - initial API and implementation
// *     THALES   - added, removed and modified many rules to fit with the BNF and 
// *				- Added VSL model construction
// *******************************************************************************/

header {
	/*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
   
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   - added, removed and modified many rules to fit with the BNF and 
 *				- Added VSL model construction
 *******************************************************************************/
package com.cea.nfp.parsers.antlr;

import com.cea.nfp.parsers.texteditor.vsldatatypes.IContext;
import VSL.*;
import VSL.util.*;
import VSL.Variable;
import VSL.TimeExpression;
import org.eclipse.uml2.uml.*;
import com.thalesgroup.marte.vsl.CreationHelper;
import com.thalesgroup.marte.vsl.VSLDate;
}



class VSLParser extends Parser;

options {
	k = 5;
	exportVocab = VSL;
	buildAST = true;
	defaultErrorHandler = false;
}
// start point : the whole file is considered as a method Body

tokens {
	DATE;
	TIME;
	MOD;
	DOT;
	DOTDOT;
	LBRACK;
	RBRACK;
	LCURLY;
	RCURLY;
	COMMA;
	COLON;
	STAR;
	DECIMAL_STRING;
	BINARY_STRING;
	HEXADECIMAL_STRING;
	QUOTE;
	DAY;
	RPAREN;
	LPAREN;
	ASSIGN;
	IDENT;
	SHARP;
	PLUS;
	MINUS;
	LE;
	LT;
	GE;
	GT; 
	EQUAL;
	DIFF;
	DIV;

	TRUE;
	FALSE;

	NULL;
	
	STRING_TEXT;

	IN_DIR;
	OUT_DIR;
	INOUT_DIR;
	
	//BOR;
	
	JITTER;
	WHEN;
}
	

{
	private	VSLFactory vsFactory = VSLFactory.eINSTANCE;
	private UMLFactory umlFactory = UMLFactory.eINSTANCE;
	
	private int context = -1;
	
	/**
	 * Validation state (true = validation : does not modify the property
	 */
	private boolean isValidation = false;
	
	
	private static final boolean DEBUG = false;
	/**
	 * @return the isValidation boolean
	 */
	public boolean isValidation() {
		return isValidation;
	}

	/**
	 * @param isValidation the isValidation to set (true -> do not modify the property)
	 */
	public void setValidation(boolean isValidation) {
		this.isValidation = isValidation;
	}
	
	
	public int getContext() {
		return context;
	}
	
	public void setContext(int context) {
		this.context = context;
	}
	
	private void debug(String value) {
		System.out.println(value);
	}
	
	private void error(String value) {
		System.err.println(value);
	}

// whenAfterRBRACK, test if there is a WHEN after an RBRACK
	
	protected boolean whenAfterRBRACK() throws TokenStreamException {
		int i = 1;
		int la = LA(i);
		while (la != RBRACK && la != EOF) {
			la = LA(++i);
		}
		la = LA(++i);
		return (la == WHEN);
	}

// manualy lookahead if we are in a question
	protected boolean isQuestion() throws TokenStreamException {
		boolean isQuestion = false;

		int i = 1;
		int openedParen = 0;
		int la = LA(i);
		while (la != EOF) {
			switch (la) {
			case LPAREN:
				openedParen++;
				break;
			case RPAREN:
				openedParen--;
				break;
			case QUESTION:
				if (openedParen == 0)
					isQuestion = true;
				break;
			default:
				break;
			}
			if (isQuestion)
				break;
			la = LA(++i);
		}

		return isQuestion;

	}
	
	
		protected boolean isTimeExpr() throws TokenStreamException {
		if (LA(1) == JITTER)
			return true;
		int i = 1;
		int la = LA(i);
		boolean haveSeenNegOrPlus = false;
		while (la != EOF && la != RPAREN) {
			if (la == COMMA)
				return false;
			if (la == PLUS || la == MINUS)
				haveSeenNegOrPlus = true;
			la = LA(++i);
		}
		return haveSeenNegOrPlus;
	}
	
	// utility

	protected Integer intFromBinaryString(String s){
		s =  s.replaceFirst("0b", "");
		return Integer.parseInt(s, 2);
	}	

    protected Integer intFromHexaString(String s){
		s =  s.replaceFirst("0x", "");
		return Integer.parseInt(s, 16);
	}	

	public String notParsedEndMessage() throws TokenStreamException {
		if (LA(1) == EOF) {
			return null;
		} else {
			String s = "";

			Token token = LT(1);
			s += token.getText();
			int col = token.getColumn();
			inputState.getInput().consume();
			while (LA(1) != EOF) {
				token = LT(1);
				s += token.getText();
				inputState.getInput().consume();
			}

			return "'" + s + "' at column " + col;
		}
	}

}

// bh main entry point for the VSL language: NFP_Value_Specification
valueSpecification returns [ValueSpecification vs]
{
	context = IContext.NFP_VALUE_SPECIFICATION;
	ValueSpecification e1 = null;
	ValueSpecification e2 = null;
	String symbol = null;
}
:
  (e1=internalValueSpecification ((symbol=operationSymbol e2=valueSpecification)? | EOF))
  {
  if (symbol !=null){
  	 java.util.ArrayList<ValueSpecification> lst = new java.util.ArrayList<ValueSpecification>();
  	 lst.add(e2);
  	 vs = CreationHelper.createOperationCallExpression(e1 ,symbol, lst); 
  	} else {
  	 vs = e1;
  	}
  }
;


protected internalValueSpecification returns [ValueSpecification e]
	:
	{
		context = IContext.NFP_VALUE_SPECIFICATION;
		e = null;
		String opname = null;
		java.util.ArrayList<ValueSpecification> lst = null;
		ValueSpecification ifTrue = null;
		ValueSpecification ifFalse = null;
	}
	(
	(
		e=choice 
	|   e=obsExpressionWithOccurIndex { e =CreationHelper.createTimeExpression((ObsCallExpression)e); }
	|	e=literal				
	|	e=interval				
	|	e=collection			
	|   { !isQuestion() & isTimeExpr()}? e=timeExpression
	|	{!isQuestion()}? e=tuple
	|	e=expression
	|   e=timeExpression

	
	) (  DOT
			opname=operationName
			LPAREN
			(
				lst=argumentValueList
			)?
			RPAREN
	)? ){  if (opname != null) e = CreationHelper.createOperationCallExpression(e ,opname, lst) ; } 
	;


// LITERAL
// francois: Changed the way default literal was handled. Antlr was always
// triggering his numberLiteral rule so i factorised.

literal returns [ValueSpecification vs]
	:
	{   LiteralSpecification ls = null;
		context = IContext.LITERAL;
	}
	(
	 (	 m:MINUS (ls=numberLiteral|) 
	 ) { 
	 	if ( ls != null){
	 		CreationHelper.changeLiteralNumberSigne(ls);
	 		vs = ls;
	 	} else {
	 		vs = CreationHelper.createLiteralDefault();
	 	}
	 	
	  }
	|	vs=numberLiteral
	|	vs=stringLiteral
	|	vs=booleanLiteral
	|	vs=datetimeLiteral
	|	vs=nullLiteral
	|   vs=variableCallExpr

	)
	;

enumerationSpecification returns [ValueSpecification vs]
	:
	{
		context = IContext.ENUMERATION;
	}
	(
		ident:IDENT {  //es =  CreationHelper.createEnumerationSpecification(ident.getText()); 
		vs =  CreationHelper.createStringExpression(ident.getText());
		}
	)
	;


// moved sign from here to each subrule.
numberLiteral returns [LiteralSpecification ls]
	:
	{
		context = IContext.NUMBER_LITERAL;
	}
	(
	 
	 
	  ls=realLiteral 		 
	 | ls=integerLiteral 
	 | ls=unlimitedLiteral
	
	)
	;


// Francois: Moved sign management here
integerLiteral returns [LiteralInteger li]
	:
	{
		context = IContext.INTEGER_LITERAL;
	}
	(
	
			(((PLUS | m1:MINUS)? i:DECIMAL_STRING) { 
				String sign = (m1 == null)? "": "-";
				li = CreationHelper.createLiteralInteger(Integer.parseInt(sign + i.getText())) ;
			})
		|	(((PLUS | m2:MINUS)? j:HEXADECIMAL_STRING) { 
			 int val = (m2==null)?intFromHexaString(j.getText()): -intFromHexaString(j.getText());
			 li = CreationHelper.createLiteralInteger(val) ; 
			 }
		)
		|	(((PLUS | m3:MINUS)? k:BINARY_STRING) { 
			int val  = (m3==null)? intFromBinaryString(k.getText()): - intFromBinaryString(k.getText());
			li =CreationHelper.createLiteralInteger(val) ; 
			}
		)
	)
	;
	

unlimitedLiteral returns [LiteralUnlimitedNatural lun]
	:
	{
		context = IContext.UNLIMITED_LITERAL;
		LiteralInteger li = null;
		lun = null;
	}
	(
		(i:STAR | li=integerLiteral)
		      { 
		      	String s = (i != null)?i.getText(): li.getValue() + "";
		      	if (s.equals("*")){
		      	 lun = CreationHelper.createLiteralUnlimitedNatural(-1);
		      	} else {
		      	 if (li.getValue() < 0)
		      	  throw new RecognitionException("Unlimited Naturals are positiv or null");
		      	 else
		      	 lun = CreationHelper.createLiteralUnlimitedNatural(Integer.parseInt(s)) ;
		      	}
			  }
	)
	;
	

// Francois:
// 1- I could't get the exponent thing work properly, because of the optional sign.
// Antlr was messing with IDENT, therefor i removed EXPONENT, Put IDENT
// and check if the whole is a correct Java Double (it does match the VSL Real)
// Also removed the scientific real rule for, a scientific real is juste a real
// with an exponent behind.
// 2- moved sign here.

realLiteral returns [LiteralReal lr]
	:
	{
		context = IContext.REAL_LITERAL;
	}
	(
	 ((PLUS | m:MINUS)?  (a:DECIMAL_STRING DOT b:DECIMAL_STRING (e:IDENT )? ))
	    
	   { 
	   	String sign = (m == null)? "": "-";
	   	String expo = (e == null)? "": e.getText();
	   	try {
	   	lr=CreationHelper.createLiteralReal(Double.parseDouble(sign + a.getText() + "." +  b.getText() + expo)) ;
	   	} catch (Exception exn){
	   		throw new RecognitionException("not a correct scientific Real");
	   	}
	 } 
	)
	;
	


	
	
booleanLiteral returns [LiteralBoolean lb]
	:
	{
		context = IContext.BOOLEAN_LITERAL;
	}
	(
		TRUE { lb =  CreationHelper.createLiteralBoolean(true); }
	|	FALSE { lb =  CreationHelper.createLiteralBoolean(false); }
	)
	;



nullLiteral returns [LiteralNull ln]
	:
	{
		context = IContext.NULL_LITERAL;
	}
	(
		NULL { ln = CreationHelper.createLiteralNull(); }
	)
	;
	

// string literal
stringLiteral returns [LiteralString ls]
	: 
	{
		context = IContext.STRING_LITERAL;
	}
	(
	
		 s:STRING_TEXT  { ls = CreationHelper.createLiteralString(s.getText()) ;}
	)
	;
	

// default literal	
defaultLiteral returns  [LiteralDefault ld]
	:
	{
		context = IContext.DEFAULT_LITERAL;
	}
	(
		"-" {  ld = CreationHelper.createLiteralDefault(); }
	)
	;	

	
// datetime literal
// Francois: completed to regnonize time date day.
// Had to replace date and time as one token as 
// "time date" would not be recognized (because of skiped whitespace). 
datetimeLiteral returns  [LiteralDateTime ld]
	:
	{
		VSLDate c2 = null;
		context = IContext.DATETIME_LITERAL;
		VSLDate c1 = null;
		VSLDate c3 = null;
	}
	(	
	SHARP
	(	(c1=timeStr	(c2=dateStr)? (c3=dayStr)? )  {
									if (c2 != null){
		                             c1.year =  c2.year;
									 c1.month =  c2.month;
									 c1.dayOfMonth = c2.dayOfMonth;
									} 
									if (c3 != null) {
									 c1.dayOfWeek = c3.dayOfWeek;	
									}
		                          }
	|	(c1=dateStr	(c2=dayStr)?) {
		                            if (c2 != null){
		 							 c1.dayOfWeek = c2.dayOfWeek;
		                            }
								 }
	|	(c1=dayStr)
	)
	SHARP
	)
	  {
			ld = CreationHelper.createLiteralDateTime(c1) ;

	   }
	;

// francois: TIME is now a token
timeStr returns [VSLDate c]
	:
	{
		context = IContext.TIME_STR;
		c = new VSLDate();
	    String h,m,s,cs = "";
	}
	
	t:TIME { 
		try {
		c.parseTime(t.getText());
		} catch (Exception e){
		  throw new  RecognitionException(e.getMessage());
		}
	}
	;
	
hour returns [String s]
	:
	{
		context = IContext.HOUR;
	}
	(
		in:DECIMAL_STRING
		{
			int value = Integer.valueOf(in.getText()).intValue();
			if(value > 23 || value < 0) {
				error("error!!!!! not an hour : "+in.getText());	
			}
			s = in.getText();
		}
	)
	;
	
minute returns [String s]
	:
	{
		context = IContext.MINUTE;
	}
	(
		in:DECIMAL_STRING	
		{
			int value = Integer.valueOf(in.getText()).intValue();
			if(value > 59 || value < 0) {
				error("error!!!!! not a minute : "+in.getText());	
			}
			s = in.getText();
		}
	)
	;
	
second returns [String s]
	:	
	{
		context = IContext.SECOND;
	}
	(
		in:DECIMAL_STRING
		{
			int value = Integer.valueOf(in.getText()).intValue();
			if(value > 59 || value < 0) {
				error("error!!!!! not a second : "+in.getText());	
			}
			s = in.getText();
		}
	)
	;

centisec returns [String s]
	:	
	{
		context = IContext.CENTISEC;
	}
	(
		in:DECIMAL_STRING	
		{
			int value = Integer.valueOf(in.getText()).intValue();
			if(value > 99 || value < 0) {
				error("error!!!!! not a centisecond : "+in.getText());	
			}
			s = in.getText();
		}
	)
	;

// francois: DATE is now a token
dateStr returns [VSLDate c]
	:
	{
		context = IContext.DATE_STR;
		c = new VSLDate();
		String y,m,d = "";

	}
	(
	 date:DATE {
	 	try {
	 		c.parseDate(date.getText());
	 	} catch (Exception e) {
	 	 throw new RecognitionException(e.getMessage());
	 	}
	 }
	)
	;

year returns [String s]
	:
	{
		context = IContext.YEAR;
	}
	(
		in:DECIMAL_STRING	
		{
			int value = Integer.valueOf(in.getText()).intValue();
			if(value > 9999 || value < 0) {
				error("error!!!!! not a year : "+in.getText());	
			}
			s = in.getText();
		}
	)
	;

month returns [String s]
	:
	{
		context = IContext.MONTH;
	}
	(
		in:DECIMAL_STRING	
		{
			int value = Integer.valueOf(in.getText()).intValue();
			if(value > 12 || value < 1) {
				error("error!!!!! not a month : "+in.getText());	
			}
			s = in.getText();
		}
	)
	;

dayOfMonth returns [String s]
	:
	{
		context = IContext.DAY_OF_MONTH;
	}
	(
		in:DECIMAL_STRING	
		{
			int value = Integer.valueOf(in.getText()).intValue();
			if(value > 31 || value < 1) {
				error("error!!!!! not a day of month : "+in.getText());	
			}
			s = in.getText();
		}
	)
	;

dayStr returns [VSLDate c]
	:
	{
		context = IContext.DAY_STR;
		c = new VSLDate();
		
	}
	(
		i:DAY {   String s = i.getText();
			      if (s.equals("Mon")){
			      	c.dayOfWeek = VSLDate.DayOfWeek.MONDAY;
			      }  else if (s.equals("Tue")){
			      c.dayOfWeek = VSLDate.DayOfWeek.TUESDAY;
			      } else if (s.equals("Wed")){
			      	c.dayOfWeek = VSLDate.DayOfWeek.WEDNESDAY;
			      } else if (s.equals("Thr")){
			      	c.dayOfWeek = VSLDate.DayOfWeek.THURSDAY;
			      } else if (s.equals("Fri")){
			      	c.dayOfWeek = VSLDate.DayOfWeek.FRIDAY;
				  } else if (s.equals("Sat")) {
				 	c.dayOfWeek = VSLDate.DayOfWeek.SATURDAY;
				  } else {
					c.dayOfWeek = VSLDate.DayOfWeek.SUNDAY;
				  }
		       } 
	)
	;


nowStr returns [String s]
	:
	{
		context = IContext.NOW;
		s = "now";
	}
	(
		"now"  
	)
	;	


// interval

interval returns [IntervalSpecification is]
	:
	{
		context = IContext.INTERVAL;
		ValueSpecification min = null, max = null;
		ValueSpecification[] interval = null;
	}
	(
		( brack1:LBRACK | RBRACK )
		(
			(		
				min=intervalBound	 	
				DOTDOT
				max=intervalBound
			)
		)
		( brack2:RBRACK | LBRACK )
	) {
	 boolean lowerOpen = ( brack1 != null)? false: true;
	 boolean upperOpen = (brack2 != null)? false: true;
	 if (interval == null){
	 	 is = CreationHelper.createIntervalSpecification(lowerOpen, upperOpen, min, max);
	  } else {
    	is = CreationHelper.createIntervalSpecification(lowerOpen, upperOpen, interval[0], interval[1]);
	  }	
	}
	;

intervalBound returns [ValueSpecification vs]
	:
	{
		context = IContext.INTERVAL_BOUND;
	}
	(
		 vs = literalIntervalBound 
	   | vs = tupleIntervalBound 
	   | vs = choiceIntervalBound 
	   | vs = expressionIntervalBound
	)
	;
	
literalIntervalBound returns [ValueSpecification vs]
	:
	{
		context = IContext.LITERAL_INTERVAL_BOUND;
	}
	(
		vs = numberLiteral | vs = datetimeLiteral
	)
	;

tupleIntervalBound returns [ValueSpecification vs]
	:
	{
		context = IContext.TUPLE_INTERVAL_BOUND;
	}
	(
		vs = tuple
	)
	;
	
choiceIntervalBound returns [ValueSpecification vs]
	:
	{
		context = IContext.CHOICE_INTERVAL_BOUND;
	}
	(
		vs = choice
	)
	;

expressionIntervalBound returns [ValueSpecification vs]
	:
	{
		context = IContext.EXPRESSION_INTERVAL_BOUND;
	}
	(
		vs = expression
	)
	;


// collection

collection returns [CollectionSpecification cs]
	:
	{
		context = IContext.COLLECTION;
		java.util.ArrayList<ValueSpecification> lst = null;
	}
	(
		LCURLY
		(lst= valueSpecificationList)? // literalList
		RCURLY
		(LCURLY unlimitedLiteral RCURLY)? // on en fait quoi ce ca???
		 {
		  if (lst== null)
		   lst = new java.util.ArrayList<ValueSpecification>();
		  cs = CreationHelper.createCollection(lst);	
		 }
	)
	;
	
// paske les truc * c'est *$ a recuperer.
valueSpecificationList returns [java.util.ArrayList<ValueSpecification> lst]
	:
	{ 
		lst = new java.util.ArrayList<ValueSpecification>();
		ValueSpecification ls = null;
		java.util.ArrayList<ValueSpecification> rec = null;
	} (
	 (ls = valueSpecification  (COMMA (rec = valueSpecificationList ))?)
	{ 
		 lst.add(ls) ;
		 if (rec != null)
		  lst.addAll(rec);
	}
	)
 ;
 


// tuple
tuple returns [TupleSpecification ts]
	:
	{
		context = IContext.TUPLE;
		java.util.ArrayList<TupleItemValue> lst = null;
	}
	(
		LPAREN
		lst=tupleItemList
		RPAREN
		{ 
		 ts = CreationHelper.createTuple(lst);
		}
	)
	;

tupleItemList returns [java.util.ArrayList<TupleItemValue> lst]
	:
	{ 
		lst = new java.util.ArrayList<TupleItemValue>();
		TupleItemValue ti = null;
		java.util.ArrayList<TupleItemValue> rec = null;
	} 
     (ti = tupleItem  (COMMA (rec = tupleItemList ))?)
	{ 
		 lst.add(ti) ;
		 if (rec != null)
		  lst.addAll(rec);
	 }
;
	
tupleItem returns [ TupleItemValue tiv ]
	:
	{
		context = IContext.TUPLEITEM;
		ValueSpecification vs = null;
	}
	(
		(
		(id:IDENT
		ASSIGN)?
		)
		
		// changed the rule to match the spec.
		vs = valueSpecification
		
		 { 
		 	String tname = (id == null)? "": id.getText();
		 	tiv = CreationHelper.creaTupleItemValue(tname, vs);
		 }
	)
	;



// choice
// Francois - july 10 2007
// Modified choice to accept choice as value and modified the way tuple was handlded.
// The Choice rule still not allow the chosenAlternativ to be optional. 

choice returns [ChoiceSpecification cs]
	:
	{
		context = IContext.CHOICE;
		java.util.ArrayList<TupleItemValue> lst = null;
		String name = "";
		ValueSpecification vs = null;
		
	}
	(
		
		(name = chosenAlternativeName
		LPAREN
		(	
		//	(vs=literal | vs=choice | vs=collection 
		//	| vs=interval | vs=expression ) 
			lst=tupleItemList
			| vs = valueSpecification
			
			
			
		)
		RPAREN)
		{
			name = (name == null)? "-": name;
			if (vs != null){
				cs = CreationHelper.createChoiceSpecification(name, vs);
			} else {
				cs = CreationHelper.createChoiceSpecification(name, lst);
			}
	    }
	)
	;
	

chosenAlternativeName returns [ String s ]
	:
	{
		//context = IContext.CHOSEN_ALTERNATIVE_NAME;
	}
	(
		id:IDENT { s = id.getText(); }
	)
	;

 
// francois july 10 2007: moved condition to here for it wouldn't be recognized.
expression returns [ValueSpecification vs]
	:
	{
		context = IContext.EXPRESSION;
		ValueSpecification ifTrue =null, ifFalse = null, e = null;
		String name = null;
		java.util.ArrayList<ValueSpecification> lst = null;
		ValueSpecification opCall = null;
		ValueSpecification left = null;
		ValueSpecification right = null;
		String symbol = null;
	}
	
	(
	   (vs=literal DOT name=operationName LPAREN (lst=argumentValueList)? RPAREN )
			  {  if (name != null) vs = CreationHelper.createOperationCallExpression(vs ,name, lst) ; } 
	   |  ( vs = variableCallExpr 
		   (DOT	name=operationName LPAREN ( lst=argumentValueList)? RPAREN )? )
			 {if (name != null) vs = CreationHelper.createOperationCallExpression(vs ,name, lst) ; } 
			
		| (vs = variableDeclaration 
		  (DOT name=operationName LPAREN (lst=argumentValueList)? RPAREN)? )
			  {  if (name != null) vs = CreationHelper.createOperationCallExpression(vs ,name, lst) ; } 

		
		|(((LPAREN 
		      e=valueSpecification
		  RPAREN  q:QUESTION (ifTrue=ifTrueExpr)? COLON (ifFalse=ifFalseExpr)?)
		    (DOT name=operationName LPAREN (lst=argumentValueList)? RPAREN)? 
		   )
			
		{
			context = IContext.COND_EXPR;
			
			String msg = "";
			if (e == null) msg += "Missing condition";
			if (e == null) msg += "Condition can only be a variable declaration, a variable call expression or a property call";
			if (ifTrue == null) msg = msg + " missing consequence";
			if (ifFalse == null) msg = msg + " missing alternant";
			
			if (msg.length() != 0) 
				throw new RecognitionException(msg);
			
			vs = CreationHelper.createConditionalExpression(e, ifTrue, ifFalse);
		   
		   if (name != null) vs = CreationHelper.createOperationCallExpression(vs ,name, lst) ;
		} 
		 )
	)
	;


// variableCall expression
variableCallExpr returns [Expression vs]
	:
	{
		context = IContext.NAME_EXPRESSION;
		// context = IContext.VARIABLE_CALL_EXPR;
		String s = null;
		String name = "";
		java.util.ArrayList<ValueSpecification> lst = null;
	}
	(
	   s = nameExpression { vs = CreationHelper.createStringExpression(s); }
	)
	;


// variableDeclaration expression
// Francois: Added Assign.
variableDeclaration returns [Variable v]
	:
	{
		context = IContext.VARIABLE_DECLARATION;
		String[] name = null;
		String typName = "";
		VariableDirectionKind dir = null;
		ValueSpecification vs = null;
	}
	(
		(dir=variableDirection name=variableName (COLON typName=typeName) (ASSIGN vs=valueSpecification)?)
		{
			v = CreationHelper.createVariable(name[1], name[0], dir, typName, vs);
	    }
	)
	;

variableDirection returns [VariableDirectionKind dir]
	:
	{
		context = IContext.VARIABLE_DIRECTION;
	}
	(
		IN_DIR { dir = VariableDirectionKind.IN_LITERAL;}
	|	OUT_DIR { dir = VariableDirectionKind.OUT_LITERAL;}
	|	INOUT_DIR { dir = VariableDirectionKind.INOUT_LITERAL;}
	)
	;
	
nameExpression returns[String name]
:
{
	String s2 = null;
}
	(s1:IDENT (DOT s2=nameExpression)?)
	{
		name = s1.getText();
		if (s2 != null)
		 name += "." + s2;
		
	}
;
	
variableName returns [String[] s]
	:
	{
		context = IContext.VARIABLE_NAME;
		s = new String[2];
		String ns = "";
	}
	(
		((ns=namespace DOT)? id:IDENT)
		{
			 s[0] = ns;
			 
			 
			 s[1] = id.getText(); 
		}
	)
	;

namespace returns [String s]
	:
	{
		context = IContext.NAMESPACE;
	}
	(
		id:IDENT { s = id.getText(); }
	)
	;

typeName returns [String s]
	:
	{
		context = IContext.TYPE_NAME;
	}
	(
		id:IDENT { s = id.getText();}
	)
	;


initExpr returns [ValueSpecification vs]
	:
	{
		context = IContext.INIT_EXPR;
	}
	(
		vs=valueSpecification
	)
	;


operationCallExpr returns [OperationCallExpression oce]
	:
	{
		context = IContext.OPERATION_CALL_EXPR;
		String name = "";
		java.util.ArrayList<ValueSpecification> lst = null;
		ValueSpecification right, left = null;
		
		
	}
	(
		(
			left=internalValueSpecification
			name=operationSymbol
			right=internalValueSpecification
		)
		{
			lst = new java.util.ArrayList<ValueSpecification>();
			lst.add(right);
			oce = CreationHelper.createOperationCallExpression(left, name, lst); 
		}
	)
	;
	
argumentValueList returns [java.util.ArrayList<ValueSpecification> lst]
	:
	{ 
		lst = new java.util.ArrayList<ValueSpecification>();
		ValueSpecification vs = null;
		java.util.ArrayList<ValueSpecification> rec = null;
	} 
	 (vs = argumentValue  (COMMA (rec = argumentValueList ))?)
	{ 
		 lst.add(vs) ;
		 if ( rec != null)
		  lst.addAll(rec);
	}
	
	;

operationName returns [String s]
	:
	{
		context = IContext.OPERATION_NAME;
	}
	(
		id:IDENT { s = id.getText(); }
	)
	;
	
operationSymbol returns [String s]
	:
	{
		context = IContext.OPERATION_SYMBOL;
	}
	(
		id:PLUS { s = id.getText(); } 
		| id1:MINUS { s = id1.getText(); }
		| id2:LE { s = id2.getText(); }
		|  id3:LT { s = id3.getText(); }
		|  id4:GE { s = id4.getText(); }
		|  id5:GT { s = id5.getText(); }
		|  id6:EQUAL { s = id6.getText(); }
		|  id7:DIFF { s = id7.getText(); }
		|  id8:DIV { s = id8.getText(); }
		|  id9:STAR { s = id9.getText(); }
		|  id10:MOD { s = id10.getText(); }
	)
	;

argumentValue returns [ValueSpecification vs]
	:
	{
		context = IContext.ARGUMENT_VALUE;
	}
	(
		vs=valueSpecification
	)
	;

	



ifTrueExpr returns [ValueSpecification vs]
	:
	{
		context = IContext.IF_TRUE_EXPR;
	}
	(
		vs=valueSpecification
	)
	;

ifFalseExpr returns [ValueSpecification vs]
	:
	{
		context = IContext.IF_FALSE_EXPR;
	}
	(
		vs=valueSpecification
	)
	;
	
// ====  Time expression
	
// <time-expression> ::= <duration-expr> | <instant-expr> | <jitter-expr>
timeExpression returns [TimeExpression te]
 { 
 	 te = null;
 	 context = IContext.TIME_EXPR;
 }
 :
 te=durationOrInstantExpression
 |te=jitterExpression
;


// special rule for antlr would recognize a literal for a[i]
protected obsExpressionWithOccurIndex returns [ObsCallExpression oce]
{
  ValueSpecification occurIndex = null;
  ValueSpecification whenExpr = null;
  context = IContext.TIME_EXPR;
}
:
 (id:IDENT LBRACK (occurIndex=valueSpecification RBRACK) 
         (WHEN whenExpr=valueSpecification)?) 
      {

      		oce = CreationHelper.createObsCallExpression(id.getText(), 
      												occurIndex, 
      												whenExpr);

      	   		context = IContext.SINGLE_OBS_EXPR;
      } 
 {
 	
 }
;

obsExpression returns [ObsCallExpression oce]
{
  ValueSpecification whenExpr = null;
  context = IContext.OBS_EXPRESSION;
}
:
 oce=obsExpressionWithOccurIndex
 |(id:IDENT (WHEN whenExpr=valueSpecification)?) 
      {
       	oce = CreationHelper.createObsCallExpression(id.getText(), 
      												null, 
      												whenExpr);
        context = IContext.SINGLE_OBS_EXPR;
      }
  
;

// Duration and Instant Expression are way to close for antlr to differentiate them.
// Hence the rule is commune.
// When in form (obs when expr - obs), antlr does parse (expr - obs) as valueSpecification,
// hence, the rule (LPAREN obsExpression (m:MINUS | p:PLUS) obsExpression RPAREN)
// does not work when there is a when for the first obsExpression.
// This explain the two other rule for that special case. 
// The need with the predicate whenAdterRBRACK comes because antlr never test
// the presence of WHEN and trigger those special rule when matching (obs[i] - obs)
// but still try to match WHEN later on.
durationOrInstantExpression returns [TimeExpression te]
{
	te = null;
	ValueSpecification afterWhenExpr = null;
	ValueSpecification occurIndex = null;
  	ValueSpecification whenExpr = null;
  	ObsCallExpression right = null;
  	ObsCallExpression left = null;
  	context = IContext.OBS_EXPRESSION;
}
:
 right=obsExpression { te =CreationHelper.createTimeExpression(right); }
 | { whenAfterRBRACK() }? 
  (
   LPAREN  id:IDENT LBRACK occurIndex=valueSpecification RBRACK 
  		   WHEN afterWhenExpr=valueSpecification RPAREN
  )
  {
  	
  	context = IContext.OBS_EXPRESSION;
  if (! (afterWhenExpr instanceof OperationCallExpression))
  	throw new RecognitionException ("expecting symbol + (for instant) or - ");
  	String symbol = ((OperationCallExpression)afterWhenExpr).getOperation(); 
  	if (! (symbol.equals("+") || symbol.equals("-"))) {
  	 throw new RecognitionException ("expecting symbol + (for instant) or - for duration but found " + symbol );
  	}

	OperationCallExpression opCall = (OperationCallExpression)afterWhenExpr;
	whenExpr = (ValueSpecification)opCall.getArgument().get(0);
	
	Element leftArg = (Element)opCall.getArgument().get(1);
	
	if (leftArg instanceof TimeExpression)
		leftArg = (ObsCallExpression)((TimeExpression)leftArg).getObsExpr().get(0);
	
	if (! ( leftArg instanceof  ObsCallExpression) && ! ( leftArg instanceof  StringExpression))
				 	throw new RecognitionException ("expecting Obs Call Expression after " + symbol + " found " + leftArg.eClass().getName());
	
	if (leftArg instanceof StringExpression)
 		right = CreationHelper.createObsCallExpression(((StringExpression)leftArg).getName(), 
      												null, 
      												null);
    else   												
		right = (ObsCallExpression)leftArg;
	
	left = CreationHelper.createObsCallExpression(id.getText(), 
      												occurIndex, 
      												whenExpr);
    
    if (symbol.equals("-")){
    	te = CreationHelper.createDurationExpression(left, right);
    	context = IContext.DURATION_EXPR;
    } else {
    	te = CreationHelper.createInstantExpression(left, right);
    	context = IContext.INSTANT_EXPR;
    	
    }	
  }
| (LPAREN  id2:IDENT WHEN afterWhenExpr=valueSpecification RPAREN)
  {

  context = IContext.OBS_EXPRESSION;
  if (! (afterWhenExpr instanceof OperationCallExpression))
  	throw new RecognitionException ("expecting symbol + (for instant) or - ");
  	String symbol = ((OperationCallExpression)afterWhenExpr).getOperation(); 
  	if (! (symbol.equals("+") || symbol.equals("-"))) {
  	 throw new RecognitionException ("expecting symbol + (for instant) or - for duration but found " + symbol );
  	}

	OperationCallExpression opCall = (OperationCallExpression)afterWhenExpr;
	whenExpr = (ValueSpecification)opCall.getArgument().get(0);
	
	Element leftArg = (Element)opCall.getArgument().get(1);
	
	if (leftArg instanceof TimeExpression)
		leftArg = (ObsCallExpression)((TimeExpression)leftArg).getObsExpr().get(0);
		
	if (! ( leftArg instanceof  ObsCallExpression) && ! ( leftArg instanceof  StringExpression))
				 	throw new RecognitionException ("expecting Obs Call Expression after " + symbol + " found " + leftArg.eClass().getName());
	if (leftArg instanceof StringExpression)
 		right = CreationHelper.createObsCallExpression(((StringExpression)leftArg).getName(), 
      												null, 
      												null);
    else   												
		right = (ObsCallExpression)leftArg;
	
	left = CreationHelper.createObsCallExpression(id2.getText(), 
      												occurIndex, 
      												whenExpr);
    
    if (symbol.equals("-")){
    	te = CreationHelper.createDurationExpression(left, right);
    	context = IContext.DURATION_EXPR;
    } else {
    	te = CreationHelper.createInstantExpression(left, right);
    	context = IContext.INSTANT_EXPR;
    	
    }
  }
| (LPAREN left=obsExpression (m:MINUS | p:PLUS) right=obsExpression RPAREN)
  { 
  	context = IContext.OBS_EXPRESSION;
  	if (m != null){
  		te = CreationHelper.createDurationExpression(left, right);
  		context = IContext.DURATION_EXPR;
  	}
  	else {
  		te = CreationHelper.createInstantExpression(left, right);
  		context = IContext.INSTANT_EXPR;
  	}
  }
;


//<jitter-expr> ::= ( 'jitter(' <instant-obs-expr> ')' ) | ( 'jitter(' <instant-obsexpr>
//',' <instant-obs-expr> ')' )
jitterExpression returns [JitterExpression je]
{
	 je = null;
	 ObsCallExpression obsExpr = null;
	 ObsCallExpression afterComma = null;
	  context = IContext.JITTER_EXPR;
}
: 
 (JITTER LPAREN obsExpr=obsExpression ( COMMA afterComma=obsExpression)? RPAREN) 
 { 
 	// TODO: check that durationOrInstantExpression does not return a duration 
 	je = CreationHelper.createJitterExpression(obsExpr, afterComma);
 	context = IContext.JITTER_EXPR;
 }
;

// <obs-call-expression> ::= <instant-obs-expr> | <duration-obs-expr>
obsCallExpression returns [ObsCallExpression oce]
{
	 oce = null;
} 
 :
 obsExpression
;