// $ANTLR 2.7.6 (2005-12-22): "resources/grammars/VSL_Parser.g" -> "VSLParser.java"$

	/*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
   
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   - added, removed and modified many rules to fit with the BNF and 
 *				- Added VSL model construction
 *******************************************************************************/
package com.cea.nfp.parsers.antlr;

import com.cea.nfp.parsers.texteditor.vsldatatypes.IContext;
import VSL.*;
import VSL.util.*;
import VSL.Variable;
import VSL.TimeExpression;
import org.eclipse.uml2.uml.*;
import com.thalesgroup.marte.vsl.CreationHelper;
import com.thalesgroup.marte.vsl.VSLDate;

public interface VSLTokenTypes {
	int EOF = 1;
	int NULL_TREE_LOOKAHEAD = 3;
	int DATE = 4;
	int TIME = 5;
	int MOD = 6;
	int DOT = 7;
	int DOTDOT = 8;
	int LBRACK = 9;
	int RBRACK = 10;
	int LCURLY = 11;
	int RCURLY = 12;
	int COMMA = 13;
	int COLON = 14;
	int STAR = 15;
	int DECIMAL_STRING = 16;
	int BINARY_STRING = 17;
	int HEXADECIMAL_STRING = 18;
	int QUOTE = 19;
	int DAY = 20;
	int RPAREN = 21;
	int LPAREN = 22;
	int ASSIGN = 23;
	int IDENT = 24;
	int SHARP = 25;
	int PLUS = 26;
	int MINUS = 27;
	int LE = 28;
	int LT = 29;
	int GE = 30;
	int GT = 31;
	int EQUAL = 32;
	int DIFF = 33;
	int DIV = 34;
	int TRUE = 35;
	int FALSE = 36;
	int NULL = 37;
	int STRING_TEXT = 38;
	int IN_DIR = 39;
	int OUT_DIR = 40;
	int INOUT_DIR = 41;
	int JITTER = 42;
	int WHEN = 43;
	// "-" = 44
	int LITERAL_now = 45;
	int QUESTION = 46;
}
