/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: BadTypeException.java,v 1.3 2007/10/15 09:30:05 fnizou Exp $
 */
package com.cea.nfp.parsers.modelgenerator;

import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Type;

/**
 * Exception thrown when a VSL Expression is not typed correctly
 * 
 * @author T0081227 Francois NIZOU - 7 aot 07
 * 
 */
public class BadTypeException extends TypeOrLinkException {

	private static final long serialVersionUID = 5199790657418024931L;

	public BadTypeException(String name, DataType expected) {
		super("no reference found for name " + name + " of datatype "
				+ expected.getName());
	}

	public BadTypeException(Type type) {
		super("the type " + type.getName()
				+ " is not a correct type or the expected type");
	}

	public BadTypeException(Type type, DataType exprected) {
		super("found type " + type.getName() + " , expected type is: "
				+ exprected.getName());
	}

}
