/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: IDecideStrategy.java,v 1.3 2007/10/15 09:30:05 fnizou Exp $
 */
package com.cea.nfp.parsers.modelgenerator;

import java.util.ArrayList;

/**
 * This interface is an implementation of the pattern strategy.
 * Its implementation is used during Linking and Typing process to resolv
 * multiple possibilities. E.g when a name may refer to different UML Element.
 * @author T0081227 Francois NIZOU - 7 aot 07 
 *
 */
public interface IDecideStrategy {

	/**
	 * 
	 * @param choice can be Various UML2 or VSL Element.
	 * @param i (from IContext) is the context where the method is called.
	 * @return an Object from the List of Choice (might return null if no choice fit).
	 */
	public Object decide(ArrayList<Object> choice, int i);
	
}
