/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: VSLFullParser.java,v 1.3 2007/10/30 10:35:43 sdemathieu Exp $
 */
package com.cea.nfp.parsers.modelgenerator;

import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.ValueSpecification;

/**
 * This class is a facade on VSLGenerator, meant to be used without the editor
 * GUI.
 * @author T0081227 Francois NIZOU - 31 juil. 07
 * 
 */
public class VSLFullParser {

	/**
	 * VSLFullParser default constructor
	 */
	public VSLFullParser()
	{// SD 29/10/07
		
	}
	
	/**
	 * Compute a VSL Model from a VSL String. providing Datatype will focus &
	 * Help the processor. In some case, it is the only way to get a non
	 * ambigous result.
	 * 
	 * @param text
	 *            the VSL Expression
	 * @param expected
	 *            the datatype expected, if null, this is equivalent to
	 *            parse(text, facade)
	 * @param facade
	 *            the model facade
	 * @return
	 * @throws Exception
	 *             if parse, link or type has encountered an error.
	 */
	public static ValueSpecification parse(String text, DataType expected,
			IModelFacade facade) throws Exception {
		VSLGenerator vslGen = new VSLGenerator(facade);

		if (expected == null) {
			return parse(text, facade);
		} else {
			String message = vslGen.parseAndValidateProperty(text, expected);
			if (message != null && message.length() > 0)
				throw new Exception(message);
			return vslGen.getVsl();
		}
	}

	/**
	 * Compute a VSL Model from a VSL String.
	 * 
	 * @param text
	 *            text the VSL Expression
	 * @param facade
	 *            facade the model facade
	 * @return
	 * @throws Exception
	 *             if parse, link or type has encountered an error.
	 */
	public static ValueSpecification parse(String text, IModelFacade facade)
			throws Exception {
		VSLGenerator vslGen = new VSLGenerator(facade);
		String message = vslGen.parseAndValidateTypedExpression(text, null);
		if (message != null && message.length() > 0)
			throw new Exception(message);
		return vslGen.getVsl();
	}
}
