/*******************************************************************************
 * Copyright (c) 2007 CEA List.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *******************************************************************************/

package com.cea.nfp.parsers.texteditor;

import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;

/**
 * A simple context type for Property label.
 */
public class LabelContextType extends TemplateContextType {

	/** This context's id */
	public static final String PROPERTYLABEL_CONTEXT_TYPE = "com.cea.papyrus.classdiagram.parsers.texteditor.propertylabel.type";

	/**
	 * The constructor. Creates a new PROPERTY LABEL context type.
	 */
	public LabelContextType() {
		addGlobalResolvers();
	}

	/**
	 * adds a variable resolver to the context type
	 */
	private void addGlobalResolvers() {
		addResolver(new GlobalTemplateVariables.Cursor());
		addResolver(new GlobalTemplateVariables.WordSelection());
		addResolver(new GlobalTemplateVariables.LineSelection());
		addResolver(new GlobalTemplateVariables.Dollar());
		addResolver(new GlobalTemplateVariables.Date());
		addResolver(new GlobalTemplateVariables.Year());
		addResolver(new GlobalTemplateVariables.Time());
		addResolver(new GlobalTemplateVariables.User());
	}

}