/*******************************************************************************
 * Copyright (c) 2007 CEA List.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *******************************************************************************/

package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;

import com.cea.nfp.parsers.messages.NFPMessages;
import com.cea.nfp.parsers.texteditor.vsldatatypes.IContext;
import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst;
import com.cea.nfp.parsers.texteditor.vsldatatypes.VSLComplexTypeUtil;
import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst.VSL;
import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst.MarteLib.PrimitivesTypes;

public class VSL_Choice_CompletionProposal implements
		ICompletionProposalComputer {

	private static DataType dataType;

	private static ArrayList<String> choiceTypeString;

	private static ArrayList<String> alternativeString;

	public void setDataType(DataType datatype) {
		dataType = datatype;
	}

	/**
	 * 
	 * @return returns the string containing choice alternatives of the data
	 *         type for completion
	 */
	
	// TODO: change the way stereotype are tested
	public static void computeTVL_Choice_String() {

		alternativeString = new ArrayList<String>();
		choiceTypeString = new ArrayList<String>();

		// list of alternative datatypes
		ArrayList<Property> alternatives = new ArrayList<Property>();
		Iterator<Property> iter = dataType.getAllAttributes().iterator();
		while (iter.hasNext()) {
			Property currentProp = iter.next();
			if (currentProp.getType() instanceof DataType)
				alternatives.add(currentProp);
		}

		for (int i = 0; i < alternatives.size(); i++) {
			String alternativeTemp = alternatives.get(i).getName() + "(";
			String choiceTypeTemp = alternatives.get(i).getName() + "(";
			DataType alternativeType = (DataType) alternatives.get(i).getType();

			// alternative is a tupleType or a nfpType
			String compositeType = VSLComplexTypeUtil.getCompositeType(alternativeType);
			if (compositeType != null && compositeType.equals(VSL.STEREOTYPE_TUPLE_TYPE)){
				if (alternativeType.getOwnedAttributes().size() > 0) {
					Iterator<Property> inIter = alternativeType
							.getAllAttributes().iterator();
					while (inIter.hasNext()) {
						Property prop = inIter.next();
						alternativeTemp += prop.getName() + "=";
						if (prop.getDefault() != null)
							alternativeTemp += prop.getDefault();
						alternativeTemp += ",";
						choiceTypeTemp += prop.getName() + ": "
								+ prop.getType().getName() + ", ";
					}
				}

				else {
					alternativeTemp = alternativeType.getName();
				}

				alternativeTemp = alternativeTemp.substring(0, alternativeTemp
						.length() - 1);
				alternativeTemp += ")";
				choiceTypeTemp = choiceTypeTemp.substring(0, choiceTypeTemp
						.length() - 2);
				choiceTypeTemp += ")";
			}

			// alternative is an intervalType
			else if (compositeType != null && compositeType.equals(VSL.STEREOTYPE_INTERVAL_TYPE)){
				alternativeTemp += "[..])";
				choiceTypeTemp += "<interval>)";
			}

			// alternative is a collection
			else if (compositeType != null && compositeType.equals(VSL.STEREOTYPE_COLLECTION_TYPE)){
				alternativeTemp += "{})";
				choiceTypeTemp += "{<collection>})";
			}

			// alternative is a choice
			else if (compositeType != null && compositeType.equals(VSL.STEREOTYPE_CHOICE_TYPE)){
				alternativeTemp += ")";
				choiceTypeTemp += "<choice>)";
				
			} else if (alternativeType.getName().equals(
					PrimitivesTypes.BOOLEAN)) {
				alternativeTemp += ")";
				choiceTypeTemp += "<boolean>)";
			} else if (alternativeType.getName().equals(
					PrimitivesTypes.DATETIME)) {
				alternativeTemp += ")";
				choiceTypeTemp += "<datetime>)";
			}  else if (alternativeType.getName().equals(
					PrimitivesTypes.REAL)) {
				alternativeTemp += ")";
				choiceTypeTemp += "<real>)";
			}  else if (alternativeType.getName().equals(
					PrimitivesTypes.STRING)) {
				alternativeTemp += ")";
				choiceTypeTemp += "<string>)";
			}  else if (alternativeType.getName().equals(
					PrimitivesTypes.INTEGER)) {
				alternativeTemp += ")";
				choiceTypeTemp += "<integer>)";
			} 

			alternativeString.add(i, alternativeTemp);
			choiceTypeString.add(i, choiceTypeTemp);
		}

	}

	/** Text inserted in the editor */
	/*
	 * final static private String[] TVL_Choice_Strings = {
	 * computeTVL_Choice_String(), };
	 */

	/** Text displayed in the information window */
	final static private String[] TVL_Choice_StringsInfo = { NFPMessages.Choice_StringsInfo, };

	/** Text displayed in the completion area window */
	final static private String[] TVL_Choice_StringName = { NFPMessages.Choice_StringName, };

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.cea.papyrus.classdiagram.parsers.texteditor.completionproposals.ICompletionProposalComputer#generateCompletionProposals(int,
	 *      int, java.lang.String)
	 */
	public List<ICompletionProposal> generateCompletionProposals(
			int documentOffset, int selectionRange, String prefix) {
		Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();

		// adds each Completion proposal
		ICompletionProposal proposal = null;
		computeTVL_Choice_String();
		for (int i = 0; i < choiceTypeString.size(); i++) {
			if (choiceTypeString.get(i).startsWith(prefix)) {
				proposal = new CompletionProposal(alternativeString.get(i),
						documentOffset - prefix.length(), prefix.length()
								+ selectionRange, alternativeString.get(i)
								.length() - 1, null, choiceTypeString.get(i),
						null, TVL_Choice_StringsInfo[0]);
				v.add(proposal);
			}
		}
		return v;
	}
}
