/*******************************************************************************
 * Copyright (c) 2007 CEA List.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *******************************************************************************/

package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.List;
import java.util.Vector;

import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

import com.cea.nfp.parsers.messages.NFPMessages;

public class VSL_Collection_CompletionProposal implements ICompletionProposalComputer {
	
	/** Text inserted in the editor */
	final static private String[] TVL_Collection_Strings = {
			"{}",
	};

	/** Text displayed in the information window */
	final static private String[] TVL_Collection_StringsInfo = {
			NFPMessages.Collection_StringsInfo,
	}; 

	/** Text displayed in the completion area window */
	final static private String[] TVL_Collection_StringName = {
		NFPMessages.Collection_StringName,
	};

	
	/*
	 * (non-Javadoc)
	 * @see com.cea.papyrus.classdiagram.parsers.texteditor.completionproposals.ICompletionProposalComputer#generateCompletionProposals(int, int, java.lang.String)
	 */
	public List<ICompletionProposal> generateCompletionProposals(int documentOffset, int selectionRange, String prefix) {
		Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
		
		// adds each Completion proposal
		ICompletionProposal proposal = null;
		
		// adds all name (static strings...)
		for(int i=0; i < TVL_Collection_Strings.length; i++) {
			if(TVL_Collection_Strings[i].startsWith(prefix)) {
				proposal = new CompletionProposal(
						TVL_Collection_Strings[i],
						documentOffset-prefix.length(),
						prefix.length()+selectionRange,
						TVL_Collection_Strings[i].length()+1,
						null,
						TVL_Collection_StringName[i],
						null,
						TVL_Collection_StringsInfo[i]);
				v.add(proposal);
			}
		}


		return v;
	}
}


