/*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
   
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   - Completed completion rule according to syntaxe
 *******************************************************************************/

package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.List;
import java.util.Vector;


import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

import com.cea.nfp.parsers.messages.NFPMessages;

/**
 * 
 * @author T0081227 Francois.
 *
 */
public class VSL_DateStr_CompletionProposal implements ICompletionProposalComputer {
	
	// Modified by THALES
	// Francois - july 6 2007, added a choice for <date day>
	
	/** Text inserted in the editor */
	final static private String[] TVL_DateStr_Strings = {
			"#//#",		// space between slashes is mandatory here!!!
			"#// day#"
	};

	/** Text displayed in the information window */
	final static private String[] TVL_DateStr_StringsInfo = {
			NFPMessages.DateStr_StringsInfo,
			NFPMessages.DateStrWithDay_StringsInfo
	}; 

	/** Text displayed in the completion area window */
	final static private String[] TVL_DateStr_StringName = {
			NFPMessages.DateStr_StringName,
			NFPMessages.DateStrWithDay_StringName
	};

	
	/*
	 * (non-Javadoc)
	 * @see com.cea.papyrus.classdiagram.parsers.texteditor.completionproposals.ICompletionProposalComputer#generateCompletionProposals(int, int, java.lang.String)
	 */
	public List<ICompletionProposal> generateCompletionProposals(int documentOffset, int selectionRange, String prefix) {
		Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
		
		// adds each Completion proposal
		ICompletionProposal proposal = null;
		
		// adds all name (static strings...)
		for(int i=0; i < TVL_DateStr_Strings.length; i++) {
			if(TVL_DateStr_Strings[i].startsWith(prefix)) {
				proposal = new CompletionProposal(
						TVL_DateStr_Strings[i],
						documentOffset-prefix.length(),
						prefix.length()+selectionRange,
						TVL_DateStr_Strings[i].length()-3,
						null,
						TVL_DateStr_StringName[i],
						null,
						TVL_DateStr_StringsInfo[i]);
				v.add(proposal);
			}
		}
		return v;
	}
}


