/*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
   
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   - Commented Content assist with no "content"
 *******************************************************************************/

package com.cea.nfp.parsers.texteditor.completionproposals;

/**
 * @author T0081227 francois nizou the july 20 2007.
 */
import java.util.List;
import java.util.Vector;

import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

import com.cea.nfp.parsers.messages.NFPMessages;

public class VSL_Expression_CompletionProposal implements ICompletionProposalComputer {
	
	/** Text inserted in the editor */
	final static private String[] TVL_Expression_Strings = {
//			" ", //$NON-NLS-1$
			"in$:", //$NON-NLS-1$
			"in$: =", //$NON-NLS-1$
//			" ", //$NON-NLS-1$
//			" ", //$NON-NLS-1$
			"()? :", //$NON-NLS-1$
	};

	/** Text displayed in the information window */
	final static private String[] TVL_Expression_StringsInfo = {
//			NFPMessages.VarCallExpr_StringsInfo,
			NFPMessages.VarDeclExpr_StringsInfo,
			NFPMessages.VarDeclWithInitExpr_StringsInfo,
//			NFPMessages.PropCallExpr_StringsInfo,
//			NFPMessages.OpeCallExpr_StringsInfo,
			NFPMessages.CondExpr_StringsInfo,
	}; 

	/** Text displayed in the completion area window */
	final static private String[] TVL_Expression_StringName = {
//			NFPMessages.VarCallExpr_StringName,
			NFPMessages.VarDeclExpr_StringName,
			NFPMessages.VarDeclWithInitExpr_StringName,
//			NFPMessages.PropCallExpr_StringName,
//			NFPMessages.OpeCallExpr_StringName,
			NFPMessages.CondExpr_StringName,
	};

	
	/*
	 * (non-Javadoc)
	 * @see com.cea.papyrus.classdiagram.parsers.texteditor.completionproposals.ICompletionProposalComputer#generateCompletionProposals(int, int, java.lang.String)
	 */
	public List<ICompletionProposal> generateCompletionProposals(int documentOffset, int selectionRange, String prefix) {
		Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
		
		// adds each Completion proposal
		ICompletionProposal proposal = null;
		
		// adds all name (static strings...)
		for(int i=0; i < TVL_Expression_Strings.length; i++) {
			if(TVL_Expression_Strings[i].startsWith(prefix)) {
				proposal = new CompletionProposal(
						TVL_Expression_Strings[i],
						documentOffset-prefix.length(),
						prefix.length()+selectionRange,
						TVL_Expression_Strings[i].length(),
						null,
						TVL_Expression_StringName[i],
						null,
						TVL_Expression_StringsInfo[i]);
				v.add(proposal);
			}
		}


		return v;
	}
}

