/*******************************************************************************
 * Copyright (c) 2007 CEA List.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *******************************************************************************/

/**
 * @author T0081227 francois NIZOU - july 06 2007
 */
package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.List;
import java.util.Vector;


import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

import com.cea.nfp.parsers.messages.NFPMessages;


public class VSL_Interval_CompletionProposal implements ICompletionProposalComputer {
	
	/** Text inserted in the editor */
	final static private String[] TVL_Interval_Strings = {
			"[..]",
			"]..]",
			"[..[",
			"]..[",
	};

	/** Text displayed in the information window */
	final static private String[] TVL_Interval_StringsInfo = {
			NFPMessages.Interval_11_StringsInfo,
			NFPMessages.Interval_01_StringsInfo,
			NFPMessages.Interval_10_StringsInfo,
			NFPMessages.Interval_00_StringsInfo,
	}; 

	/** Text displayed in the completion area window */
	final static private String[] TVL_Interval_StringName = {
		NFPMessages.Interval_11_StringName,
		NFPMessages.Interval_01_StringName,
		NFPMessages.Interval_10_StringName,
		NFPMessages.Interval_00_StringName,
	};

	
	/*
	 * (non-Javadoc)
	 * @see com.cea.papyrus.classdiagram.parsers.texteditor.completionproposals.ICompletionProposalComputer#generateCompletionProposals(int, int, java.lang.String)
	 */
	public List<ICompletionProposal> generateCompletionProposals(int documentOffset, int selectionRange, String prefix) {
		Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
		
		// adds each Completion proposal
		ICompletionProposal proposal = null;
		
		// adds all name (static strings...)
		for(int i=0; i < TVL_Interval_Strings.length; i++) {
			if(TVL_Interval_Strings[i].startsWith(prefix)) {
				proposal = new CompletionProposal(
						TVL_Interval_Strings[i],
						documentOffset-prefix.length(),
						prefix.length()+selectionRange,
						TVL_Interval_Strings[i].length()-3,
						null,
						TVL_Interval_StringName[i],
						null,
						TVL_Interval_StringsInfo[i]);
				v.add(proposal);
			}
		}


		return v;
	}
}


