/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: VSL_Jitter_CompletionProposal.java,v 1.2 2007/10/15 09:30:05 fnizou Exp $
 */
package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/**
 * 
 * @author T0081227 Francois NIZOU - 27 juil. 07
 * 
 */
public class VSL_Jitter_CompletionProposal {

	public List<ICompletionProposal> generateCompletionProposals(
			int documentOffset, int selectionRange, String text) {
		ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();

		// find out if we got an '+' or a '-'
		int indexOfComma = text.indexOf(",");

		String tmpText = text.replace(",", " ");

		// propose to add the '-' or '+' and ')' if needed
		if (indexOfComma == -1)
			proposals.add(generateCommaProposal(documentOffset, selectionRange,
					text));

		return proposals;
	}

	protected ICompletionProposal generateCommaProposal(int documentOffset,
			int selectionRange, String text) {

		boolean endWithParenthese = text.trim()
				.charAt(text.trim().length() - 1) != ')';

		String jitterCompletion = ",";
		String jitterInfo = "jitter expression <instant observation - instant observation>";

		if (endWithParenthese) {
			jitterCompletion += " )";

		}
		if (text.charAt(documentOffset - 1) != ' ') {
			jitterCompletion = " " + jitterCompletion;

		}

		ICompletionProposal proposal = new CompletionProposal(jitterCompletion,
				documentOffset, selectionRange,
				(endWithParenthese) ? jitterCompletion.length() - 1
						: jitterCompletion.length(), null, ", )", null,
				jitterInfo);

		return proposal;
	}
}
