/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: VSL_NameExpressionProposal.java,v 1.4 2007/10/15 09:30:05 fnizou Exp $
 */
package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Observation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TimeObservation;

import VSL.Variable;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;

/**
 * 
 * @author T0081227 Francois NIZOU - 27 juil. 07
 * 
 */
public class VSL_NameExpressionProposal implements ICompletionProposalComputer {

	private IModelFacade facade;

	public VSL_NameExpressionProposal(IModelFacade facade) {
		this.facade = facade;
	}

	public List<ICompletionProposal> generateCompletionProposals(
			int documentOffset, int selectionRange, String prefix) {
		ArrayList<Variable> variables = facade.getVariablesStartWith(prefix);
		ArrayList<EnumerationLiteral> enumerations = facade
				.getEnumerationsByName(prefix, true);
		ArrayList<Property> properties = facade.getPropertiesStartWith(prefix);

		ArrayList<Observation> observations = facade.getObservationsStartWith(prefix);

		ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
		ICompletionProposal proposal = null;

		// enum completion
		for (EnumerationLiteral literal : enumerations) {
			String name = literal.getName();
			Enumeration owner = (Enumeration) literal.getOwner();
			proposal = new CompletionProposal(name, documentOffset
					- prefix.length(), prefix.length() + selectionRange, name
					.length(), null, name, null, "enumeration literal " + name
					+ " from the Enumeation \r\n" + owner.getQualifiedName());
			proposals.add(proposal);
		}

		// property completion
		for (Property property : properties) {

			String qualifiedName = facade.getQualifiedName(property);
			String name = (facade.isLocalProperty(property)) ? property
					.getName() : qualifiedName;

			DataType typeof = facade.typeof(property);
			if (typeof == null)
				continue;

			proposal = new CompletionProposal(name, documentOffset
					- prefix.length(), prefix.length() + selectionRange, name
					.length(), null, name, null, "property " + qualifiedName
					+ " \r\nof type " + typeof.getName());
			proposals.add(proposal);
		}

		// variables

		String currentContextName = facade.getCurrentVariableContextName();
		for (Variable variable : variables) {
			String fqnName = (variable.getContext().getName().length() > 0) ? variable
					.getContext().getName()
					+ "." + variable.getName()
					: variable.getName();
			String name = (variable.getContext().getName()
					.equals(currentContextName)) ? variable.getName() : fqnName;
			proposal = new CompletionProposal(name, documentOffset
					- prefix.length(), prefix.length() + selectionRange, name
					.length(), null, name, null, "Variable " + fqnName
					+ " \r\nof type " + variable.getDataTypeName());
			proposals.add(proposal);
		}

		// observation completion
		for (Observation observation : observations) {
			String name = observation.getName();
			String obsType = (observation instanceof TimeObservation) ? " instant expression"
					: "duration expression";
			proposal = new CompletionProposal(name, documentOffset
					- prefix.length(), prefix.length() + selectionRange, name
					.length(), null, name, null, obsType
					+ " for the Observation " + name);
			proposals.add(proposal);
		}

		return proposals;
	}

}
