/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: VSL_ObsExprExtended_CompletionProposal.java,v 1.2 2007/10/15 09:30:05 fnizou Exp $
 */
package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;

/**
 * 
 * @author T0081227 Francois NIZOU - 27 juil. 07
 * 
 */

public class VSL_ObsExprExtended_CompletionProposal {

	IModelFacade facade = null;

	public VSL_ObsExprExtended_CompletionProposal(IModelFacade facade) {
		this.facade = facade;
	}

	public List<ICompletionProposal> generateCompletionProposals(
			int documentOffset, int selectionRange, String text) {
		ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();

		// find out if we got an '+' or a '-'
		int indexOfPlus = text.indexOf("+");
		int indexOfMinus = text.indexOf("-");
		int index = -1;

		if (indexOfPlus != -1)
			index = indexOfPlus;
		else if (indexOfMinus != -1)
			index = indexOfMinus;

		// propose to add the '-' or '+' and ')' if needed
		if (index == -1)
			proposals.addAll(generateEndOfExprProposal(documentOffset,
					selectionRange, text));

		else {
			// TODO: add completion for left or right
			// if (documentOffset < index) {
			// proposals.addAll(generateLeftProposals(documentOffset,
			// selectionRange, text));
			// }
		}

		return proposals;
	}

	/**
	 * 
	 * @param documentOffset
	 * @param selectionRange
	 * @param text
	 * @return
	 */
	private Collection<ICompletionProposal> generateLeftProposals(
			int documentOffset, int selectionRange, String text) {
		ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();

		int startOfObsName = 1;
		while (text.charAt(startOfObsName) == ' ')
			startOfObsName++;

		int endOfObsName = startOfObsName;
		while (text.charAt(endOfObsName) != ' '
				&& endOfObsName < documentOffset)
			endOfObsName++;

		// if (endOfObsName == documentOffset) { // user is typing Observation
		// ArrayList<Observation> observation =
		// facade.getObservation(text.substring(startOfObsName, endOfObsName));
		//			
		// }

		return proposals;
	}

	/**
	 * 
	 * @param documentOffset
	 * @param selectionRange
	 * @param text
	 * @return
	 */
	protected List<ICompletionProposal> generateEndOfExprProposal(
			int documentOffset, int selectionRange, String text) {
		ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();

		boolean endWithParenthese = text.trim()
				.charAt(text.trim().length() - 1) != ')';

		String durationCompletion = "-";
		String durationInfo = "duration expression <instant observation - instant observation>";
		String instantCompletion = "+";
		String instantInfo = "duration expression <instant observation + duration observation>";

		if (endWithParenthese) {
			durationCompletion += " )";
			instantCompletion += " )";
		}
		if (text.charAt(documentOffset - 1) != ' ') {
			durationCompletion = " " + durationCompletion;
			instantCompletion = " " + instantCompletion;
		}

		ICompletionProposal durationProposal = new CompletionProposal(
				durationCompletion, documentOffset, selectionRange,
				(endWithParenthese) ? durationCompletion.length() - 1
						: durationCompletion.length(), null, "- )", null,
				durationInfo);
		proposals.add(durationProposal);
		ICompletionProposal instantProposal = new CompletionProposal(
				instantCompletion, documentOffset, selectionRange,
				(endWithParenthese) ? instantCompletion.length() - 1
						: instantCompletion.length(), null, "+ )", null,
				instantInfo);

		proposals.add(instantProposal);
		return proposals;
	}
}
