/*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
   
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   - Added completion for observation name
 *     			- Added some completion for OccurIndex and CondExpr
 *******************************************************************************/

package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.List;
import java.util.Vector;

import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

import com.cea.nfp.parsers.messages.NFPMessages;

/**
 * 
 * @author T0081227 Francois NIZOU - 1 aot 07 
 *
 */

// Modified by THALES
// francois, date1 aot 07:
// Added more content assist

public class VSL_ObsExpr_CompletionProposal implements
		ICompletionProposalComputer {

	/** Text inserted in the editor */
	final static private String[] TVL_ObsExpr_Strings = { "]", "when ()" };

	/** Text displayed in the information window */
	final static private String[] TVL_ObsExpr_StringsInfo = {
			NFPMessages.OccObsExpr_StringsInfo,
			NFPMessages.WhenObsExpr_StringsInfo, };

	/** Text displayed in the completion area window */
	final static private String[] TVL_ObsExpr_StringName = {
			NFPMessages.OccObsExpr_StringName,
			NFPMessages.WhenObsExpr_StringName, };

	// Added by THALES
	/**
	 * 
	 * @param documentOffset
	 * @param selectionRange
	 * @param text
	 * @return
	 */
	protected ICompletionProposal whenProposal(int documentOffset,
			int selectionRange, String text) {

		int lbrackIndex = text.lastIndexOf("]", documentOffset);

		ICompletionProposal proposal = null;

		String s = text.substring(lbrackIndex + 1, documentOffset);

		if (s.trim().equals("")) {
			String proposition = "when ";
			if (documentOffset == lbrackIndex + 1)
				proposition = " " + proposition;

			proposal = new CompletionProposal(proposition, documentOffset,
					selectionRange, proposition.length() + 1, null,
					"when condition", null,
					"add a when condition for an Observation Expression");
		} else if ("when".startsWith(s.trim())) {

			proposal = new CompletionProposal("when", lbrackIndex + 1, s
					.length()
					+ selectionRange, "when".length() - 1, null,
					"when condition", null,
					"add a when condition for an Observation Expression");
		}

		return proposal;
	}

	// Added by THALES
	/**
	 * 
	 * @param documentOffset
	 * @param selectionRange
	 * @param txt
	 * @return
	 */
	protected ICompletionProposal indexOccurProposal(int documentOffset,
			int selectionRange, String txt) {

		int indexOfWhen = txt.indexOf("when", documentOffset);

		if (indexOfWhen == -1)
			return null;

		if (txt.substring(documentOffset, indexOfWhen).trim().length() > 0)
			return null;

		String brackets = "[]";
		if (indexOfWhen == documentOffset)
			brackets = brackets + " ";

		ICompletionProposal proposal = new CompletionProposal(brackets,
				documentOffset, selectionRange, 1, null, "occur Index", null,
				"the Occur index of the Observation expression (e.g [Integer])");
		return proposal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.cea.papyrus.classdiagram.parsers.texteditor.completionproposals.ICompletionProposalComputer#generateCompletionProposals(int,
	 *      int, java.lang.String)
	 */
	public List<ICompletionProposal> generateCompletionProposals(
			int documentOffset, int selectionRange, String prefix) {
		Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();

		// adds each Completion proposal
		ICompletionProposal proposal = null;

		ICompletionProposal whenProposal = whenProposal(documentOffset,
				selectionRange, prefix);
		if (whenProposal != null)
			v.add(whenProposal);

		ICompletionProposal indexOccurProposal = indexOccurProposal(
				documentOffset, selectionRange, prefix);
		if (indexOccurProposal != null)
			v.add(indexOccurProposal);

		// adds all name (static strings...)
		for (int i = 0; i < TVL_ObsExpr_Strings.length; i++) {
			if (TVL_ObsExpr_Strings[i].startsWith(prefix)) {
				proposal = new CompletionProposal(TVL_ObsExpr_Strings[i],
						documentOffset - prefix.length(), prefix.length()
								+ selectionRange, TVL_ObsExpr_Strings[i]
								.length() - 1, null, TVL_ObsExpr_StringName[i],
						null, TVL_ObsExpr_StringsInfo[i]);
				v.add(proposal);
			}
		}

		return v;
	}
}
