/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 * $Id: VSL_OperationNormalNotation_CompletionProposal.java,v 1.2 2007/10/15 09:30:05 fnizou Exp $
 */

package com.cea.nfp.parsers.texteditor.completionproposals;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.osgi.internal.resolver.ComputeNodeOrder;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ValueSpecification;

import antlr.RecognitionException;
import antlr.TokenStreamException;

import com.cea.nfp.parsers.antlr.VSLLexer;
import com.cea.nfp.parsers.antlr.VSLParser;
import com.cea.nfp.parsers.modelgenerator.BadTypeException;
import com.cea.nfp.parsers.modelgenerator.BasicDecideStrategy;
import com.cea.nfp.parsers.modelgenerator.IModelFacade;
import com.cea.nfp.parsers.modelgenerator.Linker;
import com.cea.nfp.parsers.modelgenerator.TypeOrLinkException;
import com.cea.nfp.parsers.modelgenerator.Typer;
import com.cea.nfp.parsers.modelgenerator.UnresolvedNameException;

/**
 * Completion proposal for OperationCallExpression with normal notation (E.g
 * exp.op(args))
 * 
 * @author T0081227 Francois NIZOU - 20 juil. 07
 * 
 */
public class VSL_OperationNormalNotation_CompletionProposal implements
		ICompletionProposalComputer {

	private IModelFacade facade;

	public VSL_OperationNormalNotation_CompletionProposal(IModelFacade facade) {
		this.facade = facade;
	}

	/**
	 * 
	 */
	public List<ICompletionProposal> generateCompletionProposals(
			int documentOffset, int selectionRange, String prefix) {
		ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();

		int indexOfDot = prefix.lastIndexOf(".");

		if (indexOfDot == -1)
			return proposals;

		String expression = prefix.substring(0, indexOfDot);
		String partialOpName = prefix
				.substring(indexOfDot + 1, prefix.length());

		// resolve expression datatype
		ArrayList<DataType> datatypes = null;
		try {
			datatypes = resolve(expression);
		} catch (Exception e) {
			return proposals;
		}

		// compute all possible operation of that datatype starting with

		ArrayList<Operation> operations = findOperationStartingWith(
				partialOpName, datatypes);

		// compute proposals
		CompletionProposal proposal = null;

		for (Operation operation : operations) {

			String replacementProposal = operation.getName()
					+ argsToString(operation);
			String operationSignature = computeSignature(operation);

			proposal = new CompletionProposal(replacementProposal,
					documentOffset - partialOpName.length(), partialOpName
							.length()
							+ selectionRange,
					(expression + "." + replacementProposal).length(), null,
					replacementProposal, null, "Operation "
							+ operation.getName() + "\r\n" + operationSignature);
			proposals.add(proposal);
		}
		// partialOpName

		return proposals;
	}

	/**
	 * 
	 * @param operation
	 * @return
	 */
	private String computeSignature(Operation operation) {

		String result = "";

		EList ownedParameters = operation.getOwnedParameters();
		for (int i = 0; i < ownedParameters.size(); i++) {
			Parameter parameter = (Parameter) ownedParameters.get(i);
			if (parameter.getDirection().equals(
					ParameterDirectionKind.RETURN_LITERAL))
				continue;
			String typeName = (parameter.getType() != null) ? parameter
					.getType().getName() : "??";
			if (result.length() == 0)
				result += typeName;
			else
				result += ", " + typeName;
		}
		result = ((DataType) operation.getOwner()).getName() + "."
				+ operation.getName() + "(" + result + ")";

		Parameter returnResult = operation.getReturnResult();
		if (returnResult != null && returnResult.getType() != null)
			result = returnResult.getType().getName() + " " + result;

		return result;
	}

	private String argsToString(Operation operation) {
		String result = "";

		EList ownedParameters = operation.getOwnedParameters();
		for (int i = 0; i < ownedParameters.size(); i++) {
			Parameter parameter = (Parameter) ownedParameters.get(i);
			if (parameter.getDirection().equals(
					ParameterDirectionKind.RETURN_LITERAL))
				continue;
			String paramName = (parameter.getName() != null) ? parameter
					.getName() : "";
			if (result.length() == 0)
				result += paramName;
			else
				result += ", " + paramName;

		}
		result = "(" + result + ")";

		return result;
	}

	/**
	 * 
	 * @param partialOpName
	 * @param datatype
	 * @return
	 */
	private ArrayList<Operation> findOperationStartingWith(
			String partialOpName, ArrayList<DataType> datatypes) {
		ArrayList<Operation> operations = new ArrayList<Operation>();

		for (DataType datatype : datatypes) {
			EList ownedOperations = datatype.getOperations();
			for (Object object : ownedOperations) {
				Operation operation = (Operation) object;
				if (operation.getName().startsWith(partialOpName))
					operations.add(operation);
			}
		}

		return operations;
	}

	/**
	 * 
	 * @param expression
	 * @return
	 * @throws RecognitionException
	 * @throws TokenStreamException
	 * @throws TypeOrLinkException
	 * @throws UnresolvedNameException
	 * @throws BadTypeException
	 */
	private ArrayList<DataType> resolve(String expression)
			throws RecognitionException, TokenStreamException,
			TypeOrLinkException {
		VSLLexer lexer = new VSLLexer(new BufferedReader(new StringReader(
				expression.replace(" ", ""))));
		VSLParser parser = new VSLParser(lexer);
		parser.setValidation(true);
		ValueSpecification vsl = parser.valueSpecification();

		Linker linker = new Linker(facade, new BasicDecideStrategy());
		ValueSpecification linkedVsl = linker.link(vsl, null);
		return Typer.type(linkedVsl, facade);
	}

}
