/*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
   
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   - Added more content assist
 *******************************************************************************/

package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.List;
import java.util.Vector;


import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

import com.cea.nfp.parsers.messages.NFPMessages;

/**
 * 
 * @author T0081227 Francois NIZOU - 1 aot 07 
 *
 */

public class VSL_TimeStr_CompletionProposal implements ICompletionProposalComputer {
	
	// Modified by TGALE
	/** Text inserted in the editor */
	final static private String[] VSL_TimeStr_Strings = {
			"#::#", //$NON-NLS-1$
			"#:: day#", //$NON-NLS-1$
			"#:: // day#" //$NON-NLS-1$
	};

	/** Text displayed in the information window */
	final static private String[] VSL_TimeStr_StringsInfo = {
			NFPMessages.TimeStr_StringsInfo,
			NFPMessages.TimeAndDay_StringsInfo,
			NFPMessages.TimeAndDateAndDay_StringsInfo
	}; 

	/** Text displayed in the completion area window */
	final static private String[] VSL_TimeStr_StringName = {
			NFPMessages.TimeStr_StringName,
			NFPMessages.TimeAndDay_StringName,
			NFPMessages.TimeAndDateAndDay_StringName

	};
	
	/*
	 * (non-Javadoc)
	 * @see com.cea.papyrus.classdiagram.parsers.texteditor.completionproposals.ICompletionProposalComputer#generateCompletionProposals(int, int, java.lang.String)
	 */
	public List<ICompletionProposal> generateCompletionProposals(int documentOffset, int selectionRange, String prefix) {
		Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
		
		// adds each Completion proposal
		ICompletionProposal proposal = null;
		
		// adds all name (static strings...)
		for(int i=0; i < VSL_TimeStr_Strings.length; i++) {
			if(VSL_TimeStr_Strings[i].startsWith(prefix)) {
				proposal = new CompletionProposal(
						VSL_TimeStr_Strings[i],
						documentOffset-prefix.length(),
						prefix.length()+selectionRange,
						VSL_TimeStr_Strings[i].length()-2,
						null,
						VSL_TimeStr_StringName[i],
						null,
						VSL_TimeStr_StringsInfo[i]);
				v.add(proposal);
			}
		}


		return v;
	}
}


