/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: VSL_TupleItem_CompletionProposal.java,v 1.2 2007/10/15 09:30:05 fnizou Exp $
 */

package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;

/**
 * 
 * @author T0081227 Francois NIZOU - 30 juil. 07
 * 
 */
public class VSL_TupleItem_CompletionProposal implements
		ICompletionProposalComputer {

	private static DataType dataType;

	public void setDataType(DataType datatype) {
		dataType = datatype;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.cea.papyrus.classdiagram.parsers.texteditor.completionproposals.ICompletionProposalComputer#generateCompletionProposals(int,
	 *      int, java.lang.String)
	 */
	public List<ICompletionProposal> generateCompletionProposals(
			int documentOffset, int selectionRange, String prefix) {
		ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
		Hashtable<String, Property> properties = new Hashtable<String, Property>();
		for (Object o : dataType.getAllAttributes()) {
			Property property = (Property) o;
			properties.put(property.getName(), property);
		}
		String[] fields = prefix.replaceAll("[)]", "").replaceAll("[(]", "")
				.split(",");
		String startStr = "";
		for (String field : fields) {
			int indexOfEq = field.indexOf("=");
			if (indexOfEq != -1) {
				String name = field.substring(0, indexOfEq).trim();
				properties.remove(name);
			} else {
				startStr = field.trim();
			}

		}
		CompletionProposal proposal;
		for (Property property : properties.values()) {
			if (property.getName().startsWith(startStr)) {
				String proposalStr = property.getName() + "=";
				String replStr = proposalStr.toString();
				int lastIndexOfRParen = prefix.lastIndexOf(")");
				int cursor = replStr.length();
				if (lastIndexOfRParen == -1)
					replStr += " )";
					
				String proposalInfo = "field " + property.getName();
				proposal = new CompletionProposal(replStr, documentOffset - startStr.length(),
						startStr.length() + selectionRange, cursor, null,
						proposalStr, null, proposalInfo);
				proposals.add(proposal);
			}
		}

		return proposals;

	}

}
