/*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
   
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   - Added completion on Datatype, using model input
 *******************************************************************************/

/**
 * @author T0081227 Francois NIZOU - 20 juil. 07 
 * 
 */

package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;
import com.cea.nfp.parsers.texteditor.vsldatatypes.VSLComplexTypeUtil;

// This class now  dynamicly lookup in the model for Datatypes.
public class VSL_TypeName_CompletionProposal implements
		ICompletionProposalComputer {

	private IModelFacade facade;

	public VSL_TypeName_CompletionProposal(IModelFacade facade) {
		this.facade = facade;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.cea.papyrus.classdiagram.parsers.texteditor.completionproposals.ICompletionProposalComputer#generateCompletionProposals(int,
	 *      int, java.lang.String)
	 */
	public List<ICompletionProposal> generateCompletionProposals(
			int documentOffset, int selectionRange, String prefix) {
		Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();

		// adds each Completion proposal
		ICompletionProposal proposal = null;

		ArrayList<DataType> dataTypes = facade.getDataTypesStartWith(prefix);

		for (DataType type : dataTypes) {

			String specialTypeName = VSLComplexTypeUtil.getCompositeType(type);
			specialTypeName = (specialTypeName == null) ? (type instanceof Enumeration)? "(Enumeration)" : "" : "("
					+ specialTypeName + ")";
			String from = facade.getQualifiedName(type);

			proposal = new CompletionProposal(type.getName(), documentOffset
					- prefix.length(), prefix.length() + selectionRange, type
					.getName().length(), null, type.getName(), null,
					"Datatype " + from + " " + specialTypeName);
			v.add(proposal);

		}

		return v;

	}
}
