/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: VSL_infixeOperator_CompletionProposal.java,v 1.2 2007/10/15 09:30:05 fnizou Exp $
 */
package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.List;
import java.util.Vector;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;

/**
 * 
 * @author T0081227 Francois NIZOU - 14 aot 07 
 *
 */
public class VSL_infixeOperator_CompletionProposal implements
		ICompletionProposalComputer {

	private DataType datatype;

	private IModelFacade facade;

	public VSL_infixeOperator_CompletionProposal(DataType type,
			IModelFacade facade) {
		this.datatype = type;
		this.facade = facade;
	}

	public List<ICompletionProposal> generateCompletionProposals(
			int documentOffset, int selectionRange, String prefix) {
		Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
		ICompletionProposal proposal = null;

		EList operations = datatype.getOperations();
		for (Object object : operations) {
			Operation operation = (Operation) object;
			String opName = operation.getName();
			String propStr = opName + " ";
			if (!Character.isLetter(opName.charAt(0))) {

				proposal = new CompletionProposal(propStr, documentOffset
						- prefix.length(), prefix.length() + selectionRange,
						propStr.length(), null, opName, null, computeInfo(
								datatype.getName(), operation));
				v.add(proposal);

			}
		}

		return v;
	}

	private String computeInfo(String name, Operation operation) {
		String s = "operation " + name + " " + operation.getName() + " ";
		EList ownedParameters = operation.getOwnedParameters();
		String returnTypeName = "";
		for (Object object : ownedParameters) {
			Parameter param = (Parameter) object;
			if (!param.getDirection().equals(
					ParameterDirectionKind.RETURN_LITERAL)) {
				s += " " + facade.typeof(param).getName();
			} else {
				returnTypeName = facade.typeof(param).getName();
			}
		}
		s += " : " + returnTypeName;
		return s;
	}

}
