/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: VSL_operationRightOperand_CompletionProposal.java,v 1.2 2007/10/15 09:30:05 fnizou Exp $
 */
package com.cea.nfp.parsers.texteditor.completionproposals;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;
import com.cea.nfp.parsers.texteditor.vsldatatypes.VSLComplexTypeUtil;
import com.cea.nfp.parsers.texteditor.vsldatatypes.VSLLabelCompletionProcessor;
import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst.MarteLib;
import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst.VSL;

/**
 * 
 * @author T0081227 Francois NIZOU - 14 aot 07
 * 
 */
public class VSL_operationRightOperand_CompletionProposal implements
		ICompletionProposalComputer {

	private String op;

	private DataType type;

	private IModelFacade facade;

	private ITextViewer viewer;

	public VSL_operationRightOperand_CompletionProposal(String op,
			DataType type, IModelFacade facade, ITextViewer viewer) {
		this.op = op;
		this.type = type;
		this.facade = facade;
		this.viewer = viewer;

	}

	public List<ICompletionProposal> generateCompletionProposals(
			int documentOffset, int selectionRange, String prefix) {
		EList operations = type.getOperations();
		Operation operation = null;
		for (Object object : operations) {
			Operation tmp = (Operation) object;
			if (tmp.getName().equals(op)) {
				operation = tmp;
				break;
			}
		}

		if (operation == null)
			return null;

		EList ownedParameters = operation.getOwnedParameters();
		DataType operandeType = null;
		for (Object object : ownedParameters) {
			Parameter param = (Parameter) object;
			if (!param.getDirection().equals(
					ParameterDirectionKind.RETURN_LITERAL)) {
				operandeType = facade.typeof(param);
				break;
			}
		}
		if (operandeType == null)
			return null;

		ArrayList<ICompletionProposal> results = new ArrayList<ICompletionProposal>();

		String compositeTypeName = VSLComplexTypeUtil
				.getCompositeType(operandeType);
		if (compositeTypeName != null) {
			if (compositeTypeName.equals(VSL.STEREOTYPE_CHOICE_TYPE)) {
				VSL_Choice_CompletionProposal choiceCompletion = new VSL_Choice_CompletionProposal();
				choiceCompletion.setDataType(operandeType);
				results.addAll(choiceCompletion.generateCompletionProposals(
						documentOffset, selectionRange, prefix));
			} else if (compositeTypeName.equals(VSL.STEREOTYPE_COLLECTION_TYPE)) {
				results.addAll(new VSL_Collection_CompletionProposal()
						.generateCompletionProposals(documentOffset,
								selectionRange, prefix));
			} else if (compositeTypeName.equals(VSL.STEREOTYPE_TUPLE_TYPE)) {
				VSL_Tuple_CompletionProposal tupleCompletion = new VSL_Tuple_CompletionProposal();
				tupleCompletion.setDataType(operandeType);
				results.addAll(tupleCompletion.generateCompletionProposals(
						documentOffset, selectionRange, prefix));
			} else if (compositeTypeName.equals(VSL.STEREOTYPE_INTERVAL_TYPE)) {
				results.addAll(new VSL_Interval_CompletionProposal()
						.generateCompletionProposals(documentOffset,
								selectionRange, prefix));
			}
		} else if (operandeType.getName().equals(
				MarteLib.PrimitivesTypes.BOOLEAN)) {
			results.addAll(new VSL_BooleanValue_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
		} else if (operandeType.getName().equals(
				MarteLib.PrimitivesTypes.DATETIME)) {
			results.addAll(new VSL_DateTime_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
		} else if (operandeType.getName().equals(
				MarteLib.PrimitivesTypes.INTEGER)) {
			results.addAll(new VSL_Integer_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
		} else if (operandeType.getName().equals(MarteLib.PrimitivesTypes.REAL)) {
			results.addAll(new VSL_Real_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
		} else if (operandeType.getName().equals(
				MarteLib.PrimitivesTypes.UNLIMITEDNATURAL)) {
			results.addAll(new VSL_UnlimitedNatural_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
		} else if (operandeType.getName().equals(
				MarteLib.PrimitivesTypes.STRING)) {
			results.addAll(new VSL_StringLiteral_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
		}

		return results;
	}
}
