/*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
   
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   - Moved String constant
 *     			- Added some context constant
 *******************************************************************************/

package com.cea.nfp.parsers.texteditor.vsldatatypes;


/**
 * 
 * @author T0081227 Francois NIZOU - 22 oct. 07 
 *
 */
public abstract interface IContext {


	public static final int NFP_VALUE_SPECIFICATION = 0;

	public static final int EXPRESSION = 1;

	public static final int ARITHMETIC_EXPR = 2;

	public static final int ARITHMETIC_TERM = 3;

	public static final int EXPONENTIATION_OP = 4;

	public static final int MULTIPLICATION_OP = 5;

	public static final int ADDITION_OP = 6;

	public static final int ARITHMETIC_OPERAND = 7;

	public static final int RELATIONAL_EXPR = 8;

	public static final int RELATIONAL_OPERAND = 9;

	public static final int RELATIONAL_OP = 10;

	public static final int BOOLEAN_EXPR = 11;

	public static final int BOOLEAN_TERM = 12;

	public static final int BOOLEAN_ATOM = 13;

	public static final int BOOLEAN_OPERAND = 14;

	public static final int NOT_OP = 15;

	public static final int OR_OP = 16;

	public static final int AND_OP = 17;

	public static final int CONDITIONAL_EXPR = 18;

	public static final int IF_TRUE_EXPR = 19;

	public static final int IF_FALSE_EXPR = 20;

	public static final int FUNCTION_EXPR = 21;

	public static final int FUNCTION_OP = 22;

	public static final int LITERAL = 23;

	public static final int NULL_VALUE = 24;

	public static final int DEFAULT_VALUE = 25;

	// public static final int BOOLEAN_VALUE = 26;
	public static final int INTERVAL = 27;

	public static final int VARIABLE = 28;

	public static final int MIN = 29;

	public static final int MAX = 30;

	public static final int NUMBER_LITERAL = 31;

	public static final int DATETIME_LITERAL = 32;

	public static final int TIME_STR = 33;

	public static final int HOUR = 34;

	public static final int MINUTE = 35;

	public static final int SECOND = 36;

	public static final int CENTISEC = 37;

	public static final int DATE_STR = 38;

	public static final int YEAR = 39;

	public static final int MONTH = 40;

	public static final int DAY_OF_MONTH = 41;

	public static final int DAY_STR = 42;

	public static final int NOW = 43;

	public static final int INTEGER = 44;

	public static final int REAL = 45;

	public static final int DOTDOT = 46;

	public static final int TUPLE = 47;

	public static final int TUPLEITEM = 48;

	public static final int COLLECTION = 49;

	public static final int UNLIMITEDNATURAL = 50;

	public static final int STRING_LITERAL = 51;

	public static final int BOOLEAN_LITERAL = 52;

	public static final int NULL_LITERAL = 53;

	public static final int DEFAULT_LITERAL = 54;

	public static final int INTEGER_LITERAL = 55;

	public static final int UNLIMITED_LITERAL = 56;

	public static final int REAL_LITERAL = 57;

	public static final int SCIENTIFIC_REAL = 58;

	public static final int INTERVAL_BOUND = 59;

	public static final int LITERAL_INTERVAL_BOUND = 60;

	public static final int CHOICE = 61;

	public static final int CHOSEN_ALTERNATIVE_NAME = 62;

	public static final int ENUMERATION = 63;

	public static final int VARIABLE_CALL_EXPR = 64;

	public static final int VARIABLE_DECLARATION = 65;

	public static final int PROPERTY_CALL_EXPR = 66;

	public static final int VARIABLE_NAME = 67;

	public static final int VARIABLE_DIRECTION = 68;

	public static final int TYPE_NAME = 69;

	public static final int INIT_EXPR = 70;

	public static final int NAMESPACE = 71;

	public static final int PROPERTY_NAME = 72;

	public static final int COND_EXPR = 73;

	public static final int TUPLE_INTERVAL_BOUND = 74;

	public static final int CHOICE_INTERVAL_BOUND = 75;

	public static final int EXPRESSION_INTERVAL_BOUND = 76;

	public static final int OPERATION_CALL_EXPR = 77;

	public static final int OPERATION_NAME = 78;

	public static final int ARGUMENT_VALUE = 79;

	public static final int DURATION_EXPR = 80;

	public static final int INSTANT_EXPR = 81;

	public static final int JITTER_EXPR = 82;

	public static final int INSTANT_OBS_EXPR = 83;

	public static final int DURATION_OBS_EXPR = 84;

	public static final int OBS_CALL_EXPR = 85;

	public static final int INSTANT_OBS_NAME = 86;

	public static final int OCCUR_INDEX_EXPR = 87;

	public static final int DURATION_OBS_NAME = 88;

	public static final int TIME_EXPR = 89;

	public static final int INSTANT_INTERVAL = 90;

	public static final int DURATION_INTERVAL = 91;

	public static final int OPERATION_SYMBOL = 92;

	// Added by THALES
	public static final int NAME_EXPRESSION = 93;

	public static final int OBS_EXPRESSION = 94;

	public static final int SINGLE_OBS_EXPR = 95;
    // end of addition
}
